/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.sa.common;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import ch.docuteam.darc.sa.SubmissionAgreement;


/**
 * This class represents a contact.
 * It contains an ID, a short name, a person, an organization, a department, a phone and a mail.
 *
 * @author denis
 *
 */
public class Contact extends NodeAbstract
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	private String		contactID;
	private String		organisation;
	private String		departement;
	private String		shortName;
	private String		person;
	private String		phone;
	private String		mail;

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	//	========	Constructors Private	=======================================================

	private Contact(SubmissionAgreement sa, Element element)
	{
		this.sa = sa;
		this.element = element;

		this.contactID = element.attributeValue("contactID");

		this.organisation = this.getElementText("SA:organisation", true);
		this.departement = this.getElementText("SA:departement", true);
		this.shortName = this.getElementText("SA:shortname", true);

		this.person = this.getElementText("SA:person", false);
		this.phone = this.getElementText("SA:phone", false);
		this.mail = this.getElementText("SA:mail", false);
	}

	//	========	Static Public			=======================================================

	static public List<Contact> parse(SubmissionAgreement sa, Element parent)
	{
		List<Contact> contacts = new ArrayList<Contact>();

		for (Object o: parent.selectNodes("./SA:contact"))		contacts.add(new Contact(sa, (Element)o));

		return contacts;
	}

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------

	public String getContactID()
	{
		return this.contactID;
	}

	public String getPerson()
	{
		return this.person;
	}

	public String getOrganisation()
	{
		return this.organisation;
	}

	public String getDepartement()
	{
		return this.departement;
	}

	public String getShortName()
	{
		return this.shortName;
	}

	public String getPhone()
	{
		return this.phone;
	}

	public String getMail()
	{
		return this.mail;
	}

	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------

	@Override
	public String toString()
	{
		return new StringBuilder("[Contact:")
			.append(this.organisation + "/")
			.append(this.departement + "/")
			.append(this.shortName + "/")
			.append(this.person + "/")
			.append(this.phone + "/")
			.append(this.mail + "]")
			.toString();
	}

	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
