/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.sa.dss;

import java.util.List;

import ch.docuteam.tools.string.StringSet;
import ch.docuteam.tools.string.StringSetElement;


/**
 * This class represents a <a href="./DataSubmissionSession.html">DataSubmissionSession</a> record type, one of
 * "Collection", "Dataset", "Event", "Image", "InteractiveResource", "MovingImage", "PhysicalObject", "Service", "Software", "Sound", "StillImage", or "Text".
 *
 * @author denis
 *
 */
public class DataSubmissionSessionRecordType extends StringSetElement
{
	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	static
	{
		new DataSubmissionSessionRecordType("Collection");
		new DataSubmissionSessionRecordType("Dataset");
		new DataSubmissionSessionRecordType("Event");
		new DataSubmissionSessionRecordType("Image");
		new DataSubmissionSessionRecordType("InteractiveResource");
		new DataSubmissionSessionRecordType("MovingImage");
		new DataSubmissionSessionRecordType("PhysicalObject");
		new DataSubmissionSessionRecordType("Service");
		new DataSubmissionSessionRecordType("Software");
		new DataSubmissionSessionRecordType("Sound");
		new DataSubmissionSessionRecordType("StillImage");
		new DataSubmissionSessionRecordType("Text");
	}


	//	========	Constructors Private	=======================================================

	private DataSubmissionSessionRecordType(String value)
	{
		super(value);
	}


	//	========	Static Public			=======================================================

	static public DataSubmissionSessionRecordType get(String value)
	{
		return (DataSubmissionSessionRecordType)StringSet.get(DataSubmissionSessionRecordType.class, value);
	}


	static public List<? extends StringSetElement> getAll()
	{
		return StringSet.getAll(DataSubmissionSessionRecordType.class);
	}

}

