/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.converter.admin;


/**
 * @author denis
 *
 * CHANGES HISTORY:
 *
 * Version 1.0.0:
 *
 *
 * -----	Commited into SVN:
 * 04.04.2014 (Denis):
 * Use tagged version of tools 1.10.0.
 * Tagged as Version 1.0.0.
 * 03.04.2014 (Andreas):
 * FileConverter: remove code that will append all available information as parameters, even if they were not specified in the configuration
 * config/migration-config.xml: add usage information, add "flac" file format, add application definition for PDF-Tools, disable video migration by default, clean formatting
 * unittest/migration-config_XXX.xml: clean formatting
 * 02.04.2014 (Denis):
 * Use current version of tools 1.10.0.
 * 28.03.2014 (Andreas):
 * unittest.converter.FileConverter_PDFToolsConverter: use test instance of PDF-Tools service
 * 27.03.2014 (Andreas):
 * config/migration-config.xml: simplify default parameters for openoffice
 * 26.03.2014 (Andreas):
 * extend with openoffice for linux
 * Use current version of tools 1.10.0 with correction:
 * 		os.SystemProcessCantLaunchApplicationException, os.SystemProcess: Throw specific exception when Desktop can't launch or associate an application with a file. * 21.03.2014 (Andreas):
 * extend migration-config files.
 * FileConverter: define some methods as public: calculateDestinationFilePath, getMigrationInstructions
 * 21.03.2014 (Günter):
 * update migration-config with word perfect puid and mimetype
 * 20.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		file.MetadataProviderDROID: Use current versions of DROID-signature and container-signature files.
 * 05.03.2014 (Denis):
 * unittest.converter.*: Adapted unittests for Linux.
 * Use current version of tools 1.10.0.
 * 04.03.2014 (Denis):
 * FileConverter$PDFToolsConverter: The PDFToolsConverter now checks by himself if the required VM argument "-Djava.library.path" exists and points to the correct folder.
 * 27.02.2014 (Denis):
 * FileConverter: Handle too long file paths under Windows by performing the conversion in the temp folder.
 * 17.02.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		gui.SystemOutView: Minor visual improvements in the GUI.
 * 13.02.2014 (Denis):
 * FileConverter$PDFToolsConverter: Include PDFTools Converter.
 * 12.02.2014 (Denis):
 * Initial version 1.0.0.
 *
 */
public abstract class Version
{
	static public final String Product = "docuteam converter";
	static public final String Number = "1.0.0";
	static public final String LastChange = "04.04.2014";

	/**
	 * This main method is being used by the ant build script to be able to add a version number to the compiled jar file.
	 *
	 * @param args No parameters are expected.
	 */
	public static void main(String[] args)
	{
		System.out.println(Number);
	}
}
