/**
 *	Copyright (C) 2011-2014 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.packer.admin;

/**
 * @author denis
 *
 * CHANGES HISTORY:
 *
 * Version 2.1.0:
 *
 *
 * -----	Committed into SVN:
 * 04.04.2014 (Denis):
 * Use tagged version of darc 2.12.0.
 * Use tagged version of converter 1.0.0.
 * Tagged as Version 2.1.0.
 * 02.04.2014 (Denis):
 * config_dist/documentPacker.properties: Add note that environment variables can be referenced in the property file.
 * Use current version of darc 2.12.0 with additional dynamic metadata elements:
 * 		accessPolicy
 * 		accessRestrictionExplanation
 * 		accessRestrictionPeriod
 * 		accessRestrictionClassification
 * 		accessRestrictionPrivacy
 * 		accessRestrictionStatus
 * 		accessRestrictionStatusExplanation
 * 26.03.2014 (Andi):
 * Use current version of converter 1.0.0 with support for openoffice on linux.
 * 25.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		os.SystemProcessCantLaunchApplicationException, os.SystemProcess:
 * 				Throw specific exception when Desktop can't launch or associate an application for a file.
 * French translation of this message still missing.
 * gui.LauncherView:
 * 		Display SIP size in Launcher right-aligned and in kB, not in bytes.
 * 		SIP list is now sortable.
 * 20.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		file.MetadataProviderDROID: Use current versions of DROID-signature and container-signature files.
 * 12.03.2014 (Denis):
 * resources/translations/Translations_fr: Corrections in french translation.
 * 11.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		file.FileUtil: Prohibit "..", as legal file name generally. Removed a remaining trace in "isFileNameAllowed()"
 * gui.SIPView: Fixed a bug when closing the SIPView with a modified document: the SIP was cleaned-up and unlocked before it was saved.
 * gui.LauncherView:
 * 		When creating a new SIP (from scratch or from template), reject if a SIP with this name already exists in the folder.
 * 		Fixed a memory leak: Clean-up files properly when creating a new SIP.
 * 06.03.2014 (Denis):
 * Use current version of darc 2.12.0.
 * Use current version of converter 1.0.0.
 * dist_src/.../Info.plist: Added key "CFBundleExecutable" value "docuteam packer" so that the distributed app can be renamed.
 * 25.02.2014 (Denis):
 * gui.SIPView: After inserting nodes, select one of the inserted nodes.
 * 24.02.2014 (Denis):
 * resources/translations/Translations_fr: Corrections in french translation.
 * 21.02.2014 (Denis):
 * gui.LauncherView, gui.SIPView: Improved and unified the way how to close dialogs with the ESC key.
 * 20.02.2014 (Denis):
 * gui.LauncherView$AboutView: Small visual improvements.
 * gui.LauncherView: When creating a copy of a SIP, user can choose if the copy is a zip, or not.
 * Use current version of darc 2.12.0 with extension:
 * 		mets.Document: Copy SIPs (folder or zip to folder or zip).
 * 19.02.2014 (Denis):
 * Use current version of darc 2.12.0 with extension:
 * 		mets.amdsec.AMDSection, mets.amdsec.DigiprovAbstract, mets.Document, mets.metshdr.Header, premis.Object:
 * 				Save Version.Product and Version.Number in the METS file.
 * resources: Renamed to "resources_dist".
 * resources/icons: Removed all colored balls icons Level0 - Level9.
 * config_dist/levels_standard_*.xml: Standard distribution uses only icons LevelUndefined, LevelSerie, LevelDossier, and LevelItem.
 * 19.02.2014 (Andi):
 * resources/translations: submit module and other selective strings
 * 18.02.2014 (Denis):
 * config_dist/levels_standard_*.xml: Corrections in english translation, define Level1.png - Level9.png als default icons for levels.
 * resources/images/Level*.png: Set the Level0.png - Level9.png icons to be colored balls.
 * 17.02.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		gui.SystemOutView: Minor visual improvements in the GUI.
 * 14.02.2013 (Denis):
 * gui.LauncherView: When initializing the SystemOutView, set the additionalInfoText even when the SystemOutView is not used.
 * gui.LauncherView$AboutView: Add version info of "docuteam converter".
 * 13.02.2013 (Denis):
 * build.xml, gui.FilePreviewer, gui.LauncherView: Switch from darc.util.FileConverter to converter.FileConverter.
 * gui.LauncherView, translations/Translations*.properties: The URL for the packer help page is now in the translation files.
 * 11.02.2014 (Denis):
 * Use current version of tools 1.10.0 with extensions:
 * 		os.SystemClipboard: New class. Can be used to get text from and put text into the system clipboard.
 * 		gui.SystemOutView:
 * 				Add "Copy" button to copy the content of the text area into the system clipboard.
 * 				Add method to optionally set an "additional info text" string, which is added to the text area string when copying the text to the clipboard.
 * 		file.PropertyFile: Add method "getKeys()";
 * gui.LauncherView: When copying the console text to the system clipboard, include version info, system info, user info, and the current properties from "docuteamPacker.properties".
 * 10.02.2014 (Denis):
 * Use current version of darc 2.12.0 with extension:
 * 		structmap.NodeFile: Added methods "replaceByFile(String)" and "replaceByFile(File)".
 * gui.SIPView, translations/Translations*.properties: Added action "replaceFileAction".
 * 06.02.2014 (Denis):
 * Refactoring: Renamed package "ch.docuteam.docupack" to "ch.docuteam.packer".
 * Use current version of darc 2.12.0.
 * Use tools 1.10.0 with corrections:
 * 		The methods javaTempDir() and userHome() now always return the file path with a trailing File.separator.
 * 04.02.2014 (Denis):
 * Use current version of Docudarc 2.11.4 with corrections:
 * 		mets.Document: Method "checkIngestFeedback()": Proper cleanup after feedback, including removal of the submitted zip file.
 * 03.02.2014 (Denis):
 * gui.LauncherView: Check ingest feedback on startup automatically.
 * Use current version of Docudarc 2.11.4 with corrections:
 * 		mets.Document: Method "checkSubmission()": distinguish between folders and zipped SIPs.
 * 31.01.2014 (Denis):
 * Use current version of Docudarc 2.11.4 with corrections:
 * 		mets.Document:
 * 				Include in "checkSubmission()" the test if the packet already exists in the submission folder.
 * 				Make "checkIngestFeedback()" more strict, and check zipped SIPs as well.
 * gui.SIPView, gui.LauncherView: Right-click first selects the item under the current mouse position, THEN opens the popup menu.
 * 30.01.2014 (Denis):
 * translation/*: Added translations for "MessageSubmitSIPExistsAlreadyInSubmitFolder".
 * Use current version of Docudarc 2.11.4 with correction:
 * 		mets.Document: When submitting, reject if SIP already exists in the submit folder.
 * 29.01.2014 (Denis):
 * dist_src/docuteam packer.app/Contents/Resources/Info.plist:
 * 		Add Key-Value-Pair "CFBundleExecutable"->"docuteam packer" so that the app can be renamed under OSX.
 * translation/*: Rename the tabs "Information" and "Metadata" to "Administration" and "Description (Beschreibung)"
 * gui.SIPView: In the tree view, remove the columns "Children count" and "Descendants count".
 * gui.SIPView: In the tree view, select the inserted node.
 * dist_src: Refactoring, added linux start script.
 * 27.01.2014 (Denis):
 * gui.LauncherView, translations/*:
 * 		The two dialogs "CreateNewSIP" and "CreateNewSIPFromTemplate" now contain a checkBox to define whether the SIP shall be zipped or not.
 * 24.01.2014 (Denis):
 * gui.SIPView: Fixed bug: in certain occasions it could happen that drag&drop within an SIP didn't work.
 * 23.01.2014 (Denis):
 * gui.SIPView: The tooltip text of a node now contains additional information whether the file is absent, unreadable or read-only.
 * Use current version of Docudarc 2.11.4 with correction:
 * 		mets.Document:
 * 				When submitting, zip the SIP without the enclosing folder.
 * 				Made method "boolean isZIPFile()" public.
 *  gui.LauncherView: HelpPageURL is now up-to-date.
 * 17.01.2014 (Denis):
 * gui.SearchView: Changed the order of the "search" text field and the "search in packets" text field.
 * All java sources: Change copyright message from "2011-2013" to "2011-2014".
 * Use current versions of Docudarc 2.11.4 with correction:
 * 		mets.Document: Correction in revert to the last saved document version.
 * 15.01.2014 (Denis):
 * gui.SIPView: Correction in method submit(): Better message before submitting.
 * Use current versions of Docudarc 2.11.4 with correction:
 * 		mets.Document: Correction in revert to the last saved document version: force-unlock the document before reverting.
 * 14.01.2014 (Denis):
 * gui.LauncherView: Fixed a small visual bug when renaming a packet.
 * Use current versions of Docutools 1.9.1 and Docudarc 2.11.4.
 * 08.01.2014 (Denis):
 * Use Docutools 1.9.1 with extensions:
 * 		gui.GUIUtil: new Class.
 * 		file.PropertyFile: Added new method get(String key, String ifAbsent, String ifEmpty) with additional option "ifEmpty".
 * gui.LauncherView:
 * 		When initializing folders, don't use "project home" as default, but "user home".
 * 		The default for the temp dir is now the folder "DocuteamPacker" in the java temp dir.
 * 		Create empty SIP dir if it doesn't exists.
 * 06.01.2014 (Denis):
 * translations: Correction in error messages.
 * 19.12.2013 (Denis):
 * gui.LauncherView, gui.SIPView: Correction in initialization of IngestSubmitDirectory and IngestFeedbackDirectory.
 * gui.LauncherView: Refresh views after submit feedback.
 * 13.12.2013 (Denis):
 * resources/translations/Translations*.*: Small corrections.
 * 04.12.2013 (Denis):
 * Use Docudarc 2.11.4 with correction:
 * 		mets.Document: Reset the lock when submit fails.
 * < 04.12.2013 (Denis):
 * Use Docudarc 2.11.2 with extension:
 * 		Redirect jul-logging via slf to log4j.
 * 		SubmitStatus.
 *		mets.Document: New methods: submit() and submitCheck().
 * updated license information on used libraries.
 * Use Docutools 1.9.0 with redesigned FileFilter.
 * Use Docudarc 2.11.2 with extension:
 * 		mets.Document: New method 'checkIngestFeedback(String ingestFeedbackFolderPath, String workspaceFolderPath)'.
 * gui.Launcher: Ingest-Feedback.
 * SIPView: Show submit status, trigger submitCheck and submit.
 * Use Docudarc 2.11.3.
 * gui.LauncherView, gui.SIPView, config_dist/docuteamPacker.properties:
 * 		Submit folder and ingest feedback folder can now be configured in docuteamPacker.properties.
 * 		Refactoring in method 'enableOrDisableActions()'.
 * gui.SIPView: Render the submit status in the tree view.
 * Use Docudarc 2.11.3 with correction:
 * mets.structmap.NodeAbstract: getDynamicMetadataElementInstancesToBeDisplayed():
 * 		Initialize empty dynamic metadata elements if necessary.
 * resources/translations/Translations*.*: Small corrections.
 * Use Docudarc 2.11.3 with correction:
 * mets.structmap.NodeAbstract: getDynamicMetadataElementInstancesToBeDisplayed():
 * 		Initialize empty dynamic metadata elements if necessary.
 * Use Docudarc 2.11.3 with correction:
 * 		ingest.AIPCreator: Interface.
 * 		ingest.AIPCreatorRosetta: Implementation of AIPCreator which replaces util.RosettaConverter:
 * 				Can now create Collections in addition to IEs.
 * 		ingest.AIPCreatorRosetta$DB: preparation.
 * 		ingest.AIPCreatorRosetta: feedback.
 * Use Docudarc 2.11.3 with correction:
 * 		ingest.AIPCreatorRosetta: Removed this and all related classes from this project (and moved to project DocuteamPackerETH).
 * gui.SIPView: Better user messages when submitting.
 * validators.MetadataElementValidatorStupid: Removed class.
 * Use Docudarc 2.11.4. with extension:
 * 		util.KeyAndValue: New class.
 * 		mdconfig.MetadataElement: allowedValues is now a List<KeyAndValue> and not any more a List<String>.
 * gui.SIPView: The DropDown lists contain now of a List<KeyAndValue> and not any more a List<String>.
 * gui.SIPView: Better tooltip text in tree view.
 * gui.SIPView: Take the version string displayed in the bottom right corner from the LauncherView.
 * gui.LauncherView: Improve column widths.
 * config_dist.docuteamPacker.properties: New property "docuteamPacker.AIPCreator.className".
 * gui.SIPView: Initialize AIPCreatorProxy with value from propertyFile.
 *
 * 2.0.1 (Denis/Andreas, 04.10.2013):
 * gui.LauncherView$AboutView: Extended AboutView with informations about OOO installation.
 * dist_src/docuteam packer.sh, dist_src/docuteam packer.app/Contents/MacOS/docuteam packer:
 * 		Added 'export LC_CTYPE="UTF-8"' to the scripts to avoid "?" in java file names with other than ascii characters.
 * Use Docudarc 2.11.2 with correction:
 * 		If the default OO installation is absent and no external OO application path was supplied, assume that the OO Converter shall not be used.
 * gui.FilePreviewer: Handle the case that the OO Converter is not available.
 * corrected French translations (Julien)
 * Use Docudarc 2.11.2 with correction:
 * 		util.FileConverter: Fast initialization:
 * 		When initializing the OOConverter in a separate thread AND the service is being requested, wait for the initialization to finish.
 * Use Docutools 1.8.4 with extension:
 * 		file.PropertyFile: Resolve environment variables in propertyFile values.
 * gui.LauncherView: Cleanup initialization() method and accelerate startup by using util.FileConverter's fast initialization.
 * Rebranding: Docupack -> docuteam packer.
 * Created Tag: Version 2.0.1
 *
 * 2.0.0 (Denis, 29.08.2013):
 * gui.LauncherView: New main window in Docupack.
 * translations/*: Translations of new functionality.
 * admin.Version, gui.LauncherView, gui.LauncherView$AboutView, gui.SIPView, gui.MainView, gui.MainView$AboutView, resources/gui/images/*:
 * 		Change product name from "Docupack" to "docuteam packer", use new Logo.
 * Use Docudarc 2.11.2 with correction:
 * 		Throw an Exception when saving the SIP while a file or folder inside the SIP is in use, e.g. by another application or the Win7 file explorer.
 * gui.LauncherView: Changed the access modifier of some methods so they can be used by subclasses.
 * gui.SIPView$TableTransferHandler: Drag&Drop.
 * gui.LauncherView: Initialize SIPView with property file.
 * Use Docudarc 2.11.2 with correction:
 * 		Access to Levels is not via static methods any more, but via instances of LevelOfDescriptionSet.
 * 		Added instance variable "protected LevelOfDescriptionSet levels" to DocumentAbstract. Each document has now its own LevelOfDescriptionSet.
 * gui.LauncherView, gui.SIPView: Launcher redesign.
 * gui.LauncherView: New action "rereadWorkspaceFolder".
 * resources/images/Open.png, OpenReadOnly.png: New icons for opening SIPs.
 * Use Docudarc 2.11.2 with extension: Search within the SIP.
 * gui.SIPView: Search within the SIP.
 * Use Docutools 1.8.4 with new class string.Pattern.
 * gui.LauncherView: Workspace search.
 * gui.LauncherView: Make workspace search available only in development mode for now.
 * Use Docudarc 2.11.2 with corrections:
 * 		mets.Document: Corrected inconsistency when setting KeepBackupsCount: When now trying to set to null, ignore it and leave as is.
 * 		mets.Document: Allow to open a folder. Assume there is a mets.xml file within and open this.
 * build.xml, dist_src: Move build from "Docupack" to "docuteam packer".
 * resources/images/*, gui.*View, dist_src/*: Renamed images Docupack.* to DocuteamPacker.*.
 * gui.SearchView: Fixed a bug where under Windows, the SearchView loses the focus after the search.
 * gui.SIPView: Show a message when the original SIP is missing while saving with backup.
 * gui.LauncherView: Small corrections when shutting down.
 * gui.SearchView: When searching, skip folders that don't contain a mets.xml file.
 * gui.LaunchView, gui.SearchView, gui.SIPView: Small visual corrections.
 * Created Tag: Version 2.0.0
 *
 * 1.6.3 (Denis, 27.07.2013):
 * Tagged Version with new OS X Application package structure but without LauncherView.
 *
 * 1.6.2 (Andreas, 06.02.2013):
 * Use Docudarc 2.11.1 which allows any premis event types and outcomes.
 * gui.MainView: generally display premis.outcome for events in table.
 *       (Denis, 02.07.2013):
 * Small visual corrections.
 * Use Docudarc 2.11.1 with MetadataElementValidatorShort and additional dynamic metadata elements.
 * config_dist/levels.xml: Standard levels.xml.
 * resources/translations/Translations*.properties: Translation corrections.
 * gui.MainView: Simplified the popup menu: made it shorter and without submenu.
 * Use Docudarc 2.11.1 with the possibility to set the number of retries when initializing the OOConverter.
 * gui.MainView: Correction in the GUI when creating an empty folder.
 * Use Docutools 1.8.2 with correction in class FileUtil.
 * gui.MainView$MyTreeCellRenderer: Handle case that a node's level is null.
 * config_dist/levels.xml: Contains now all levels from Docustore and the ISAD(G) set of metadata for each level.
 * config_dist/levels_standard_*.xml: Translated standard levels.xml.
 * config_dist/levels.xml, config_dist/levels_standard_*.xml: Add kB, MB, and GB to dropdownlist metadata->material.
 * build.xml: Refactoring: create OS X Application package.
 * Use Docudarc 2.11.1 with bug fix when creating a copy of a C or ArchDesc element.
 * gui.MainView: Fixed a bug when dragging a String into the tree.
 * Use Docudarc 2.11.1 with possibility to convert a BAR-SIP to a Matterhorn-SIP.
 * gui.FilePreviewer: Fixed a bug where an exception was thrown when a file without mimetype was rendered.
 * Use Docudarc 2.11.1 with corrections:
 * 		structmap.NodeFolder: Bug fix: When creating a new SIP, the root folder's access rights are now set correctly.
 * 		config_dist/levels*.xml: Set the level "Undefined" as the first default-sublevel for the level "Undefined".
 * gui.MainView:
 * 		When encountering an exceptionCollectorExceptions while creating a new SIP, continue, don't stop, but show a warning.
 * 		Refactoring and unification in exception handling.
 * gui.MainView: From the "New SIP" dialog, the user can now create an empty SIP.
 * Use Docudarc 2.11.1 with corrections: Adapted to Java 7.
 * Use Docudarc 2.11.1 with correction in SystemOutRedirector: When redirecting SYSOUT, the log4j logs are now redirected, too.
 * gui.MainView: initialize(CommandLine): Don't use Logger before it is correctly initialized.
 * gui.SearchView: Facade of a possible search view.
 * gui.LauncherView: Facade of a possible launcher view.
 * Use Docudarc 2.11.1 with corrections:
 * 		Use Docutools 1.8.4 with correction when opening a file externally in Windows.
 * 		Use Docutools 1.8.4 with extended SmallPeskyMessageWindow and SmallPeskyProgressBarWindow which can now block the underlying parent window.
 * While saving/reading/inserting, block the main window using the new SmallPeskyMessageWindow.
 * gui.MainView, config_dist/docupack.properties: Different file paths for Windows and OSX.
 * gui.MainView: When exporting files or folders, don't delete possibly existing files in the destination folder (= merge).
 * config_dist/docupack.properties: Set the max. number of backups; exeeding backups will be deleted.
 * gui.MainView, gui.FilePreviewer: Small visual improvements in tab "Metadata" and "Preview".
 * Use Docutools 1.8.4 with correction:
 * 		gui.JTableWithSpecificCellEditorPerRow: Added method "commitOrCancelCurrentCellEditor()" to commit (or cancel if commit fails) the current cell editor.
 * build.xml: Don't overwrite config_dist/log4j.xml when getting Docudarc.
 * Use Docudarc 2.11.2 with correction:
 * 		When the file converter fails, throw now an exception instead of just returning an error code.
 *
 * 1.6.1 (Denis, 05.02.2013):
 * Use Docudarc 2.10.1 with Docutools 1.8.0.
 * Use Docudarc 2.10.2 with initialization of dynamic metadata when creating a SIP from a template.
 * All java sources: Change copyright message from "2011-2012" to "2011-2013".
 * Use Docudarc 2.10.2 with lazy initialization of LevelOfDescription, new DROID (Version 6.1), and a bug fix when creating a new SIP.
 * Use Docudarc 2.11.0 with the possibility to open SIPs read-only.
 * Use Docudarc 2.11.0 with possibility to set the document's submission agreement.
 * mets.Document: Test or assign SA to document.
 *
 * 1.6.0 (Denis, 14.12.2012):
 * Use Docudarc 2.9.5 with PID as dynamic metadata.
 * gui.MainView: Remove textField "PID".
 * config_dist/levels.xml: Add "PID" to MetadataElements.
 * gui.MainView: When changing a node's level, initialize dynamic metadata if necessary and possible.
 * gui.MainView$TextFieldTableCellEditor: End editing in dynamic metadata table when editor loses focus. (still under development)
 * gui.MainView$MetadataTableModel: Fixed a memory leak when using a combo box editor in the dynamic metadata table.
 * config_dist/levels.xml: Add "unitTitleAdditional" to MetadataElements.
 * Use Docudarc 2.9.5 with Docutools 1.7.0.
 * gui.MainView, gui.FilePreviewer: Adapted to new exception handling in FileUtil.
 * gui.MainView: Show files and folders with restricted access (not writable, not readable, not present) with a colored background in the tree view.
 * gui.MainView: Restrict operations depending on access restrictions of current node, its predecessors, and its descendants.
 * gui.MainView, config_dist/docupack.properties: Versioning (saving with or without backups) can be switched on and off.
 * gui.MainView: Disable "saveAs" action when document contains unreadable files.
 * Use Docudarc 2.9.5 with Docutools 1.7.1.
 * gui.MainView$TextAreaTableCellEditor: Stop editing when the user hits the alt-tab or alt-enter key. On alt-tab, the next table row gets selected.
 * gui.MainView$MyTreeCellRenderer: Improved tree cell rendering implementation.
 * gui.MainView, gui.MainView$MyTreeCellRenderer: Use org.jdesktop.swingx.decorator.Highlighter to color rows in the treeTable.
 * gui.MainView: Fixed a bug when enabling/disabling Buttons.
 * config_2/*: Added alternative configuration folder.
 * gui.MainView, translations/Translations*.properties: Adjusted and cleaned up translation tables.
 * gui.MainView$TableTransferHandler: Bug fix: importing files and folders using D&D was disabled - it is now re-enabled and respects file access permissions.
 * config_dist/docupack.properties: When setting the folder of the OOO application for converting files, now only the location of the "OpenOffice.org" folder must be provided, not the complete path to the executable file within.
 * gui.MainView: Bug fix: When inserting a new folder, don't restrict to only "safe" characters for the folder name.
 * gui.FilePreviewer: Bring "separate preview" window to the front when clicking on the "Open Separately" button.
 * gui.MainView, translations/Translations*.properties: ToolTipText for dynamic metadata comboBox.
 * gui.MainView: Bug fix: When closing a SIP, opening another SIP, or creating a new one, the previously opened SIP now gets correctly unlocked.
 * Use Docudarc 2.9.5 with improved file and exception handling.
 * gui.MainView: Added shutdown hook for cleaning up even in a forced shutdown situation.
 * Use Docudarc 2.9.5 with improved dynamic metadata handling: Initialize mandatory & repeatable dynamic metadata elements which have no instance, with one empty instance.
 * Use Docudarc 2.9.5 with new level property "boolean isAlwaysDisplayed".
 * gui.MainView: When opening a SIP, now the file selector allows just ZIP files or folders which contain a mets.xml file.
 * Use Docudarc 2.9.5 with dynamic metadata elements that have translated tooltip texts.
 * gui.MainView, gui.MainView$MetadataTableModel, gui.MainView$JTableForDynamicMetadataInstances:
 * 		Display translated metadata tooltip texts in the MetadataTable.
 * gui.MainView$JTableForDynamicMetadataInstances: Renamed to gui.MainView$MetadataTable
 * gui.MainView: Ask if to overwrite existing files or folders when exporting.
 * Use Docudarc 2.9.5 with deletion of all metadata when creating a template from a SIP.
 * gui.MainView$TextAreaTableCellEditor: Use the TAB-Key instead of the Alt-TAB-Key to leave the edit modus and commit the editor changes.
 * Use Docudarc 2.9.5 with new level property "boolean keepInTemplate"
 * 		and with deletion of all metadata except those marked with "keepInTemplate='true'" when creating a template from a SIP.
 * gui.FilePreviewer$FilePreviewPanel: Bug fix: Under windows sometimes a temporary file for rendering documents could not be reused.
 * gui.MainView, translations/Translations*.properties: Optional label for InsertDynamicMetadata ComboBox.
 * gui.FilePreviewer$FilePreviewPanel, gui.FilePreviewer$FilePreviewPanel$FileType:
 * 		Refactoring: to retrieve the file type for previewing, FIRST check the PUID, THEN the MIME type, and FINALLY the file extension.
 * gu.MainView: Subclasses can define own version strings.
 * Use Docudarc 2.9.5 with: When creating a new node, set the unitTitle to the node's label (= file name), if the node is a folder.
 * 			If the node is a file, cut away the label's extension.
 * gui.MainView$MetadataTableModel: Dynamic Metadata table: To open a ComboBox in the metadata table, double-click it now (before: single-click).
 * gui.MainView$MetadataTableModel: Dynamic Metadata table: When the first item of a ComboBox list is a "*", this ComboBox is editable.
 * Use Docudarc 2.10.0 with: Initialization of a new subelement's level with the parent level's defaultSubLevel. Before: "Undefined".
 * resources/images: Added new icon "Packet.png" and replaced "MenuFile.png".
 * Use Docudarc 2.10.0 with new methods: isValidSIPFolder(File) and isValidSIPFolder(String).
 * gui.MainView$SIPFileChooser: Improved FileOpenDialog by showing SIPs with a different icon and making SIP folders not traversable (= can not enter).
 * gui.FilePreviewer, gui.FilePreviewer$FilePreviewPanel: Cleanup temp-folder on startup, because under Windows, cleaning-up on shutdown doesn't work.
 * gui.MainView, config_dist/docupack.properties, translations/*: Move all "Template" functionality from project DocupackETH to here.
 *
 * 1.5.5 (Denis, 08.10.2012):
 * gui.MainView: Refactoring: Modify the static methods so that a subclass of MainView can be instanciated.
 * gui.MainView: The fileMenu is now a protected MainView instance variable so it can be accessed (and modified) by subclasses.
 * gui.MainView: Integrating document locking into GUI.
 * gui.MainView: Show message when opening SIPs if nodes exist with empty mandatory values.
 * gui.MainView: In Development Mode, add to menu "File" new menu entry: "SystemOut Document".
 * config_dist/levels.xml, config_dist/levels.xsd: Add "AllowedValuesSeparator" to "levels.xml".
 * gui.MainView: JTextArea as TableCellEditor.
 * Use Docudarc with Docutools 1.6.5.
 * gui.MainView$JTableWithSpecificCellEditorPerRow: Remove class, use the same class from Docutools 1.6.5 instead.
 * gui.MainView$MetadataTableModel: Implements now interface "TableModelWithSpecificCellEditorPerRow" from Docutools 1.6.5.
 * gui.MainView: All tables have now a light-gray grid.
 * gui.MainView: Fixed memory leak when displaying dynamic metadata list.
 * gui.MainView, gui.FilePreviewer: Preview in separate window.
 * gui.MainView$TableTransferHandler: Allow moving multiple files and folders with D&D.
 * gui.MainView, config_dist/docupack.properties: It is now possible to set a backup folder where all backups are made into.
 * gui.MainView, gui.FilePreviewer: Opening a file externally opens a copy of this file in the temp folder.
 * gui.MainView, gui.FilePreviewer: Don't allow to open a folder externally.
 * gui.MainView: Export (for now, only one single file or folder).
 * mets.Document: Correction in the template handling: Unlock the template and cleanup after creating a template.
 *
 * 1.5.4 (Denis, 17.09.2012):
 * Use Docudarc 2.9.3. Integrate all remaining dynamic metadata fields.
 *
 * 1.5.3 (Denis, 22.08.2012):
 * gui.MainView: When changing an item's file name, use FileUtil.isFileNameAllowed() instead of FileUtil.asSafeFileName(). This allows more special characters.
 * gui.MainView$AboutView: Small visual correction.
 *
 * 1.5.2 (Denis, 09.08.2012):
 * config_dist/levels.xml: Define the Docuteam standard levels.
 * gui.MainView: Refactoring to make method overriding easier.
 * *.*: Moved everything related to ETH to the project DocupackETH.
 * gui.MainView: Added new button "Close". Refactoring.
 *
 * 1.5.1 (Denis, 06.08.2012):
 * Use ICEpdf library for PDF preview.
 * gui.MainView: Add menu entry "Docupack/Help" that opens the Docuwiki:Docupack webpage in the browser.
 * gui.MainView: Use class OSXAdapter to handle Mac OS X "cmd-q" and "About" menu entry.
 * gui.MainView: Veto on "close window" action is now possible.
 * Initialization of mandatory dynamic metadata elements happens now only when a new file or folder gets inserted into the tree.
 * MetadataElements are listed in the order in which they appear in the level.xml file.
 * gui.MainView$CreateNewMetsDialog: Added new text field for SIP name.
 * gui.MainView$CreateNewMetsDialog: Before creating a new SIP, check if the destination folder lies within the source folder.
 * gui.MainView$CreateNewMetsDialog: Before creating a new SIP, check if the destination folder is not empty and - if yes - aks if to delete it.
 * Detach a node's label (= fileName) from its unitTitle. Initialize the unitTitle with the fileName omitting the file extension.
 * gui.MainView: The AcquisitionNr can now be entered for every node in the Metadata tab.
 * gui.MainView$FileDataViewTableModel: Removed rows "PID" and "AcquisitionNr" from Info tab (both are now in the Metadata tab).
 * Use Docutools 1.5.5. This version includes the possibility to suppress the automatic popping-up of the SystemOutView when output occurs.
 * gui.MainView: Switch on or off the automatic popping-up of the SystemOutView using the property file ("docupack.openSystemOutViewOnOutput").
 * gui.MainView$FileStructureTreeTableModel: Display in the tree a column showing if some mandatory dynamic metadata elements of this node are empty.
 * gui.MainView: Different default startup screen size (1000 x 600) and position (centered). Before: (1000 x 800) and (100 x 100).
 * gui.MainView: Initialize OOConverter in a background thread in some circumstances.
 * gui.MainView: Use and display only canonical or absolute file names, no relative file names.
 * gui.MainView: Delete multiple items.
 * gui.MainView: AccessNr is now a dynamic metadata field.
 * gui.MainView: Added new menu entry: "Refresh node". Added new main menu entry: "Window".
 * licences.*: Added required software licenses to the project.
 * gui.MainView: Added context menu to tree.
 * gui.MainView, gui.FilePreviewer: Simplify the handling of mouse clicks in the tree view.
 * gui.MainView: Use deleteOnExit() instead of delete() for cleaning-up.
 * gui.MainView: Improved error message when SA can't be opened externally.
 * lib: Added library 'jai_imageio-1.1.jar' to be able to render the french version of 'documentation_docuteam.pdf'.
 * Use Docutools 1.6.0.
 *
 * 1.5.0 (Denis, 28.06.2012):
 * Improve handling of default directories when opening, saving, and creating SIPS, and when inserting files or folders.
 * 		NOTE: config/docupack.properties has changed!
 * All Dialogs can now be closed with the ESC key.
 * Cleanup. Make as many internal classes as possible static.
 * Use lib.commons-cli-1.2 to parse command line arguments.
 * gui.MainView: Extend usage of command line parameters: can specify now -open, -configDir, and -help.
 * Use Docutools 1.5.0.
 * Use Docudarc 2.8.0.
 * In the tree, the items can now be expanded and collapsed using the cursor keys.
 * gui.MainView: Reorganized method readPropertyFileAndInitialize() so that the JODConverter message "INFO: connected" doesn't appear in the SystemOutViewer.
 * Use Docudarc 2.9.0.
 * gui.MainView: Switched to LevelOfDescription configuration using levels.xml (before: Levels.csv).
 * gui.MainView: Level logic.
 * gui.MainView: Use the document's property "isModified" to display the "isModified" message.
 * Use Docudarc 2.9.0d.
 * gui.MainView: New Dynamic Metadata tab. (still under construction)
 * resources.translations.Translations_fr.properties: Improved french translation
 * gui.MainView: When changing an element's level of description, set/unset some of the dynamic metadata.
 * gui.MainView: Can now create a new SIP as a folder, not only as a ZIP file.
 * gui.MainView: Getting the current SAs from the server on startup can now be swiched on and off using a property in the property file.
 * scripts.Docupack.bat: Added a batch file to run Docupack under Windows with additional parameters.
 * gui.MainView: When creating a new SIP, show a message and don't create SIP if the destination folder already exists and is not empty.
 *
 * 1.4.10 (Denis, 03.05.2012):
 * Use Docudarc 2.7.5.
 * Use ScrollableMessageDialog when showing Message that SIP can not be created.
 * SplashScreen is not any more at the top of ALL windows.
 * When inserting files and folders, display filename currently being inserted.
 * Show progress while reading a SIP.
 * When inserting new folders or renaming files or folders, bad characters in entered filename are now handled correctly.
 * Restructured the menu and added menu icons.
 * Refactoring: The translation tables are now not java classes but property files.
 * When SA server can't be reached, show translated error message.
 *
 * 1.4.9 (Denis, 13.04.2012):
 * Use Docudarc 2.7.4.
 * The folder for temporary files can now be configured using the property "docupack.tempFolder" in the property file "docupack.properties".
 * Bug Fix in Docutools.util.FileUtil.
 *
 * 1.4.8 (Denis, 29.03.2012):
 * Bug fix: After changing the AcquisitionNo, the view was not refreshed when using windows.
 * All sources: Changed the copyright message from 2011 to 2011-2012.
 * Use Docudarc 2.7.3.
 * Cleanup SubmissionAgreements on startup (after confirmation).
 * gui.MainView: Improved handling of level icons.
 *
 * 1.4.7 (Denis, 20.02.2012):
 * Use Docudarc 2.7.1.
 * The default folders for insert and save are now "user.home" (before: ".") as long as nothing else is specified in the property file.
 *
 * 1.4.6 (Denis, 08.02.2012):
 * Allow multiple selections in the tree and be able to assign a levelOfDescription to all selected items.
 * Assign levelOfDescriptions to the selected node's sub*-levels.
 * Cleanup in the "tableItemWasSelected" method.
 * Assign levelsOfDescription to the selected node's sub*-levels according to the label name (if file -> "Item", if numeric prefix -> "Series", else "Dossier").
 * ExpandAll and CollapseAll.
 * Display files and folders in the tree view with different fonts and colors.
 * Disable DnD when multiple items are selected.
 * Fixed: Menu entry "Save As" did the same as menu entry "Save".
 * Use Docudarc 2.7.0.
 *
 * 1.4.5 (Denis, 21.12.2011):
 * Introduced new Menu "Docupack" containing "About Screen", "Quit Action", and "Open Error Console".
 * Remove "About Screen" and "Open Error Console" from alt-klick on Docupack Logo and Version number.
 * Use Docudarc 2.6.4 (corrected version).
 * Use image 'Docupack.png' as the windows icon for all windows when using Docupack under MS Windows.
 *
 * 1.4.4 (Denis, 15.12.2011):
 * Use Docudarc 2.6.4.
 * User can now export to EAD including levelsOfDescription and acquisitionNo.
 * User can now export to EAD including PID.
 * GUI optimization and bug fixes.
 * Fixed a bug in build.xml: after building, 'run' was not possible any more without a previous 'clean'.
 *
 * 1.4.3 (Denis, 08.12.2011):
 * Use Docudarc 2.6.3.
 * User can now change the acquisitionNo.
 *
 * 1.4.2 (Denis, 06.12.2011):
 * Use Docudarc 2.6.2.
 * Show different icons in the tree view, depending on the node level.
 * Assign description levels to nodes - individually or per tree level.
 *
 * 1.4.1 (Denis, 16.11.2011):
 * Use Docudarc 2.5.0.
 * Get the SAs from the SA directory and not from overview.xml.
 * build.xml: Rename project from DocuPack to Docupack.
 *
 * 1.4.0 (Denis, 09.11.2011):
 * Improved button mnemonics: Use ctrl-modifier instead of alt-modifier.
 * Added default SA folder "agreements" in project root folder, containing an SA that allows all file types.
 * Use DocuDarc 2.4.1.
 * Save-as for documents.
 * Added about-screen.
 * Enabled drag&drop for files and folders.
 * log4j.xml: Add encoding parameter.
 * Terminated Beta-state :-)
 *
 * 1.4.0b10 (Andreas, 03.11.2011):
 * Use DocuDarc 2.3.3.
 *
 * 1.4.0b9 (Denis, 28.10.2011):
 * Use DocuDarc 2.3.0.
 * Insert copyright message into all sources.
 * Remember directory when selecting files to insert, or mets-file to load.
 * Can now insert multiple files at once.
 * Save-as button.
 * Delete-button asks if to delete; when pressing shift, not.
 * PDF-Preview: Can now enter page number to preview.
 * Button mnemonics: Alt-s for save, Alt-o for open, Alt-n for new document, Alt-q for quit, Alt-del for delete item, etc.
 *
 * 1.4.0b8 (Andreas, 27.10.2011):
 * Use DROID_SignatureFile_V52.xml
 *
 * 1.4.0b7 (Denis, 26.09.2011):
 * The LookAndFeel can now be configured in the property file docupack.properties (property docupack.useSystemLookAndFeel).
 *
 * 1.4.0b6 (Denis, 29.07.2011):
 * Use DocuDarc 2.2.7 (which contains the OOO Apps).
 * Renamed folder config_gen to config_dist and adapted build.xml accordingly.
 * Corrected build.xml (use 'exec unzip' to extract the OS X OOO package because the ant task 'unzip' doesn't preserve the file permission 'executable').
 * Corrected build.xml (use 'exec zip' to create zips because the ant task 'zip' doesn't preserve the file permission 'executable').
 *
 * 1.4.0b5 (Denis, 26.07.2011):
 * Use DocuDarc 2.2.6 (using DocuTools 1.3.5 (bug fix in class JTableWithDynamicToolTipTexts)).
 * Can now change language during runtime (except for the toolTipTexts and the treeView headers).
 *
 * 1.4.0b4 (Denis, 24.06.2011):
 * Use DocuDarc 2.1.26.
 * Improved gui.FilePreviewer's initialization and cache.
 *
 * 1.4.0b3 (Denis, 22.06.2011):
 * Use DocuDarc 2.1.25.
 * Data tables now have toolTipTexts showing the cell content.
 * Created class gui.FilePreviewer, taking the file preview functionality out of the class MainView.
 *
 * 1.4.0b2 (Denis, 06.06.2011):
 * File Preview (not yet finished):
 * 			Can preview all text-files, HTML, GIF, PNG, and JPEG
 * 			Can now preview PDFs (using pdf-renderer 1.0.5)
 * 			Can now preview RTFs and MS Office documents (using OOo API converter)
 * 			Can now preview other graphic formats like BMP and TIFF (using JAI - Java Advanced Imaging)
 * 			Can now preview more graphic formats like PSD (using JIMI)
 * 			Can now resize the preview
 * 			Can now preview more graphic formats like EPS (using ImageMagick)
 * 	Use DocuDarc 2.1.22.
 *
 * 1.3.9 (Denis, 18.05.2011):
 * Relative file sizes are displayed as bars of different width.
 *
 * 1.3.8 (Denis, 18.05.2011):
 * Internationalization D and F.
 * All buttons now have icons in addition to labels.
 *
 * 1.3.7 (Denis, 18.04.2011):
 * Use DocuDarc 2.1.17.
 *
 * 1.3.6 (Denis, 18.04.2011):
 * Using DocuDarc 2.1.16.
 * Added button [Show SA Externally]
 *
 * 1.3.5 (Andreas, 05.04.2011):
 * Use DocuDarc 2.1.10.
 *
 * 1.3.4 (Denis, 24.03.2011):
 * Show small info window when inserting files or folders.
 * When creating a new SIP, create a ZIP archive instead of a folder.
 * Use DocuDarc 2.1.5.
 *
 * 1.3.3 (Denis, 17.03.2011):
 * Open the SystemOutView when alt-clicking the logo button.
 *
 * 1.3.2 (Denis, 10.03.2011):
 * Output in case of errors and warnings improved (not yet finished).
 * Use DocuDarc 2.1.1.
 */
public abstract class Version
{
	static public final String Product = "docuteam packer";
	static public final String Number = "2.1.0";
	static public final String LastChange = "04.04.2014";

	/**
	 * This main method is being used by the ant build script to be able to add a version number to the compiled jar file.
	 *
	 * @param args: No parameters are expected.
	 */
	public static void main(String[] args)
	{
		System.out.println(Number);
	}

}
