/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.domesdaybook.reader.ByteReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedByteArray;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedByteArrays;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedBytes;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.ResourceUtils;

public class ContainerFileIdentificationRequest
implements IdentificationRequest {
    private static final int BUFFER_CACHE_CAPACITY = 10;
    private static final int CAPACITY = 51200;
    private Long size;
    private CachedBytes cachedBinary;
    private File tempFile;
    private int lruCapacity;
    private int bufferCapacity;
    private File tempDir;
    private Log log = LogFactory.getLog(this.getClass());

    public ContainerFileIdentificationRequest(File tempDir) {
        this(10, 51200, tempDir);
    }

    ContainerFileIdentificationRequest(int lruCapacity, int bufferCapacity, File tempDir) {
        this.lruCapacity = lruCapacity;
        this.bufferCapacity = bufferCapacity;
        this.tempDir = tempDir;
    }

    public final void open(InputStream in) throws IOException {
        byte[] firstBuffer = new byte[this.bufferCapacity];
        int bytesRead = ResourceUtils.readBuffer((InputStream)in, (byte[])firstBuffer);
        if (bytesRead < 1) {
            firstBuffer = new byte[]{};
            this.cachedBinary = new CachedByteArray(firstBuffer, 0);
            this.size = 0L;
        } else if (bytesRead < this.bufferCapacity) {
            this.cachedBinary = new CachedByteArray(firstBuffer, bytesRead);
            this.size = bytesRead;
        } else {
            this.cachedBinary = new CachedByteArrays(this.lruCapacity, this.bufferCapacity, firstBuffer, this.bufferCapacity);
            this.tempFile = ArchiveFileUtils.writeEntryToTemp((File)this.tempDir, (byte[])firstBuffer, (InputStream)in);
            this.cachedBinary.setSourceFile(this.tempFile);
            this.size = this.tempFile.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        block5: {
            block6: {
                try {
                    if (this.cachedBinary != null) {
                        this.cachedBinary.close();
                        this.cachedBinary = null;
                    }
                    if (this.tempFile == null) break block5;
                    if (this.tempFile.delete() || !this.tempFile.exists()) break block6;
                }
                catch (Throwable throwable) {
                    if (this.tempFile != null) {
                        if (!this.tempFile.delete() && this.tempFile.exists()) {
                            String message = String.format("Could not delete temporary file [%s] for container identification.Will try to delete on exit.", this.tempFile.getAbsolutePath());
                            this.log.warn((Object)message);
                            this.tempFile.deleteOnExit();
                        }
                        this.tempFile = null;
                    }
                    throw throwable;
                }
                String message = String.format("Could not delete temporary file [%s] for container identification.Will try to delete on exit.", this.tempFile.getAbsolutePath());
                this.log.warn((Object)message);
                this.tempFile.deleteOnExit();
            }
            this.tempFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public final byte getByte(long position) {
        return this.cachedBinary.readByte(position);
    }

    public final String getExtension() {
        return null;
    }

    public final String getFileName() {
        return null;
    }

    public final long size() {
        return this.size;
    }

    CachedBytes getCache() {
        return this.cachedBinary;
    }

    public final InputStream getSourceInputStream() throws IOException {
        return this.cachedBinary.getSourceInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File getSourceFile() throws IOException {
        if (this.tempFile == null) {
            InputStream stream = this.cachedBinary.getSourceInputStream();
            try {
                this.tempFile = ResourceUtils.createTemporaryFileFromStream((File)this.tempDir, (InputStream)stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        return this.tempFile;
    }

    File getTempFile() {
        return this.tempFile;
    }

    public RequestMetaData getRequestMetaData() {
        return null;
    }

    public RequestIdentifier getIdentifier() {
        return null;
    }

    public final ByteReader getReader() {
        return this.cachedBinary;
    }
}

