/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public abstract class DateTimeConverter {
    public static final DateTimeConverter JAR;
    public static final DateTimeConverter ZIP;
    static final long MIN_DOS_TIME = 0x210000L;
    static final long MAX_DOS_TIME = 4288659325L;
    private final ThreadLocal calendar = new ThreadLocalGregorianCalendar();
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract TimeZone createTimeZone();

    protected abstract boolean roundUp(long var1);

    private GregorianCalendar getGregorianCalendar() {
        return (GregorianCalendar)this.calendar.get();
    }

    final long toDosTime(long jTime) {
        if (jTime < 0L) {
            throw new IllegalArgumentException("Java time is negative: 0x" + Long.toHexString(jTime).toUpperCase(Locale.ENGLISH));
        }
        GregorianCalendar cal = this.getGregorianCalendar();
        cal.setTimeInMillis(this.roundUp(jTime) ? jTime + 1999L : jTime);
        long dTime = cal.get(1) - 1980;
        if (dTime < 0L) {
            return 0x210000L;
        }
        if (4288659325L < (dTime = dTime << 25 | (long)(cal.get(2) + 1 << 21) | (long)(cal.get(5) << 16) | (long)(cal.get(11) << 11) | (long)(cal.get(12) << 5) | (long)(cal.get(13) >> 1))) {
            throw new IllegalArgumentException("Java time is later than 2107 AD: 0x" + Long.toHexString(jTime).toUpperCase(Locale.ENGLISH));
        }
        if (!($assertionsDisabled || 0x210000L <= dTime && dTime <= 4288659325L)) {
            throw new AssertionError();
        }
        return dTime;
    }

    final long toJavaTime(long dTime) {
        if (dTime < 0x210000L) {
            throw new IllegalArgumentException("DOS date/time is earlier than 1980 AD: 0x" + Long.toHexString(dTime).toUpperCase(Locale.ENGLISH));
        }
        if (4288659325L < dTime) {
            throw new IllegalArgumentException("DOS date/time is later than 2107 AD: 0x" + Long.toHexString(dTime).toUpperCase(Locale.ENGLISH));
        }
        int time = (int)dTime;
        GregorianCalendar cal = this.getGregorianCalendar();
        cal.set(1, 1980 + (time >> 25 & 0x7F));
        cal.set(2, (time >> 21 & 0xF) - 1);
        cal.set(5, time >> 16 & 0x1F);
        cal.set(11, time >> 11 & 0x1F);
        cal.set(12, time >> 5 & 0x3F);
        cal.set(13, time << 1 & 0x3E);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    static {
        $assertionsDisabled = !DateTimeConverter.class.desiredAssertionStatus();
        JAR = new DateTimeConverter(){

            protected TimeZone createTimeZone() {
                return TimeZone.getDefault();
            }

            protected boolean roundUp(long jTime) {
                return false;
            }
        };
        ZIP = new DateTimeConverter(){
            static final /* synthetic */ boolean $assertionsDisabled;

            protected TimeZone createTimeZone() {
                TimeZone tz = TimeZone.getDefault();
                tz = new SimpleTimeZone(tz.getRawOffset() + tz.getDSTSavings(), tz.getID());
                if (!$assertionsDisabled && tz.useDaylightTime()) {
                    throw new AssertionError();
                }
                return tz;
            }

            protected boolean roundUp(long jTime) {
                return true;
            }

            static {
                $assertionsDisabled = !(class$de$schlichtherle$util$zip$DateTimeConverter == null ? (class$de$schlichtherle$util$zip$DateTimeConverter = DateTimeConverter.class$("de.schlichtherle.util.zip.DateTimeConverter")) : class$de$schlichtherle$util$zip$DateTimeConverter).desiredAssertionStatus();
            }
        };
    }

    private final class ThreadLocalGregorianCalendar
    extends ThreadLocal {
        private ThreadLocalGregorianCalendar() {
        }

        protected Object initialValue() {
            return new GregorianCalendar(DateTimeConverter.this.createTimeZone());
        }
    }
}

