/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public enum DroidGlobalProperty {
    DEFAULT_THROTTLE("profile.defaultThrottle", PropertyType.INTEGER, true),
    DEFAULT_BINARY_SIG_FILE_VERSION("profile.defaultBinarySigFileVersion", PropertyType.TEXT, true),
    DEFAULT_CONTAINER_SIG_FILE_VERSION("profile.defaultContainerSigFileVersion", PropertyType.TEXT, true),
    DEFAULT_TEXT_SIG_FILE_VERSION("profile.defaultTextSigFileVersion", PropertyType.TEXT, true),
    BINARY_UPDATE_URL("pronom.update.url", PropertyType.TEXT, true),
    CONTAINER_UPDATE_URL("container.update.url", PropertyType.TEXT, true),
    TEXT_UPDATE_URL("text.update.url", PropertyType.TEXT, true),
    UPDATE_AUTO_CHECK("update.autoCheck", PropertyType.BOOLEAN, true),
    UPDATE_FREQUENCY_DAYS("update.frequency.days", PropertyType.INTEGER, true),
    UPDATE_ON_STARTUP("update.frequency.startup", PropertyType.BOOLEAN, true),
    UPDATE_USE_PROXY("update.proxy", PropertyType.BOOLEAN, true),
    UPDATE_PROXY_HOST("update.proxy.host", PropertyType.TEXT, true),
    UPDATE_PROXY_PORT("update.proxy.port", PropertyType.INTEGER, true),
    UPDATE_AUTOSET_DEFAULT("update.autoSetDefault", PropertyType.BOOLEAN, true),
    UPDATE_DOWNLOAD_PROMPT("update.downloadPrompt", PropertyType.BOOLEAN, true),
    LAST_UPDATE_CHECK("update.lastCheck", PropertyType.LONG, false),
    DEV_MODE("development_mode", PropertyType.BOOLEAN, false),
    PROCESS_ARCHIVES("profile.processArchives", PropertyType.BOOLEAN, true),
    PUID_URL_PATTERN("puid.urlPattern", PropertyType.TEXT, true),
    GENERATE_HASH("profile.generateHash", PropertyType.BOOLEAN, true),
    HASH_ALGORITHM("profile.hashAlgorithm", PropertyType.TEXT, true),
    CSV_EXPORT_ROW_PER_FORMAT("export.rowPerFormat", PropertyType.BOOLEAN, true),
    MAX_BYTES_TO_SCAN("profile.maxBytesToScan", PropertyType.LONG, true),
    EXTENSION_ALL("profile.matchAllExtensions", PropertyType.BOOLEAN, true),
    DATABASE_DURABILITY("database.durability", PropertyType.BOOLEAN, true);

    private static Map<String, DroidGlobalProperty> allValues;
    private String name;
    private PropertyType type;
    private boolean userConfigurable;

    private DroidGlobalProperty(String name, PropertyType type, boolean userConfigurable) {
        this.name = name;
        this.type = type;
        this.userConfigurable = userConfigurable;
    }

    public String getName() {
        return this.name;
    }

    public PropertyType getType() {
        return this.type;
    }

    boolean isUserConfigurable() {
        return this.userConfigurable;
    }

    public static DroidGlobalProperty forName(String key) {
        DroidGlobalProperty property = allValues.get(key);
        return property != null && property.isUserConfigurable() ? property : null;
    }

    static {
        allValues = new HashMap<String, DroidGlobalProperty>();
        for (DroidGlobalProperty prop : DroidGlobalProperty.values()) {
            allValues.put(prop.getName(), prop);
        }
    }

    public static enum PropertyType {
        TEXT{

            @Override
            public Object getTypeSafeValue(Configuration config, String key) {
                return config.getString(key);
            }
        }
        ,
        INTEGER{

            @Override
            public Object getTypeSafeValue(Configuration config, String key) {
                return config.getInt(key);
            }
        }
        ,
        BOOLEAN{

            @Override
            public Object getTypeSafeValue(Configuration config, String key) {
                return config.getBoolean(key);
            }
        }
        ,
        LONG{

            @Override
            public Object getTypeSafeValue(Configuration config, String key) {
                return config.getBigInteger(key);
            }
        };


        public abstract Object getTypeSafeValue(Configuration var1, String var2);
    }
}

