/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveEntryMetaData;
import de.schlichtherle.io.ArchiveFileSystemController;
import de.schlichtherle.io.Entry;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileFactory;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import java.io.CharConversionException;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;

final class ArchiveFileSystem
implements Entry {
    private static final String ROOT_DIRECTORY_NAME = "/";
    private final ArchiveFileSystemController controller;
    private final boolean readOnly;
    private Map master;
    private final ArchiveEntry root;
    private long touched;
    private final String[] split = new String[2];
    static final /* synthetic */ boolean $assertionsDisabled;

    ArchiveFileSystem(ArchiveFileSystemController controller) throws IOException {
        this.controller = controller;
        this.touched = 1L;
        this.master = new LinkedHashMap(64);
        this.root = this.createArchiveEntry(ROOT_DIRECTORY_NAME);
        this.root.setTime(System.currentTimeMillis());
        this.master.put(ROOT_DIRECTORY_NAME, this.root);
        this.readOnly = false;
        controller.touch();
    }

    ArchiveFileSystem(ArchiveFileSystemController controller, InputArchive archive, long rootTime, boolean readOnly) {
        this.controller = controller;
        int iniCap = (int)((float)archive.getNumArchiveEntries() / 0.75f) + 1;
        this.master = new LinkedHashMap(iniCap);
        this.root = this.createArchiveEntry(ROOT_DIRECTORY_NAME);
        this.root.setTime(rootTime);
        this.master.put(ROOT_DIRECTORY_NAME, this.root);
        Enumeration entries = archive.getArchiveEntries();
        while (entries.hasMoreElements()) {
            ArchiveEntry entry = (ArchiveEntry)entries.nextElement();
            String entryName = this.getEntryName(entry);
            if (ROOT_DIRECTORY_NAME.equals(entryName) || "./".equals(entryName)) continue;
            entry.setMetaData(new ArchiveEntryMetaData(entry));
            this.master.put(entryName, entry);
        }
        entries = archive.getArchiveEntries();
        while (entries.hasMoreElements()) {
            this.fixParents((ArchiveEntry)entries.nextElement());
        }
        this.readOnly = readOnly;
        if (readOnly) {
            this.master = Collections.unmodifiableMap(this.master);
        }
        if (!$assertionsDisabled && this.touched != 0L) {
            throw new AssertionError();
        }
    }

    private String getEntryName(ArchiveEntry entry) {
        return entry.getName().replace('\\', '/');
    }

    private static boolean isLegalEntryName(String entryName) {
        int l = entryName.length();
        if (l <= 0) {
            return false;
        }
        block0 : switch (entryName.charAt(0)) {
            case '/': {
                return false;
            }
            case '.': {
                if (l >= 2) {
                    switch (entryName.charAt(1)) {
                        case '.': {
                            if (l >= 3) {
                                if (entryName.charAt(2) != '/') break block0;
                                if (!$assertionsDisabled && !entryName.startsWith("../")) {
                                    throw new AssertionError();
                                }
                                return false;
                            }
                            if (!$assertionsDisabled && !"..".equals(entryName)) {
                                throw new AssertionError();
                            }
                            return false;
                        }
                        case '/': {
                            if (!$assertionsDisabled && !entryName.startsWith("./")) {
                                throw new AssertionError();
                            }
                            return false;
                        }
                    }
                    break;
                }
                if (!$assertionsDisabled && !".".equals(entryName)) {
                    throw new AssertionError();
                }
                return false;
            }
        }
        return true;
    }

    private void fixParents(ArchiveEntry entry) {
        String entryName = this.getEntryName(entry);
        if (ArchiveFileSystem.isLegalEntryName(entryName) && '/' != entryName.charAt(0)) {
            this.fixParents(entryName);
        }
    }

    private void fixParents(String entryName) {
        if (ROOT_DIRECTORY_NAME.equals(entryName)) {
            return;
        }
        String[] split = this.split(entryName);
        String parentName = split[0];
        String baseName = split[1];
        ArchiveEntry parent = (ArchiveEntry)this.master.get(parentName);
        if (null == parent) {
            parent = this.createArchiveEntry(parentName);
            this.master.put(parentName, parent);
        }
        this.fixParents(parentName);
        parent.getMetaData().children.add(baseName);
    }

    private String[] split(String entryName) {
        return ArchiveFileSystem.split(entryName, this.split);
    }

    static String[] split(String entryName, String[] result) {
        if (!$assertionsDisabled && entryName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && result == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && result.length < 2) {
            throw new AssertionError();
        }
        int end = entryName.length();
        if (0 <= --end && entryName.charAt(end) == '/') {
            --end;
        }
        int base = entryName.lastIndexOf(47, end);
        ++end;
        if (base != -1) {
            result[0] = entryName.substring(0, ++base);
            result[1] = entryName.substring(base, end);
        } else {
            result[0] = end > 0 ? ROOT_DIRECTORY_NAME : null;
            result[1] = entryName.substring(0, end);
        }
        return result;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    boolean isTouched() {
        if (!$assertionsDisabled && this.controller.getFileSystem() != this) {
            throw new AssertionError();
        }
        return this.touched != 0L;
    }

    private void touch() throws IOException {
        if (this.isReadOnly()) {
            throw new ArchiveReadOnlyException();
        }
        if (this.touched == 0L) {
            this.controller.touch();
        }
        ++this.touched;
    }

    Enumeration getArchiveEntries() {
        if (!$assertionsDisabled && this.controller.getFileSystem() != this) {
            throw new AssertionError();
        }
        return Collections.enumeration(this.master.values());
    }

    ArchiveEntry getRoot() {
        if (!$assertionsDisabled && this.controller.getFileSystem() != this) {
            throw new AssertionError();
        }
        return this.root;
    }

    static boolean isRoot(String entryName) {
        return "".equals(entryName);
    }

    ArchiveEntry get(String entryName) {
        if (!$assertionsDisabled && entryName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.controller.getFileSystem() != this) {
            throw new AssertionError();
        }
        return (ArchiveEntry)this.master.get(entryName);
    }

    Delta link(String entryName, boolean createParents) throws ArchiveFileSystemException {
        return this.link(entryName, createParents, null);
    }

    Delta link(String entryName, boolean createParents, ArchiveEntry template) throws ArchiveFileSystemException {
        if (!$assertionsDisabled && !ArchiveFileSystem.isRoot(entryName) && entryName.charAt(0) == '/') {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.controller.getFileSystem() != this) {
            throw new AssertionError();
        }
        if (ArchiveFileSystem.isRoot(entryName)) {
            throw new ArchiveFileSystemException(entryName, "virtual root directory cannot get replaced");
        }
        return new LinkDelta(entryName, createParents, template);
    }

    private ArchiveEntry createArchiveEntry(String entryName, ArchiveEntry blueprint) throws CharConversionException {
        ArchiveEntry entry = this.controller.createArchiveEntry(entryName, blueprint);
        entry.setMetaData(new ArchiveEntryMetaData(entry));
        return entry;
    }

    private ArchiveEntry createArchiveEntry(String entryName) {
        try {
            return this.createArchiveEntry(entryName, null);
        }
        catch (CharConversionException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private void unlink(String entryName) throws IOException {
        if (ArchiveFileSystem.isRoot(entryName)) {
            throw new ArchiveFileSystemException(entryName, "virtual root directory cannot get unlinked");
        }
        try {
            ArchiveEntry entry = (ArchiveEntry)this.master.remove(entryName);
            if (entry == null) {
                throw new ArchiveFileSystemException(entryName, "entry does not exist");
            }
            if (entry == this.root || entry.isDirectory() && !entry.getMetaData().children.isEmpty()) {
                this.master.put(entryName, entry);
                throw new ArchiveFileSystemException(entryName, "directory is not empty");
            }
            String[] split = this.split(entryName);
            String parentName = split[0];
            ArchiveEntry parent = (ArchiveEntry)this.master.get(parentName);
            if (!$assertionsDisabled && parent == null) {
                throw new AssertionError((Object)("The parent directory of \"" + entryName + "\" is missing - archive file system is corrupted!"));
            }
            boolean ok = parent.getMetaData().children.remove(split[1]);
            if (!$assertionsDisabled && !ok) {
                throw new AssertionError((Object)("The parent directory of \"" + entryName + "\" does not contain this entry - archive file system is corrupted!"));
            }
            this.touch();
            if (parent.getTime() != -1L) {
                parent.setTime(System.currentTimeMillis());
            }
        }
        catch (UnsupportedOperationException unmodifiableMap) {
            throw new ArchiveReadOnlyException();
        }
    }

    boolean exists(String entryName) {
        return this.get(entryName) != null || this.get(entryName + ROOT_DIRECTORY_NAME) != null;
    }

    boolean isFile(String entryName) {
        return this.get(entryName) != null;
    }

    boolean isDirectory(String entryName) {
        return this.get(entryName + ROOT_DIRECTORY_NAME) != null;
    }

    Icon getOpenIcon(String entryName) {
        if (!$assertionsDisabled && ArchiveFileSystem.isRoot(entryName)) {
            throw new AssertionError();
        }
        ArchiveEntry entry = this.get(entryName);
        if (entry == null) {
            entry = this.get(entryName + ROOT_DIRECTORY_NAME);
        }
        return entry != null ? entry.getOpenIcon() : null;
    }

    Icon getClosedIcon(String entryName) {
        if (!$assertionsDisabled && ArchiveFileSystem.isRoot(entryName)) {
            throw new AssertionError();
        }
        ArchiveEntry entry = this.get(entryName);
        if (entry == null) {
            entry = this.get(entryName + ROOT_DIRECTORY_NAME);
        }
        return entry != null ? entry.getClosedIcon() : null;
    }

    boolean canWrite(String entryName) {
        return !this.isReadOnly() && this.exists(entryName);
    }

    boolean setReadOnly(String entryName) {
        return this.isReadOnly() && this.exists(entryName);
    }

    long length(String entryName) {
        ArchiveEntry entry = this.get(entryName);
        if (entry == null || entry.isDirectory()) {
            return 0L;
        }
        long length = entry.getSize();
        return length != -1L ? length : 0L;
    }

    long lastModified(String entryName) {
        ArchiveEntry entry = this.get(entryName);
        if (entry == null) {
            entry = this.get(entryName + ROOT_DIRECTORY_NAME);
        }
        if (entry != null) {
            long time = entry.getTime();
            return time >= 0L ? time : 0L;
        }
        return 0L;
    }

    boolean setLastModified(String entryName, long time) throws IOException {
        if (time < 0L) {
            throw new IllegalArgumentException(entryName + " (negative entry modification time)");
        }
        if (this.isReadOnly()) {
            return false;
        }
        ArchiveEntry entry = this.get(entryName);
        if (entry == null && (entry = this.get(entryName + ROOT_DIRECTORY_NAME)) == null) {
            return false;
        }
        this.touch();
        entry.setTime(time);
        return true;
    }

    String[] list(String entryName) {
        ArchiveEntry entry = this.get(entryName + ROOT_DIRECTORY_NAME);
        if (entry != null) {
            return entry.getMetaData().list();
        }
        return null;
    }

    String[] list(String entryName, FilenameFilter filenameFilter, File dir) {
        ArchiveEntry entry = this.get(entryName + ROOT_DIRECTORY_NAME);
        if (entry != null) {
            if (filenameFilter != null) {
                return entry.getMetaData().list(filenameFilter, dir);
            }
            return entry.getMetaData().list();
        }
        return null;
    }

    File[] listFiles(String entryName, FilenameFilter filenameFilter, File dir, FileFactory factory) {
        ArchiveEntry entry = this.get(entryName + ROOT_DIRECTORY_NAME);
        if (entry != null) {
            return entry.getMetaData().listFiles(filenameFilter, dir, factory);
        }
        return null;
    }

    File[] listFiles(String entryName, FileFilter fileFilter, File dir, FileFactory factory) {
        ArchiveEntry entry = this.get(entryName + ROOT_DIRECTORY_NAME);
        if (entry != null) {
            return entry.getMetaData().listFiles(fileFilter, dir, factory);
        }
        return null;
    }

    void mkdir(String entryName, boolean createParents) throws IOException {
        this.link(entryName + ROOT_DIRECTORY_NAME, createParents).commit();
    }

    void delete(String entryName) throws IOException {
        if (!$assertionsDisabled && !ArchiveFileSystem.isRoot(entryName) && entryName.charAt(0) == '/') {
            throw new AssertionError();
        }
        if (this.get(entryName) != null) {
            this.unlink(entryName);
            return;
        }
        String dirEntryName = entryName + ROOT_DIRECTORY_NAME;
        if (this.get(dirEntryName) != null) {
            this.unlink(dirEntryName);
            return;
        }
        throw new ArchiveFileSystemException(entryName, "archive entry does not exist");
    }

    static {
        $assertionsDisabled = !ArchiveFileSystem.class.desiredAssertionStatus();
    }

    static class ArchiveReadOnlyException
    extends ArchiveFileSystemException {
        private static final long serialVersionUID = 7625038627494543837L;

        private ArchiveReadOnlyException() {
            super("Archive file is read-only!");
        }
    }

    static class ArchiveFileSystemException
    extends IOException {
        private static final long serialVersionUID = 7625038629582374837L;
        private final String entryName;

        private ArchiveFileSystemException(String message) {
            super(message);
            this.entryName = null;
        }

        private ArchiveFileSystemException(String entryName, String message) {
            super(message);
            this.entryName = entryName;
        }

        public String getMessage() {
            return this.entryName != null ? this.entryName + " (" + super.getMessage() + ")" : super.getMessage();
        }
    }

    static interface Delta {
        public ArchiveEntry getEntry();

        public void commit() throws IOException;
    }

    private static abstract class AbstractDelta
    implements Delta {
        private AbstractDelta() {
        }

        static class Element {
            final String baseName;
            final ArchiveEntry entry;
            static final /* synthetic */ boolean $assertionsDisabled;

            Element(String baseName, ArchiveEntry entry) {
                this.baseName = baseName;
                if (!$assertionsDisabled && entry == null) {
                    throw new AssertionError();
                }
                this.entry = entry;
            }

            static {
                $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveFileSystem == null ? (class$de$schlichtherle$io$ArchiveFileSystem = ArchiveFileSystem.class$("de.schlichtherle.io.ArchiveFileSystem")) : class$de$schlichtherle$io$ArchiveFileSystem).desiredAssertionStatus();
            }
        }
    }

    private final class LinkDelta
    extends AbstractDelta {
        final AbstractDelta.Element[] elements;
        static final /* synthetic */ boolean $assertionsDisabled;

        private LinkDelta(String entryName, boolean createParents, ArchiveEntry template) throws ArchiveFileSystemException {
            if (ArchiveFileSystem.this.isReadOnly()) {
                throw new ArchiveReadOnlyException();
            }
            try {
                this.elements = this.createElements(entryName, createParents, template, 1);
            }
            catch (CharConversionException cce) {
                ArchiveFileSystemException afse = new ArchiveFileSystemException(cce.toString());
                afse.initCause(cce);
                throw afse;
            }
        }

        private AbstractDelta.Element[] createElements(String entryName, boolean createParents, ArchiveEntry template, int level) throws ArchiveFileSystemException, CharConversionException {
            AbstractDelta.Element[] elements;
            String[] split = ArchiveFileSystem.this.split(entryName);
            String parentName = split[0];
            String baseName = split[1];
            ArchiveEntry parent = (ArchiveEntry)ArchiveFileSystem.this.master.get(parentName);
            if (parent != null) {
                ArchiveEntry oldEntry = (ArchiveEntry)ArchiveFileSystem.this.master.get(entryName);
                this.ensureMayBeReplaced(entryName, oldEntry);
                elements = new AbstractDelta.Element[level + 1];
                elements[0] = new AbstractDelta.Element(parentName, parent);
                ArchiveEntry entry = ArchiveFileSystem.this.createArchiveEntry(entryName, template);
                elements[1] = new AbstractDelta.Element(baseName, entry);
            } else if (createParents) {
                elements = this.createElements(parentName, createParents, null, level + 1);
                ArchiveEntry entry = ArchiveFileSystem.this.createArchiveEntry(entryName, template);
                elements[elements.length - level] = new AbstractDelta.Element(baseName, entry);
            } else {
                throw new ArchiveFileSystemException(entryName, "missing parent directory");
            }
            return elements;
        }

        private void ensureMayBeReplaced(String entryName, ArchiveEntry oldEntry) throws ArchiveFileSystemException {
            int end = entryName.length() - 1;
            if (entryName.charAt(end) == '/') {
                if (oldEntry != null) {
                    throw new ArchiveFileSystemException(entryName, "directories cannot get replaced");
                }
                if (ArchiveFileSystem.this.master.get(entryName.substring(0, end)) != null) {
                    throw new ArchiveFileSystemException(entryName, "directories cannot replace files");
                }
            } else if (ArchiveFileSystem.this.master.get(entryName + ArchiveFileSystem.ROOT_DIRECTORY_NAME) != null) {
                throw new ArchiveFileSystemException(entryName, "files cannot replace directories");
            }
        }

        public void commit() throws IOException {
            if (!$assertionsDisabled && ArchiveFileSystem.this.controller.getFileSystem() != ArchiveFileSystem.this) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.elements.length < 2) {
                throw new AssertionError();
            }
            ArchiveFileSystem.this.touch();
            long time = System.currentTimeMillis();
            int l = this.elements.length;
            ArchiveEntry parent = this.elements[0].entry;
            for (int i = 1; i < l; ++i) {
                AbstractDelta.Element element = this.elements[i];
                String baseName = element.baseName;
                ArchiveEntry entry = element.entry;
                if (parent.getMetaData().children.add(baseName) && parent.getTime() != -1L) {
                    parent.setTime(time);
                }
                ArchiveFileSystem.this.master.put(entry.getName(), entry);
                parent = entry;
            }
            ArchiveEntry entry = this.elements[l - 1].entry;
            if (entry.getTime() == -1L) {
                entry.setTime(time);
            }
        }

        public ArchiveEntry getEntry() {
            if (!$assertionsDisabled && ArchiveFileSystem.this.controller.getFileSystem() != ArchiveFileSystem.this) {
                throw new AssertionError();
            }
            return this.elements[this.elements.length - 1].entry;
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$ArchiveFileSystem == null ? (class$de$schlichtherle$io$ArchiveFileSystem = ArchiveFileSystem.class$("de.schlichtherle.io.ArchiveFileSystem")) : class$de$schlichtherle$io$ArchiveFileSystem).desiredAssertionStatus();
        }
    }
}

