/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FilterTransport
implements SOAPTransport {
    private EnvelopeEditor editor;
    private SOAPTransport transport;

    public FilterTransport(EnvelopeEditor envelopeEditor, SOAPTransport sOAPTransport) {
        this.editor = envelopeEditor;
        this.transport = sOAPTransport;
    }

    public Hashtable getHeaders() {
        return this.transport.getHeaders();
    }

    public SOAPContext getResponseSOAPContext() {
        return this.transport.getResponseSOAPContext();
    }

    public BufferedReader receive() {
        try {
            BufferedReader bufferedReader = this.transport.receive();
            if (this.editor == null || bufferedReader == null) {
                return bufferedReader;
            }
            StringWriter stringWriter = new StringWriter();
            this.editor.editIncoming(bufferedReader, stringWriter);
            stringWriter.flush();
            StringReader stringReader = new StringReader(stringWriter.getBuffer().toString());
            return new BufferedReader(stringReader);
        }
        catch (SOAPException sOAPException) {
            sOAPException.printStackTrace();
            return null;
        }
    }

    public void send(URL uRL, String string, Hashtable hashtable, Envelope envelope, SOAPMappingRegistry sOAPMappingRegistry, SOAPContext sOAPContext) throws SOAPException {
        try {
            StringWriter stringWriter = new StringWriter();
            envelope.marshall(stringWriter, sOAPMappingRegistry, sOAPContext);
            StringReader stringReader = new StringReader(stringWriter.getBuffer().toString());
            if (this.editor != null) {
                stringWriter = new StringWriter();
                this.editor.editOutgoing(stringReader, stringWriter);
                stringWriter.flush();
                stringReader = new StringReader(stringWriter.getBuffer().toString());
            }
            DocumentBuilder documentBuilder = XMLParserUtils.getXMLDocBuilder();
            Element element = documentBuilder.parse(new InputSource(stringReader)).getDocumentElement();
            Envelope envelope2 = Envelope.unmarshall(element);
            this.transport.send(uRL, string, hashtable, envelope2, sOAPMappingRegistry, sOAPContext);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (SAXException sAXException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, iOException.getMessage(), iOException);
        }
    }
}

