/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.SynchronizedOutputStream;
import de.schlichtherle.truezip.socket.DecoratingOutputShop;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.OutputClosedException;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.ExceptionHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ConcurrentOutputShop<E extends Entry>
extends DecoratingOutputShop<E, OutputShop<E>> {
    private static final String CLASS_NAME = ConcurrentOutputShop.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    private final Map<Closeable, Thread> threads = new WeakHashMap<Closeable, Thread>();
    private volatile boolean closed;

    public ConcurrentOutputShop(OutputShop<E> output) {
        super(output);
    }

    public final synchronized int waitCloseOthers(long timeout) {
        if (this.closed) {
            return 0;
        }
        long start = System.currentTimeMillis();
        int threadStreams = this.threadStreams();
        try {
            while (this.threads.size() > threadStreams) {
                long toWait;
                if (timeout > 0L) {
                    toWait = timeout - (System.currentTimeMillis() - start);
                    if (toWait <= 0L) {
                        break;
                    }
                } else {
                    toWait = 0L;
                }
                System.gc();
                System.runFinalization();
                this.wait(toWait);
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.WARNING, "wait.interrupted", ex);
        }
        return this.threads.size();
    }

    private int threadStreams() {
        Thread thisThread = Thread.currentThread();
        int n = 0;
        for (Thread thread : this.threads.values()) {
            if (thisThread != thread) continue;
            ++n;
        }
        return n;
    }

    public final synchronized <X extends Exception> void closeAll(ExceptionHandler<IOException, X> handler) throws X {
        if (this.closed) {
            return;
        }
        Iterator<Closeable> i = this.threads.keySet().iterator();
        while (i.hasNext()) {
            try {
                Closeable closeable = i.next();
                i.remove();
                closeable.close();
            }
            catch (IOException ex) {
                handler.warn(ex);
            }
        }
        assert (this.threads.isEmpty());
    }

    @Override
    public final synchronized void close() throws IOException {
        if (!this.threads.isEmpty()) {
            throw new IllegalStateException();
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        ((OutputShop)this.delegate).close();
    }

    private void assertNotShopClosed() throws IOException {
        if (this.closed) {
            throw new OutputClosedException();
        }
    }

    @Override
    public final OutputSocket<? extends E> getOutputSocket(E entry) {
        if (null == entry) {
            throw new NullPointerException();
        }
        class Output
        extends DecoratingOutputSocket<E> {
            final /* synthetic */ Entry val$entry;

            Output() {
                this.val$entry = entry;
                super(ConcurrentOutputShop.super.getOutputSocket(entry));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OutputStream newOutputStream() throws IOException {
                ConcurrentOutputShop concurrentOutputShop = ConcurrentOutputShop.this;
                synchronized (concurrentOutputShop) {
                    ConcurrentOutputShop.this.assertNotShopClosed();
                    return new SynchronizedConcurrentOutputStream(new ConcurrentOutputStream(this.getBoundSocket().newOutputStream()));
                }
            }
        }
        return new Output();
    }

    @NotThreadSafe
    private final class ConcurrentOutputStream
    extends DecoratingOutputStream {
        private ConcurrentOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            ConcurrentOutputShop.this.assertNotShopClosed();
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ConcurrentOutputShop.this.assertNotShopClosed();
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            if (!ConcurrentOutputShop.this.closed) {
                this.delegate.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (!ConcurrentOutputShop.this.closed) {
                this.delegate.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    @ThreadSafe
    private final class SynchronizedConcurrentOutputStream
    extends SynchronizedOutputStream {
        SynchronizedConcurrentOutputStream(OutputStream out) {
            super(out, ConcurrentOutputShop.this);
            assert (this.lock == ConcurrentOutputShop.this);
            ConcurrentOutputShop.this.threads.put(out, Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (ConcurrentOutputShop.this.closed) {
                    return;
                }
                try {
                    this.delegate.close();
                }
                finally {
                    ConcurrentOutputShop.this.threads.remove(this.delegate);
                    this.lock.notify();
                }
            }
        }
    }
}

