/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid4;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid4.ByteSequence;
import uk.gov.nationalarchives.droid.core.signature.droid4.LeftFragment;
import uk.gov.nationalarchives.droid.core.signature.droid4.RightFragment;
import uk.gov.nationalarchives.droid.core.signature.droid4.Shift;
import uk.gov.nationalarchives.droid.core.signature.droid4.SideFragment;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

@Deprecated
public class SubSequence
extends SimpleElement {
    private Log log = LogFactory.getLog(this.getClass());
    private String reference;
    private int parentSignature;
    private boolean bigEndian = true;
    private ByteSequence parentByteSequence;
    int position;
    int minSeqOffset = 0;
    int maxSeqOffset = 0;
    int minFragLength;
    String sequence;
    long[] shiftFunction = new long[256];
    List<LeftFragment> leftFragments = new ArrayList<LeftFragment>();
    List<RightFragment> rightFragments = new ArrayList<RightFragment>();
    byte[] byteSequence;
    List<List<SideFragment>> orderedLeftFragments = new ArrayList<List<SideFragment>>();
    List<List<SideFragment>> orderedRightFragments = new ArrayList<List<SideFragment>>();
    static boolean showProgress = false;

    public ByteSequence getByteSequence() {
        return this.parentByteSequence;
    }

    public void setByteSequence(ByteSequence byteSequence) {
        this.parentByteSequence = byteSequence;
    }

    public boolean isEOF() {
        return this.reference.equalsIgnoreCase("EOFoffset") && this.position == 1;
    }

    public boolean isBOF() {
        return this.reference.equalsIgnoreCase("BOFoffset") && this.position == 1;
    }

    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public int getParentSignature() {
        return this.parentSignature;
    }

    public void setParentSignature(int parentSignature) {
        this.parentSignature = parentSignature;
    }

    public void addLeftFragment(LeftFragment lf) {
        this.leftFragments.add(lf);
    }

    public void addRightFragment(RightFragment lf) {
        this.rightFragments.add(lf);
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setShift(Shift theShift) {
        int theShiftByte = theShift.getShiftByte();
        if (theShiftByte >= 0 && theShiftByte < 128) {
            this.shiftFunction[theShiftByte + 128] = theShift.getShiftValue();
        } else if (theShiftByte >= 128 && theShiftByte < 256) {
            this.shiftFunction[theShiftByte - 128] = theShift.getShiftValue();
        }
    }

    public void setDefaultShift(String theValue) {
        for (int i = 0; i < 256; ++i) {
            this.shiftFunction[i] = Long.parseLong(theValue);
        }
    }

    public void setSequence(String seq) {
        this.sequence = seq;
        int seqLength = seq.length() / 2;
        if (2 * seqLength != seq.length()) {
            this.log.error((Object)("A problem - sequence of odd length was found: " + seq));
            System.out.println("A problem - sequence of odd length was found: " + seq);
        }
        this.byteSequence = new byte[seqLength];
        for (int i = 0; i < seqLength; ++i) {
            int byteVal = Integer.parseInt(seq.substring(2 * i, 2 * (i + 1)), 16);
            this.byteSequence[i] = byteVal > 127 ? (byte)(byteVal - 256) : (byte)byteVal;
        }
    }

    public void setMinSeqOffset(int theOffset) {
        this.minSeqOffset = theOffset;
        if (this.maxSeqOffset < this.minSeqOffset) {
            this.maxSeqOffset = this.minSeqOffset;
        }
    }

    public void setMaxSeqOffset(int theOffset) {
        this.maxSeqOffset = theOffset;
        if (this.maxSeqOffset < this.minSeqOffset) {
            this.maxSeqOffset = this.minSeqOffset;
        }
    }

    public void setMinFragLength(int theLength) {
        this.minFragLength = theLength;
    }

    @Override
    public void setAttributeValue(String name, String value) {
        if (name.equals("Position")) {
            this.setPosition(Integer.parseInt(value));
        } else if (name.equals("SubSeqMinOffset")) {
            this.setMinSeqOffset(Integer.parseInt(value));
        } else if (name.equals("SubSeqMaxOffset")) {
            this.setMaxSeqOffset(Integer.parseInt(value));
        } else if (name.equals("MinFragLength")) {
            this.setMinFragLength(Integer.parseInt(value));
        } else {
            this.unknownAttributeWarning(name, this.getElementName());
        }
    }

    public int getNumFragmentPositions(boolean leftFrag) {
        if (leftFrag) {
            return this.orderedLeftFragments.size();
        }
        return this.orderedRightFragments.size();
    }

    public int getNumAlternativeFragments(boolean leftFrag, int thePosition) {
        if (leftFrag) {
            return this.orderedLeftFragments.get(thePosition - 1).size();
        }
        return this.orderedRightFragments.get(thePosition - 1).size();
    }

    public SideFragment getFragment(boolean leftFrag, int thePosition, int theIndex) {
        if (leftFrag) {
            return (SideFragment)((ArrayList)this.orderedLeftFragments.get(thePosition - 1)).get(theIndex);
        }
        return (SideFragment)((ArrayList)this.orderedRightFragments.get(thePosition - 1)).get(theIndex);
    }

    public long getShift(byte theByteValue) {
        return this.shiftFunction[theByteValue + 128];
    }

    public String getSequence() {
        return this.sequence;
    }

    public byte getByte(int theIndex) {
        return this.byteSequence[theIndex];
    }

    public int getNumBytes() {
        return this.byteSequence.length;
    }

    public List<LeftFragment> getLeftFragments() {
        return this.leftFragments;
    }

    public List<RightFragment> getRightFragments() {
        return this.rightFragments;
    }

    public LeftFragment getRawLeftFragment(int theIndex) {
        return this.leftFragments.get(theIndex);
    }

    public RightFragment getRawRightFragment(int theIndex) {
        return this.rightFragments.get(theIndex);
    }

    public int getPosition() {
        return this.position;
    }

    public int getMinSeqOffset() {
        return this.minSeqOffset;
    }

    public int getMaxSeqOffset() {
        return this.maxSeqOffset;
    }

    public int getMinFragLength() {
        return this.minFragLength;
    }

    public void prepareSeqFragments() {
        int i;
        int numFrags = 0;
        for (i = 0; i < this.leftFragments.size(); ++i) {
            int currentPosition = this.getRawLeftFragment(i).getPosition();
            if (currentPosition <= numFrags) continue;
            numFrags = currentPosition;
        }
        for (i = 0; i < numFrags; ++i) {
            ArrayList alternativeFragments = new ArrayList();
            this.orderedLeftFragments.add(alternativeFragments);
        }
        for (i = 0; i < this.leftFragments.size(); ++i) {
            int currentPosition = this.getRawLeftFragment(i).getPosition();
            this.orderedLeftFragments.get(currentPosition - 1).add(this.getRawLeftFragment(i));
        }
        this.leftFragments = null;
        numFrags = 0;
        for (i = 0; i < this.rightFragments.size(); ++i) {
            int currentPosition = this.getRawRightFragment(i).getPosition();
            if (currentPosition <= numFrags) continue;
            numFrags = currentPosition;
        }
        for (i = 0; i < numFrags; ++i) {
            ArrayList alternativeFragments = new ArrayList();
            this.orderedRightFragments.add(alternativeFragments);
        }
        for (i = 0; i < this.rightFragments.size(); ++i) {
            int currentPosition = this.getRawRightFragment(i).getPosition();
            this.orderedRightFragments.get(currentPosition - 1).add(this.getRawRightFragment(i));
        }
        this.rightFragments = null;
    }

    public boolean isFoundAfterFileMarker(ByteReader targetFile, boolean reverseOrder, boolean bigEndian) {
        boolean subSeqFound = false;
        try {
            long fileSize = targetFile.getNumBytes() - 1L;
            int searchDirection = reverseOrder ? -1 : 1;
            long startPosInFile = targetFile.getFileMarker();
            if (fileSize < (startPosInFile += (long)(searchDirection * this.getMinSeqOffset())) - 1L) {
                return false;
            }
            targetFile.setFileMarker(startPosInFile);
            startPosInFile += (long)(searchDirection * this.getMinFragLength());
            int numSeqBytes = this.getNumBytes();
            int byteLoopStart = reverseOrder ? numSeqBytes - 1 : 0;
            int byteLoopEnd = reverseOrder ? 0 : numSeqBytes - 1;
            try {
                while (!subSeqFound) {
                    boolean missMatchFound = false;
                    byte lastByte = targetFile.getByte(startPosInFile + (long)byteLoopEnd);
                    if (this.byteSequence[byteLoopEnd] != lastByte) {
                        if ((startPosInFile += this.shiftFunction[128 + lastByte] - 1L) >= 0L && startPosInFile <= fileSize) continue;
                    } else {
                        for (int iByte = byteLoopStart; !missMatchFound && iByte <= numSeqBytes - 1 && iByte >= 0; iByte += searchDirection) {
                            missMatchFound = this.byteSequence[iByte] != targetFile.getByte(startPosInFile + (long)iByte - (long)byteLoopStart);
                        }
                        if (!missMatchFound) {
                            if (reverseOrder) {
                                long[] rightFragEndArray = this.bytePosForRightFragments(targetFile, startPosInFile + 1L, targetFile.getFileMarker(), 1, 0, bigEndian);
                                if (rightFragEndArray.length == 0) {
                                    missMatchFound = true;
                                } else {
                                    long rightFragEnd = rightFragEndArray[0];
                                    long[] leftFragEndArray = this.bytePosForLeftFragments(targetFile, 0L, startPosInFile - (long)numSeqBytes, -1, 0, bigEndian);
                                    if (leftFragEndArray.length == 0) {
                                        missMatchFound = true;
                                    } else {
                                        long leftFragEnd = leftFragEndArray[0];
                                        targetFile.setFileMarker(leftFragEnd - 1L);
                                        subSeqFound = true;
                                    }
                                }
                            } else {
                                long[] leftFragEndArray = this.bytePosForLeftFragments(targetFile, targetFile.getFileMarker(), startPosInFile - 1L, -1, 0, bigEndian);
                                if (leftFragEndArray.length == 0) {
                                    missMatchFound = true;
                                } else {
                                    long leftFragEnd = leftFragEndArray[0];
                                    long[] rightFragEndArray = this.bytePosForRightFragments(targetFile, startPosInFile + (long)numSeqBytes, targetFile.getNumBytes() - 1L, 1, 0, bigEndian);
                                    if (rightFragEndArray.length == 0) {
                                        missMatchFound = true;
                                    } else {
                                        long rightFragEnd = rightFragEndArray[0];
                                        targetFile.setFileMarker(rightFragEnd + 1L);
                                        subSeqFound = true;
                                    }
                                }
                            }
                        }
                        if (!missMatchFound) continue;
                        if ((startPosInFile += this.shiftFunction[128 + targetFile.getByte(startPosInFile + (long)(searchDirection * numSeqBytes))]) >= 0L) {
                            if (startPosInFile <= fileSize) continue;
                        }
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {}
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        return subSeqFound;
    }

    private int getIndirectOffset(ByteReader targetFile) {
        int offset = 0;
        long power = 1L;
        long offsetLocation = this.getByteSequence().getIndirectOffsetLocation();
        if (this.getByteSequence().getReference().endsWith("EOFoffset")) {
            offsetLocation = targetFile.getNumBytes() - offsetLocation - 1L;
        }
        int offsetLength = this.getByteSequence().getIndirectOffsetLength();
        if (this.isBigEndian()) {
            for (int i = offsetLength - 1; i > -1; --i) {
                Byte fileByte = targetFile.getByte(offsetLocation + (long)i);
                int byteValue = fileByte.intValue();
                byteValue = byteValue >= 0 ? byteValue : byteValue + 256;
                offset = (int)((long)offset + power * (long)byteValue);
                power *= 256L;
            }
        } else {
            for (int i = 0; i < offsetLength; ++i) {
                Byte fileByte = targetFile.getByte(offsetLocation + (long)i);
                int byteValue = fileByte.intValue();
                byteValue = byteValue >= 0 ? byteValue : byteValue + 256;
                offset = (int)((long)offset + power * (long)byteValue);
                power *= 256L;
            }
        }
        return offset;
    }

    public boolean isFoundAtStartOfFile(ByteReader targetFile, boolean reverseOrder, boolean bigEndian) {
        try {
            int numOptions;
            int searchDirection = reverseOrder ? -1 : 1;
            int minSeqOffset = this.getMinSeqOffset();
            int maxSeqOffset = this.getMaxSeqOffset();
            if (this.reference.startsWith("Indirect")) {
                try {
                    int indirectOffset = this.getIndirectOffset(targetFile);
                    minSeqOffset += indirectOffset;
                    maxSeqOffset += indirectOffset;
                }
                catch (Exception e) {
                    return false;
                }
            }
            long[] startPosInFile = new long[]{reverseOrder ? targetFile.getNumBytes() - (long)minSeqOffset - 1L : (long)minSeqOffset};
            boolean subseqFound = true;
            boolean leftFrag = true;
            if (reverseOrder) {
                leftFrag = false;
            }
            if ((numOptions = (startPosInFile = reverseOrder ? this.bytePosForRightFragments(targetFile, 0L, startPosInFile[0], -1, maxSeqOffset - minSeqOffset, bigEndian) : this.bytePosForLeftFragments(targetFile, startPosInFile[0], targetFile.getNumBytes() - 1L, 1, maxSeqOffset - minSeqOffset, bigEndian)).length) == 0) {
                subseqFound = false;
            } else {
                int i = 0;
                while (i < numOptions) {
                    int n = i++;
                    startPosInFile[n] = startPosInFile[n] + (long)searchDirection;
                }
            }
            if (subseqFound) {
                int i;
                int offsetRange;
                int minOffset = 0;
                int maxOffset = 0;
                if (this.getNumFragmentPositions(leftFrag) > 0) {
                    minOffset = this.getFragment(leftFrag, 1, 0).getMinOffset();
                    maxOffset = this.getFragment(leftFrag, 1, 0).getMaxOffset();
                    int i2 = 0;
                    while (i2 < numOptions) {
                        int n = i2++;
                        startPosInFile[n] = startPosInFile[n] + (long)(minOffset * searchDirection);
                    }
                }
                if ((offsetRange = maxOffset - minOffset) > 0) {
                    int i3;
                    long[] newStartPosInFile = new long[numOptions * (offsetRange + 1)];
                    for (int i4 = 0; i4 <= offsetRange; ++i4) {
                        for (int j = 0; j < numOptions; ++j) {
                            newStartPosInFile[j + i4 * numOptions] = startPosInFile[j] + (long)(i4 * searchDirection);
                        }
                    }
                    Arrays.sort(newStartPosInFile);
                    int newNumOptions = 1;
                    for (i3 = 1; i3 < numOptions * (offsetRange + 1); ++i3) {
                        if (newStartPosInFile[i3] <= newStartPosInFile[newNumOptions - 1]) continue;
                        newStartPosInFile[newNumOptions] = newStartPosInFile[i3];
                        ++newNumOptions;
                    }
                    numOptions = newNumOptions;
                    if (searchDirection > 1) {
                        System.arraycopy(newStartPosInFile, 0, startPosInFile, 0, numOptions);
                    } else {
                        for (i3 = 0; i3 < numOptions; ++i3) {
                            startPosInFile[i3] = newStartPosInFile[numOptions - 1 - i3];
                        }
                    }
                }
                int numSeqBytes = this.getNumBytes();
                long numBytesInFile = targetFile.getNumBytes();
                if (reverseOrder) {
                    for (i = 0; i < numOptions; ++i) {
                        if (startPosInFile[i] >= (long)numSeqBytes - 1L) continue;
                        numOptions = i;
                    }
                } else {
                    for (i = 0; i < numOptions; ++i) {
                        if (startPosInFile[i] <= numBytesInFile - (long)numSeqBytes) continue;
                        numOptions = i;
                    }
                }
                for (int iOption = 0; iOption < numOptions; ++iOption) {
                    int byteLoopStart = reverseOrder ? numSeqBytes - 1 : 0;
                    int byteLoopEnd = reverseOrder ? 0 : numSeqBytes - 1;
                    long tempFileMarker = startPosInFile[iOption];
                    boolean provSeqMatch = true;
                    for (int iByte = byteLoopStart; provSeqMatch && iByte <= numSeqBytes - 1 && iByte >= 0; iByte += searchDirection) {
                        provSeqMatch = this.byteSequence[iByte] == targetFile.getByte(tempFileMarker);
                        tempFileMarker += (long)searchDirection;
                    }
                    startPosInFile[iOption] = !provSeqMatch ? -2L : tempFileMarker;
                }
                Arrays.sort(startPosInFile, 0, numOptions);
                int newNumOptions = 0;
                long[] newStartPosInFile = new long[numOptions];
                if (numOptions > 0 && startPosInFile[0] >= -1L) {
                    newStartPosInFile[0] = startPosInFile[0];
                    newNumOptions = 1;
                }
                for (int i5 = 1; i5 < numOptions; ++i5) {
                    if (startPosInFile[i5] <= startPosInFile[i5 - 1]) continue;
                    newStartPosInFile[newNumOptions] = startPosInFile[i5];
                    ++newNumOptions;
                }
                if (newNumOptions == 0) {
                    subseqFound = false;
                } else {
                    numOptions = newNumOptions;
                    if (searchDirection < 0) {
                        for (int iOption = 0; iOption < numOptions; ++iOption) {
                            startPosInFile[iOption] = newStartPosInFile[numOptions - 1 - iOption];
                        }
                    } else {
                        System.arraycopy(newStartPosInFile, 0, startPosInFile, 0, numOptions);
                    }
                }
            }
            long newValueStartPosInFile = 0L;
            if (subseqFound) {
                int i;
                if (reverseOrder) {
                    subseqFound = false;
                    for (i = 0; i < numOptions && !subseqFound; ++i) {
                        long[] newArrayStartPosInFile = this.bytePosForLeftFragments(targetFile, 0L, startPosInFile[i], -1, 0, bigEndian);
                        if (newArrayStartPosInFile.length == 0) {
                            subseqFound = false;
                            continue;
                        }
                        subseqFound = true;
                        newValueStartPosInFile = newArrayStartPosInFile[0] - 1L;
                    }
                } else {
                    subseqFound = false;
                    for (i = 0; i < numOptions && !subseqFound; ++i) {
                        long[] newArrayStartPosInFile = this.bytePosForRightFragments(targetFile, startPosInFile[i], targetFile.getNumBytes() - 1L, 1, 0, bigEndian);
                        if (newArrayStartPosInFile.length == 0) {
                            subseqFound = false;
                            continue;
                        }
                        subseqFound = true;
                        newValueStartPosInFile = newArrayStartPosInFile[0] + 1L;
                    }
                }
            }
            if (subseqFound) {
                targetFile.setFileMarker(newValueStartPosInFile);
            }
            return subseqFound;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private long[] bytePosForLeftFragments(ByteReader targetFile, long leftBytePos, long rightBytePos, int searchDirection, int offsetRange, boolean bigEndian) {
        int iOption;
        boolean leftFrag = true;
        long startPos = rightBytePos;
        int posLoopStart = 1;
        int numFragPos = this.getNumFragmentPositions(leftFrag);
        if (searchDirection == 1) {
            startPos = leftBytePos;
            posLoopStart = numFragPos;
        }
        int totalNumOptions = offsetRange + 1;
        for (int iFragPos = 1; iFragPos <= numFragPos; ++iFragPos) {
            totalNumOptions *= this.getNumAlternativeFragments(leftFrag, iFragPos);
        }
        long[] markerPos = new long[totalNumOptions];
        for (int iOffset = 0; iOffset <= offsetRange; ++iOffset) {
            markerPos[iOffset] = startPos + (long)(iOffset * searchDirection);
        }
        int numOptions = 1 + offsetRange;
        boolean seqNotFound = false;
        for (int iFragPos = posLoopStart; !seqNotFound && iFragPos <= numFragPos && iFragPos >= 1; iFragPos -= searchDirection) {
            int iOption2;
            int numAltFrags = this.getNumAlternativeFragments(leftFrag, iFragPos);
            long[] tempEndPos = new long[numAltFrags * numOptions];
            int numEndPos = 0;
            for (iOption2 = 0; iOption2 < numOptions; ++iOption2) {
                for (int iAlt = 0; iAlt < numAltFrags; ++iAlt) {
                    long tempFragEnd = searchDirection == 1 ? this.endBytePosForSeqFrag(targetFile, markerPos[iOption2], rightBytePos, true, searchDirection, iFragPos, iAlt, bigEndian) : this.endBytePosForSeqFrag(targetFile, leftBytePos, markerPos[iOption2], true, searchDirection, iFragPos, iAlt, bigEndian);
                    if (tempFragEnd <= -1L) continue;
                    tempEndPos[numEndPos] = tempFragEnd + (long)searchDirection;
                    ++numEndPos;
                }
            }
            if (numEndPos == 0) {
                seqNotFound = true;
                continue;
            }
            numOptions = 0;
            for (iOption2 = 0; iOption2 < numEndPos; ++iOption2) {
                boolean addEndPos = true;
                for (int iMarker = 0; iMarker < numOptions; ++iMarker) {
                    if (markerPos[iMarker] != tempEndPos[iOption2]) continue;
                    addEndPos = false;
                    break;
                }
                if (!addEndPos) continue;
                markerPos[numOptions] = tempEndPos[iOption2];
                ++numOptions;
            }
        }
        if (seqNotFound) {
            long[] outArray = new long[]{};
            return outArray;
        }
        long[] outArray = new long[numOptions];
        if (searchDirection < 0) {
            for (iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        Arrays.sort(markerPos, 0, numOptions);
        if (searchDirection < 0) {
            for (iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        System.arraycopy(markerPos, 0, outArray, 0, numOptions);
        iOption = 0;
        while (iOption < numOptions) {
            int n = iOption++;
            outArray[n] = outArray[n] - (long)searchDirection;
        }
        return outArray;
    }

    private long[] bytePosForRightFragments(ByteReader targetFile, long leftBytePos, long rightBytePos, int searchDirection, int offsetRange, boolean bigEndian) {
        int iOption;
        boolean leftFrag = false;
        long startPos = leftBytePos;
        int posLoopStart = 1;
        int numFragPos = this.getNumFragmentPositions(leftFrag);
        if (searchDirection == -1) {
            startPos = rightBytePos;
            posLoopStart = numFragPos;
        }
        int totalNumOptions = offsetRange + 1;
        for (int iFragPos = 1; iFragPos <= numFragPos; ++iFragPos) {
            totalNumOptions *= this.getNumAlternativeFragments(leftFrag, iFragPos);
        }
        long[] markerPos = new long[totalNumOptions];
        for (int iOffset = 0; iOffset <= offsetRange; ++iOffset) {
            markerPos[iOffset] = startPos + (long)(iOffset * searchDirection);
        }
        int numOptions = 1 + offsetRange;
        boolean seqNotFound = false;
        for (int iFragPos = posLoopStart; !seqNotFound && iFragPos <= numFragPos && iFragPos >= 1; iFragPos += searchDirection) {
            int iOption2;
            int numAltFrags = this.getNumAlternativeFragments(leftFrag, iFragPos);
            long[] tempEndPos = new long[numAltFrags * numOptions];
            int numEndPos = 0;
            for (iOption2 = 0; iOption2 < numOptions; ++iOption2) {
                for (int iAlt = 0; iAlt < numAltFrags; ++iAlt) {
                    long tempFragEnd = searchDirection == -1 ? this.endBytePosForSeqFrag(targetFile, leftBytePos, markerPos[iOption2], false, searchDirection, iFragPos, iAlt, bigEndian) : this.endBytePosForSeqFrag(targetFile, markerPos[iOption2], rightBytePos, false, searchDirection, iFragPos, iAlt, bigEndian);
                    if (tempFragEnd <= -1L) continue;
                    tempEndPos[numEndPos] = tempFragEnd + (long)searchDirection;
                    ++numEndPos;
                }
            }
            if (numEndPos == 0) {
                seqNotFound = true;
                continue;
            }
            numOptions = 0;
            for (iOption2 = 0; iOption2 < numEndPos; ++iOption2) {
                boolean addEndPos = true;
                for (int iMarker = 0; iMarker < numOptions; ++iMarker) {
                    if (markerPos[iMarker] != tempEndPos[iOption2]) continue;
                    addEndPos = false;
                    break;
                }
                if (!addEndPos) continue;
                markerPos[numOptions] = tempEndPos[iOption2];
                ++numOptions;
            }
        }
        if (seqNotFound) {
            long[] outArray = new long[]{};
            return outArray;
        }
        long[] outArray = new long[numOptions];
        if (searchDirection < 0) {
            for (iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        Arrays.sort(markerPos, 0, numOptions);
        if (searchDirection < 0) {
            for (iOption = 0; iOption < numOptions; ++iOption) {
                markerPos[iOption] = -markerPos[iOption];
            }
        }
        System.arraycopy(markerPos, 0, outArray, 0, numOptions);
        iOption = 0;
        while (iOption < numOptions) {
            int n = iOption++;
            outArray[n] = outArray[n] - (long)searchDirection;
        }
        return outArray;
    }

    private long endBytePosForSeqFrag(ByteReader targetFile, long leftEndBytePos, long rightEndBytePos, boolean leftFrag, int searchDirection, int fragPos, int fragIndex, boolean bigEndian) {
        long lastStartPosInFile;
        long lastStartPosInFile2;
        long lastStartPosInFile1;
        long startPosInFile;
        int maxOffset;
        int minOffset;
        long endPosInFile = -1L;
        long searchDirectionL = searchDirection;
        int numBytes = this.getFragment(leftFrag, fragPos, fragIndex).getNumBytes();
        if (leftFrag && searchDirection == -1) {
            minOffset = this.getFragment(leftFrag, fragPos, fragIndex).getMinOffset();
            maxOffset = this.getFragment(leftFrag, fragPos, fragIndex).getMaxOffset();
        } else if (!leftFrag && searchDirection == 1) {
            minOffset = this.getFragment(leftFrag, fragPos, fragIndex).getMinOffset();
            maxOffset = this.getFragment(leftFrag, fragPos, fragIndex).getMaxOffset();
        } else if (fragPos < this.getNumFragmentPositions(leftFrag)) {
            minOffset = this.getFragment(leftFrag, fragPos + 1, 0).getMinOffset();
            maxOffset = this.getFragment(leftFrag, fragPos + 1, 0).getMaxOffset();
        } else {
            minOffset = 0;
            maxOffset = 0;
        }
        if (searchDirection == -1) {
            startPosInFile = rightEndBytePos - (long)minOffset;
            lastStartPosInFile1 = leftEndBytePos + (long)numBytes - 1L;
            lastStartPosInFile2 = rightEndBytePos - (long)maxOffset;
            lastStartPosInFile = lastStartPosInFile1 < lastStartPosInFile2 ? lastStartPosInFile2 : lastStartPosInFile1;
        } else {
            startPosInFile = leftEndBytePos + (long)minOffset;
            lastStartPosInFile1 = rightEndBytePos - (long)numBytes + 1L;
            lastStartPosInFile2 = leftEndBytePos + (long)maxOffset;
            lastStartPosInFile = lastStartPosInFile1 < lastStartPosInFile2 ? lastStartPosInFile1 : lastStartPosInFile2;
        }
        boolean subSeqFound = false;
        while (!subSeqFound && searchDirectionL * (lastStartPosInFile - startPosInFile) >= 0L) {
            int i;
            boolean missMatchFound = false;
            int byteLoopStart = searchDirection == -1 ? numBytes - 1 : 0;
            SideFragment fragment = this.getFragment(leftFrag, fragPos, fragIndex);
            long tempFileMarker = startPosInFile;
            int n = i = searchDirection == 1 ? 0 : fragment.getNumByteSeqSpecifiers() - 1;
            while (!missMatchFound && 0 <= i && i < fragment.getNumByteSeqSpecifiers()) {
                boolean bl = missMatchFound = !fragment.getByteSeqSpecifier(i).matchesByteSequence(targetFile, tempFileMarker, searchDirection, bigEndian);
                if (!missMatchFound) {
                    tempFileMarker += (long)(searchDirection * fragment.getByteSeqSpecifier(i).getNumBytes());
                }
                i += searchDirection;
            }
            if (!missMatchFound) {
                subSeqFound = true;
                endPosInFile = tempFileMarker - searchDirectionL;
                continue;
            }
            startPosInFile += searchDirectionL;
        }
        return endPosInFile;
    }

    public String toString() {
        return this.position + " seq=<" + this.sequence + ">" + "LLL" + this.orderedLeftFragments + "LLL" + "RRR" + this.orderedRightFragments + "RRR";
    }
}

