/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class TConfig
implements Closeable {
    @CheckForNull
    private static volatile InheritableThreadLocalConfigStack configs;
    private boolean lenient;
    private TArchiveDetector detector;

    public static TConfig get() {
        InheritableThreadLocalConfigStack configs = TConfig.configs;
        if (null == configs) {
            return Holder.GLOBAL;
        }
        TConfig session = (TConfig)((Deque)configs.get()).peek();
        return null != session ? session : Holder.GLOBAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TConfig push() {
        Class<TConfig> clazz = TConfig.class;
        synchronized (TConfig.class) {
            InheritableThreadLocalConfigStack configs = TConfig.configs;
            if (null == configs) {
                configs = TConfig.configs = new InheritableThreadLocalConfigStack();
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            Deque stack = (Deque)configs.get();
            TConfig template = (TConfig)stack.peek();
            if (null == template) {
                template = Holder.GLOBAL;
            }
            TConfig config = new TConfig(template);
            stack.push(config);
            return config;
        }
    }

    public static void pop() {
        TConfig.get().close();
    }

    private static void pop(TConfig config) {
        TConfig found;
        InheritableThreadLocalConfigStack configs = TConfig.configs;
        if (null == configs) {
            throw new IllegalStateException("Inheritable thread local configuration stack is empty.");
        }
        Deque stack = (Deque)configs.get();
        try {
            found = (TConfig)stack.pop();
        }
        catch (NoSuchElementException ex) {
            throw new IllegalStateException("Inheritable thread local configuration stack is empty.", ex);
        }
        if (config != found) {
            stack.push(found);
            throw new IllegalStateException("Not the top element of the inheritable thread local configuration stack.");
        }
        if (stack.isEmpty()) {
            configs.remove();
        }
    }

    private TConfig() {
        this.lenient = true;
        this.detector = TArchiveDetector.ALL;
    }

    private TConfig(TConfig template) {
        this.lenient = template.isLenient();
        this.detector = template.getArchiveDetector();
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    public void setArchiveDetector(TArchiveDetector detector) {
        if (null == detector) {
            throw new NullPointerException();
        }
        this.detector = detector;
    }

    @Override
    public void close() {
        TConfig.pop(this);
    }

    private static final class Holder {
        static final TConfig GLOBAL = new TConfig();

        private Holder() {
        }
    }

    private static final class InheritableThreadLocalConfigStack
    extends InheritableThreadLocal<Deque<TConfig>> {
        private InheritableThreadLocalConfigStack() {
        }

        @Override
        protected Deque<TConfig> initialValue() {
            return new LinkedList<TConfig>();
        }

        @Override
        protected Deque<TConfig> childValue(Deque<TConfig> parent) {
            LinkedList<TConfig> child = new LinkedList<TConfig>();
            TConfig element = parent.peek();
            if (null != element) {
                child.push(element);
            }
            return child;
        }
    }
}

