/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsMultiplexedArchiveOutputShop;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.fs.archive.zip.ZipOutputShop;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.zip.ZipEntryFactory;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public class ZipDriver
extends FsCharsetArchiveDriver<ZipArchiveEntry>
implements ZipEntryFactory<ZipArchiveEntry> {
    private static final Charset ZIP_CHARSET = Charset.forName("IBM437");
    private final IOPoolProvider provider;

    public ZipDriver(IOPoolProvider provider) {
        this(provider, ZIP_CHARSET);
    }

    protected ZipDriver(IOPoolProvider provider, Charset charset) {
        super(charset);
        if (null == provider) {
            throw new NullPointerException();
        }
        this.provider = provider;
    }

    protected final IOPool<?> getPool() {
        return this.provider.get();
    }

    public boolean getPreambled() {
        return false;
    }

    public boolean getPostambled() {
        return false;
    }

    public int getMethod() {
        return 8;
    }

    public int getLevel() {
        return 9;
    }

    public OutputSocket<?> getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return controller.getOutputSocket(name, options.set((Enum)FsOutputOption.STORE), template);
    }

    public ZipArchiveEntry newEntry(String name, Entry.Type type, Entry template, BitField<FsOutputOption> mknod) throws CharConversionException {
        ZipArchiveEntry entry;
        this.assertEncodable(name);
        name = ZipDriver.toZipOrTarEntryName((String)name, (Entry.Type)type);
        if (template instanceof ZipArchiveEntry) {
            entry = this.newEntry(name, (ZipArchiveEntry)template);
        } else {
            entry = this.newEntry(name);
            if (null != template) {
                entry.setTime(template.getTime(Entry.Access.WRITE));
                entry.setSize(template.getSize(Entry.Size.DATA));
            }
        }
        if (mknod.get((Enum)FsOutputOption.COMPRESS)) {
            if (8 != entry.getMethod()) {
                entry.setMethod(8);
                entry.setCompressedSize(-1L);
            }
        } else if (mknod.get((Enum)FsOutputOption.STORE)) {
            entry.setMethod(0);
        }
        return entry;
    }

    @Override
    public ZipArchiveEntry newEntry(String name) {
        return new ZipArchiveEntry(name);
    }

    public ZipArchiveEntry newEntry(String name, ZipArchiveEntry template) {
        return new ZipArchiveEntry(name, template);
    }

    public ZipInputShop newInputShop(FsModel model, InputSocket<?> input) throws IOException {
        ReadOnlyFile rof = input.newReadOnlyFile();
        try {
            return this.newZipInputShop(model, rof);
        }
        catch (IOException ex) {
            rof.close();
            throw ex;
        }
    }

    protected ZipInputShop newZipInputShop(FsModel model, ReadOnlyFile rof) throws IOException {
        return new ZipInputShop(this, rof);
    }

    public OutputShop<ZipArchiveEntry> newOutputShop(FsModel model, OutputSocket<?> output, @CheckForNull InputShop<ZipArchiveEntry> source) throws IOException {
        OutputStream out = output.newOutputStream();
        try {
            return new FsMultiplexedArchiveOutputShop((OutputShop)this.newZipOutputShop(model, out, (ZipInputShop)source), this.getPool());
        }
        catch (IOException ex) {
            out.close();
            throw ex;
        }
    }

    protected ZipOutputShop newZipOutputShop(FsModel model, OutputStream out, @CheckForNull ZipInputShop source) throws IOException {
        return new ZipOutputShop(this, out, source);
    }
}

