/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.filters;

import java.io.IOException;
import java.io.InputStream;

public abstract class ChunkingInputStream
extends InputStream {
    protected InputStream in = null;
    protected byte[] buffer = null;
    private int bufferPosition = 0;
    private int bufferAvailable = 0;

    protected void setInputStream(InputStream input) {
        this.in = input;
    }

    protected void setBufferSize(int size) {
        this.buffer = new byte[size];
    }

    protected int fillBufferFromInputStream() throws IOException {
        return this.fillBufferFromInputStream(0, this.buffer.length);
    }

    protected int fillBufferFromInputStream(int offset, int length) throws IOException {
        int read;
        int currRead;
        for (read = 0; read < length; read += currRead) {
            currRead = this.in.read(this.buffer, offset + read, length - read);
            if (currRead < 0 && read == 0) {
                return currRead;
            }
            if (currRead <= 0) break;
        }
        return read;
    }

    protected abstract int fillInternalBuffer() throws IOException;

    private int ensureDataAvailable() throws IOException {
        if (this.bufferAvailable > 0) {
            return this.bufferAvailable;
        }
        this.bufferPosition = 0;
        this.bufferAvailable = 0;
        int avail = this.fillInternalBuffer();
        if (avail > 0) {
            this.bufferAvailable = avail;
        }
        return this.bufferAvailable;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
    }

    public int read() throws IOException {
        int avail = this.ensureDataAvailable();
        if (avail <= 0) {
            return -1;
        }
        byte b = this.buffer[this.bufferPosition];
        ++this.bufferPosition;
        --this.bufferAvailable;
        return b & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int length) throws IOException {
        int read;
        int toRead;
        for (read = 0; read < length; read += toRead) {
            int avail = this.ensureDataAvailable();
            if (avail <= 0) {
                if (read > 0) {
                    return read;
                }
                return -1;
            }
            toRead = Math.min(length - read, avail);
            int srcIdx = this.bufferPosition;
            int dstIdx = off + read;
            for (int i = 0; i < toRead; ++i) {
                b[dstIdx++] = this.buffer[srcIdx++];
            }
            this.bufferPosition += toRead;
            this.bufferAvailable -= toRead;
        }
        return read;
    }

    public long skip(long n) throws IOException {
        long skipped;
        long toSkip;
        for (skipped = 0L; skipped < n; skipped += toSkip) {
            int avail = this.ensureDataAvailable();
            if (avail <= 0) {
                if (skipped > 0L) {
                    return skipped;
                }
                return -1L;
            }
            toSkip = Math.min(n - skipped, (long)avail);
            this.bufferPosition = (int)((long)this.bufferPosition + toSkip);
            this.bufferAvailable = (int)((long)this.bufferAvailable - toSkip);
        }
        return skipped;
    }

    public int available() throws IOException {
        return this.bufferAvailable;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(": ");
        if (this.in == null) {
            sb.append("null");
        } else {
            sb.append(this.in.toString());
        }
        return sb.toString();
    }
}

