/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BPCCBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComponentMapBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ImageHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.LabelBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.PaletteBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ROIBox;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CodestreamHeaderBox
extends JP2Box {
    private Codestream curCodestream;

    public CodestreamHeaderBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    public boolean readBox() throws IOException {
        if (this._parentBox != null) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        this.hasBoxes = true;
        int n = this._module.getNCodestreamHeaders() + 1;
        this._module.setNCodestreams(n);
        this.curCodestream = this._module.getCodestream(n);
        int n2 = (int)this._boxHeader.getDataLength();
        BoxHeader boxHeader = new BoxHeader(this._module, this._dstrm);
        int n3 = 0;
        JP2Box jP2Box = null;
        while (this.hasNext()) {
            jP2Box = (JP2Box)this.next();
            if (n3 == 0 && jP2Box instanceof LabelBox) {
                n3 = 1;
                if (!jP2Box.readBox()) {
                    return false;
                }
                this.curCodestream.setLabelProperty(new Property("Label", PropertyType.STRING, (Object)((LabelBox)jP2Box).getLabel()));
                jP2Box = (JP2Box)this.next();
                if (jP2Box != null) continue;
                break;
            }
            if (n3 <= 1) {
                if (jP2Box instanceof ImageHeaderBox) {
                    n3 = 2;
                    if (jP2Box.readBox()) continue;
                    return false;
                }
                this._repInfo.setMessage((Message)new ErrorMessage("First box of Codestream Header must be image header", this._module.getFilePos()));
                this._repInfo.setWellFormed(false);
                return false;
            }
            if (jP2Box instanceof BPCCBox || jP2Box instanceof PaletteBox || jP2Box instanceof ComponentMapBox || jP2Box instanceof ROIBox) {
                if (jP2Box.readBox()) continue;
                return false;
            }
            jP2Box.skipBox();
        }
        this.finalizeBytesRead();
        return true;
    }

    protected Codestream getCodestream() {
        return this.curCodestream;
    }

    protected String getSelfPropName() {
        return "Codestream Header Box";
    }
}

