/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid6;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.gov.nationalarchives.droid.core.signature.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid6.InternalSignature;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class InternalSignatureCollection
extends SimpleElement {
    private static final int DEFAULT_COLLECTION_SIZE = 10;
    private List<InternalSignature> intSigs = new ArrayList<InternalSignature>(10);
    private Map<Integer, InternalSignature> sigsByID = new HashMap<Integer, InternalSignature>();

    public List<InternalSignature> getMatchingSignatures(ByteReader targetFile, long maxBytesToScan) {
        ArrayList<InternalSignature> matchingSigs = new ArrayList<InternalSignature>();
        if (targetFile.getNumBytes() > 0L) {
            int stop = this.intSigs.size();
            for (int sigIndex = 0; sigIndex < stop; ++sigIndex) {
                InternalSignature internalSig = this.intSigs.get(sigIndex);
                if (!internalSig.matches(targetFile, maxBytesToScan)) continue;
                matchingSigs.add(internalSig);
            }
        }
        return matchingSigs;
    }

    public void prepareForUse() {
        Iterator<InternalSignature> sigIterator = this.intSigs.iterator();
        while (sigIterator.hasNext()) {
            InternalSignature sig = sigIterator.next();
            sig.prepareForUse();
            if (!sig.isInvalidSignature()) continue;
            this.sigsByID.remove(sig.getID());
            this.getLog().warn((Object)this.getInvalidSignatureWarningMessage(sig));
            sigIterator.remove();
        }
    }

    private String getInvalidSignatureWarningMessage(InternalSignature sig) {
        return String.format("Removing invalid signature [id:%d]. Matches formats: %s", sig.getID(), sig.getFileFormatDescriptions());
    }

    public final void addInternalSignature(InternalSignature iSig) {
        this.intSigs.add(iSig);
        this.sigsByID.put(iSig.getID(), iSig);
    }

    public final void removeInternalSignature(InternalSignature iSig) {
        this.intSigs.remove(iSig);
        this.sigsByID.remove(iSig.getID());
    }

    public final InternalSignature getInternalSignature(int signatureID) {
        return this.sigsByID.get(signatureID);
    }

    public final void setInternalSignatures(List<InternalSignature> iSigs) {
        this.intSigs.clear();
        this.sigsByID.clear();
        for (InternalSignature signature : iSigs) {
            this.addInternalSignature(signature);
        }
    }

    public final List<InternalSignature> getInternalSignatures() {
        return this.intSigs;
    }

    public void sortSignatures(Comparator<InternalSignature> compareWith) {
        Collections.sort(this.intSigs, compareWith);
    }
}

