/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class LazyInputSocket<E extends Entry>
extends DecoratingInputSocket<E> {
    public LazyInputSocket(@NonNull InputSocket<? extends E> input) {
        super(input);
    }

    @Override
    public ReadOnlyFile newReadOnlyFile() {
        return new ProxyReadOnlyFile();
    }

    @Override
    public InputStream newInputStream() {
        return new ProxyInputStream();
    }

    @NotThreadSafe
    private class ProxyInputStream
    extends DecoratingInputStream {
        ProxyInputStream() {
            super(null);
        }

        InputStream getInputStream() throws IOException {
            return null != this.delegate ? this.delegate : (this.delegate = LazyInputSocket.this.getBoundSocket().newInputStream());
        }

        @Override
        public int read() throws IOException {
            return this.getInputStream().read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.getInputStream().read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.getInputStream().skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.getInputStream().available();
        }

        @Override
        public void close() throws IOException {
            if (null != this.delegate) {
                this.delegate.close();
            }
        }

        @Override
        public void mark(int readlimit) {
            try {
                this.getInputStream().mark(readlimit);
            }
            catch (IOException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        @Override
        public void reset() throws IOException {
            this.getInputStream().reset();
        }

        @Override
        public boolean markSupported() {
            try {
                return this.getInputStream().markSupported();
            }
            catch (IOException ignored) {
                return false;
            }
        }
    }

    @NotThreadSafe
    private class ProxyReadOnlyFile
    extends DecoratingReadOnlyFile {
        ProxyReadOnlyFile() {
            super(null);
        }

        ReadOnlyFile getReadOnlyFile() throws IOException {
            return null != this.delegate ? this.delegate : (this.delegate = LazyInputSocket.this.getBoundSocket().newReadOnlyFile());
        }

        @Override
        public long length() throws IOException {
            return this.getReadOnlyFile().length();
        }

        @Override
        public long getFilePointer() throws IOException {
            return this.getReadOnlyFile().getFilePointer();
        }

        @Override
        public void seek(long pos) throws IOException {
            this.getReadOnlyFile().seek(pos);
        }

        @Override
        public int read() throws IOException {
            return this.getReadOnlyFile().read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.getReadOnlyFile().read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (null != this.delegate) {
                this.delegate.close();
            }
        }
    }
}

