/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.droid6;

import net.domesdaybook.expression.compiler.sequence.SequenceMatcherCompiler;
import net.domesdaybook.expression.parser.ParseException;
import net.domesdaybook.matcher.sequence.SequenceMatcher;
import net.domesdaybook.reader.ByteReader;
import uk.gov.nationalarchives.droid.core.signature.droid6.FragmentRewriter;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class SideFragment
extends SimpleElement {
    private static final String FRAGMENT_PARSE_ERROR = "The signature fragment [%s] could not be parsed. The error returned was [%s]";
    private int myPosition;
    private int myMinOffset;
    private int myMaxOffset;
    private SequenceMatcher matcher;
    private boolean isInvalidFragment;

    public final void setPosition(int thePosition) {
        this.myPosition = thePosition;
    }

    public final void setMinOffset(int theMinOffset) {
        this.myMinOffset = theMinOffset;
        if (this.myMaxOffset < this.myMinOffset) {
            this.myMaxOffset = theMinOffset;
        }
    }

    public final void setMaxOffset(int theMaxOffset) {
        this.myMaxOffset = theMaxOffset;
        if (this.myMinOffset > this.myMaxOffset) {
            this.myMinOffset = theMaxOffset;
        }
    }

    public final void setFragment(String expression) {
        try {
            SequenceMatcherCompiler compiler = new SequenceMatcherCompiler();
            String transformed = FragmentRewriter.rewriteFragment(expression);
            this.matcher = (SequenceMatcher)compiler.compile(transformed);
        }
        catch (ParseException ex) {
            String warning = String.format(FRAGMENT_PARSE_ERROR, expression, ex.getMessage());
            this.isInvalidFragment = true;
            this.getLog().warn((Object)warning);
        }
    }

    public boolean isInvalidFragment() {
        return this.isInvalidFragment;
    }

    @Override
    public final void setAttributeValue(String name, String value) {
        if ("Position".equals(name)) {
            this.setPosition(Integer.parseInt(value));
        } else if ("MinOffset".equals(name)) {
            this.setMinOffset(Integer.parseInt(value));
        } else if ("MaxOffset".equals(name)) {
            this.setMaxOffset(Integer.parseInt(value));
        } else {
            this.unknownAttributeWarning(name, this.getElementName());
        }
    }

    public final int getPosition() {
        return this.myPosition;
    }

    public final int getMinOffset() {
        return this.myMinOffset;
    }

    public final int getMaxOffset() {
        return this.myMaxOffset;
    }

    public final int getNumBytes() {
        return this.matcher == null ? 0 : this.matcher.length();
    }

    @Override
    public final void completeElementContent() {
        this.setFragment(this.getText());
    }

    public final boolean matchesBytes(ByteReader bytes, long matchFrom) {
        return this.matcher.matches(bytes, matchFrom);
    }

    public final String toRegularExpression(boolean prettyPrint) {
        return this.matcher == null ? "" : this.matcher.toRegularExpression(prettyPrint);
    }
}

