/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.container;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.gov.nationalarchives.droid.container.ContainerIdentifierInit;
import uk.gov.nationalarchives.droid.container.ContainerSignature;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatch;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatchCollection;
import uk.gov.nationalarchives.droid.container.ContainerSignatureSaxParser;
import uk.gov.nationalarchives.droid.container.FileFormatMapping;
import uk.gov.nationalarchives.droid.container.IdentifierEngine;
import uk.gov.nationalarchives.droid.container.TriggerPuid;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.interfaces.DroidCore;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFormatResolver;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ContainerIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ContainerIdentifierFactory;
import uk.gov.nationalarchives.droid.core.interfaces.signature.ErrorCode;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;

public abstract class AbstractContainerIdentifier
implements ContainerIdentifier {
    private static final String ERROR_READING_SIGNATURE_FILE = "Error reading signature file";
    private ContainerSignatureSaxParser signatureFileParser;
    private ContainerIdentifierFactory containerIdentifierFactory;
    private String containerType;
    private ArchiveFormatResolver containerFormatResolver;
    private DroidCore droidCore;
    private String signatureFilePath;
    private ContainerIdentifierInit init;
    private Map<Integer, List<FileFormatMapping>> formats = new HashMap<Integer, List<FileFormatMapping>>();
    private long maxBytesToScan = -1L;
    private IdentifierEngine identifierEngine;

    public final IdentificationResultCollection submit(IdentificationRequest request) throws IOException {
        ContainerSignatureMatchCollection matches = new ContainerSignatureMatchCollection(this.getContainerSignatures(), this.init.getUniqueFileEntries(), this.maxBytesToScan);
        this.process(request, matches);
        IdentificationResultCollection results = new IdentificationResultCollection(request);
        for (ContainerSignatureMatch match : matches.getContainerSignatureMatches()) {
            if (!match.isMatch()) continue;
            List<FileFormatMapping> mappings = this.formats.get(match.getSignature().getId());
            for (FileFormatMapping mapping : mappings) {
                IdentificationResultImpl result = new IdentificationResultImpl();
                result.setMethod(IdentificationMethod.CONTAINER);
                result.setRequestMetaData(request.getRequestMetaData());
                result.setPuid(mapping.getPuid());
                results.addResult((IdentificationResult)result);
            }
        }
        return results;
    }

    protected abstract void process(IdentificationRequest var1, ContainerSignatureMatchCollection var2) throws IOException;

    public IdentifierEngine getIdentifierEngine() {
        return this.identifierEngine;
    }

    public void setIdentifierEngine(IdentifierEngine identifierEngine) {
        this.identifierEngine = identifierEngine;
    }

    public void addContainerSignature(ContainerSignature containerSignature) {
        this.init.addContainerSignature(containerSignature);
    }

    public void setFormats(Map<Integer, List<FileFormatMapping>> formats) {
        this.formats = formats;
    }

    public List<ContainerSignature> getContainerSignatures() {
        return this.init.getContainerSignatures();
    }

    protected Map<Integer, List<FileFormatMapping>> getFormats() {
        return this.formats;
    }

    public void init() throws SignatureFileException {
        try {
            FileInputStream sigFile = new FileInputStream(this.signatureFilePath);
            ContainerSignatureDefinitions defs = this.signatureFileParser.parse(sigFile);
            this.init = new ContainerIdentifierInit();
            this.init.init(defs, this.containerType, this.formats, this.droidCore);
            for (TriggerPuid triggerPuid : defs.getTiggerPuids()) {
                if (!triggerPuid.getContainerType().equals(this.containerType)) continue;
                this.containerIdentifierFactory.addContainerIdentifier(this.containerType, (ContainerIdentifier)this);
                String puid = triggerPuid.getPuid();
                this.containerFormatResolver.registerPuid(puid, this.containerType);
            }
        }
        catch (IOException e) {
            throw new SignatureFileException(ERROR_READING_SIGNATURE_FILE, (Throwable)e, ErrorCode.FILE_NOT_FOUND);
        }
        catch (SignatureParseException e) {
            throw new SignatureFileException(ERROR_READING_SIGNATURE_FILE, (Throwable)e, ErrorCode.INVALID_SIGNATURE_FILE);
        }
    }

    public void setSignatureFileParser(ContainerSignatureSaxParser signatureFileParser) {
        this.signatureFileParser = signatureFileParser;
    }

    public void setContainerIdentifierFactory(ContainerIdentifierFactory containerIdentifierFactory) {
        this.containerIdentifierFactory = containerIdentifierFactory;
    }

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    public void setContainerFormatResolver(ArchiveFormatResolver containerFormatResolver) {
        this.containerFormatResolver = containerFormatResolver;
    }

    public void setDroidCore(DroidCore droidCore) {
        this.droidCore = droidCore;
    }

    public void setSignatureFilePath(String signatureFilePath) {
        this.signatureFilePath = signatureFilePath;
    }

    public void setMaxBytesToScan(long maxBytesToScan) {
        this.maxBytesToScan = maxBytesToScan;
    }
}

