/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.Filter;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class CrossRefStream {
    private PdfStream _xstrm;
    private PdfDictionary _dict;
    private int _size;
    private int[] _index;
    private int[] _fieldSizes;
    private int _freeCount;
    private Filter[] _filters;
    private int _entriesRead;
    private int _bytesPerEntry;
    private long _prevXref;
    private int _objType;
    private int _objNum;
    private int _objField1;
    private int _objField2;

    public CrossRefStream(PdfStream pdfStream) {
        this._xstrm = pdfStream;
        this._dict = pdfStream.getDict();
        this._freeCount = 0;
    }

    public boolean isValid() {
        try {
            Object object;
            Object object2;
            PdfObject pdfObject = this._dict.get("Type");
            String string = null;
            if (pdfObject instanceof PdfSimpleObject && !"XRef".equals(string = ((PdfSimpleObject)pdfObject).getStringValue())) {
                return false;
            }
            if (string == null) {
                return false;
            }
            PdfObject pdfObject2 = this._dict.get("Size");
            if (!(pdfObject2 instanceof PdfSimpleObject)) {
                return false;
            }
            this._size = ((PdfSimpleObject)pdfObject2).getIntValue();
            PdfObject pdfObject3 = this._dict.get("Index");
            if (pdfObject3 instanceof PdfArray) {
                object2 = ((PdfArray)pdfObject3).getContent();
                this._index = new int[2];
                object = (PdfSimpleObject)((Vector)object2).get(0);
                this._index[0] = ((PdfSimpleObject)object).getIntValue();
                object = (PdfSimpleObject)((Vector)object2).get(1);
                this._index[1] = ((PdfSimpleObject)object).getIntValue();
            } else {
                this._index = new int[]{0, this._size};
            }
            object2 = this._dict.get("W");
            if (object2 instanceof PdfArray) {
                object = ((PdfArray)object2).getContent();
                int n = ((Vector)object).size();
                this._fieldSizes = new int[n];
                for (int i = 0; i < n; ++i) {
                    PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)((Vector)object).get(i);
                    this._fieldSizes[i] = pdfSimpleObject.getIntValue();
                }
            }
            this._prevXref = (object = this._dict.get("Prev")) instanceof PdfSimpleObject ? (long)((PdfSimpleObject)object).getIntValue() : -1L;
            this._filters = this._xstrm.getFilters();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void initRead(RandomAccessFile randomAccessFile) throws IOException, PdfException {
        Stream stream = this._xstrm.getStream();
        stream.setFilters(this._xstrm.getFilters());
        stream.initRead(randomAccessFile);
        this._entriesRead = 0;
        this._bytesPerEntry = 0;
        for (int i = 0; i < this._fieldSizes.length; ++i) {
            this._bytesPerEntry += this._fieldSizes[i];
        }
    }

    public boolean readNextObject() throws IOException {
        int n = this._fieldSizes[0];
        Stream stream = this._xstrm.getStream();
        while (this._entriesRead++ < this._index[1]) {
            int n2;
            int n3;
            if (n != 0) {
                this._objType = 0;
                for (n3 = 0; n3 < n; ++n3) {
                    n2 = stream.read();
                    if (n2 < 0) {
                        return false;
                    }
                    this._objType = this._objType * 256 + n2;
                }
            } else {
                this._objType = 1;
            }
            n = this._fieldSizes[1];
            this._objField1 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                n2 = stream.read();
                if (n2 < 0) {
                    return false;
                }
                this._objField1 = this._objField1 * 256 + n2;
            }
            n = this._fieldSizes[2];
            this._objField2 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                n2 = stream.read();
                if (n2 < 0) {
                    return false;
                }
                this._objField2 = this._objField2 * 256 + n2;
            }
            if (this._objType != 0) {
                this._objNum = this._index[0] + this._entriesRead - 1;
                return true;
            }
            ++this._freeCount;
        }
        return false;
    }

    public int getObjNum() {
        return this._objNum;
    }

    public boolean isObjCompressed() {
        return this._objType == 2;
    }

    public int getFreeCount() {
        return this._freeCount;
    }

    public int getNumObjects() {
        return this._index[0] + this._index[1];
    }

    public int getOffset() {
        return this._objField1;
    }

    public int getContentStreamObjNum() {
        return this._objField1;
    }

    public long getPrevXref() {
        return this._prevXref;
    }

    public int getContentStreamIndex() {
        return this._objField2;
    }
}

