/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class PageObject
extends DocNode {
    private List _contentStreams = null;
    private static final String badPageStr = "Invalid dictionary data for page";

    public PageObject(PdfModule pdfModule, PageTreeNode pageTreeNode, PdfDictionary pdfDictionary) {
        super(pdfModule, pageTreeNode, pdfDictionary);
        this._pageObjectFlag = true;
    }

    public void loadContent(PdfModule pdfModule) throws PdfException {
        block8: {
            try {
                PdfObject pdfObject = this._dict.get("Contents");
                if (pdfObject == null) break block8;
                if ((pdfObject = pdfModule.resolveIndirectObject(pdfObject)) instanceof PdfStream) {
                    this._contentStreams = new ArrayList(1);
                    this._contentStreams.add(pdfObject);
                    return;
                }
                if (pdfObject instanceof PdfArray) {
                    Vector vector = ((PdfArray)pdfObject).getContent();
                    if (vector.size() == 0) {
                        return;
                    }
                    this._contentStreams = new ArrayList(vector.size());
                    for (int i = 0; i < vector.size(); ++i) {
                        PdfObject pdfObject2 = (PdfObject)vector.elementAt(i);
                        pdfObject2 = pdfModule.resolveIndirectObject(pdfObject2);
                        this._contentStreams.add((PdfStream)pdfObject2);
                    }
                    break block8;
                }
                throw new PdfInvalidException(badPageStr, 0L);
            }
            catch (NullPointerException nullPointerException) {
                throw new PdfInvalidException(badPageStr, 0L);
            }
            catch (ClassCastException classCastException) {
                throw new PdfInvalidException(badPageStr, 0L);
            }
            catch (IOException iOException) {
                throw new PdfMalformedException(badPageStr, 0L);
            }
        }
    }

    public List getContentStreams() {
        return this._contentStreams;
    }

    public PdfArray getAnnotations() throws PdfException {
        String string = "Invalid Annotations";
        try {
            return (PdfArray)this._module.resolveIndirectObject(this._dict.get("Annots"));
        }
        catch (ClassCastException classCastException) {
            throw new PdfInvalidException(string);
        }
        catch (IOException iOException) {
            throw new PdfMalformedException(string);
        }
    }

    public void startWalk() {
        this._walkFinished = false;
    }

    public PageObject nextPageObject() {
        if (this._walkFinished) {
            return null;
        }
        this._walkFinished = true;
        return this;
    }

    public DocNode nextDocNode() {
        return this.nextPageObject();
    }

    public PdfArray getArtBox() throws PdfException {
        try {
            PdfArray pdfArray = (PdfArray)this._dict.get("ArtBox");
            if (pdfArray == null) {
                return null;
            }
            if (pdfArray.toRectangle() != null) {
                return pdfArray;
            }
            throw new PdfInvalidException("Malformed ArtBox in page tree");
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Malformed ArtBox in page tree");
        }
    }

    public PdfArray getTrimBox() throws PdfException {
        try {
            PdfArray pdfArray = (PdfArray)this._dict.get("TrimBox");
            if (pdfArray == null) {
                return null;
            }
            if (pdfArray.toRectangle() != null) {
                return pdfArray;
            }
            throw new PdfInvalidException("Malformed TrimBox in page tree");
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Malformed TrimBox in page tree");
        }
    }

    public PdfArray getBleedBox() throws PdfException {
        try {
            PdfArray pdfArray = (PdfArray)this._dict.get("BleedBox");
            if (pdfArray == null) {
                return null;
            }
            if (pdfArray.toRectangle() != null) {
                return pdfArray;
            }
            throw new PdfInvalidException("Malformed BleedBox in page tree");
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Malformed BleedBox in page tree");
        }
    }
}

