/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.FileSpecification;
import edu.harvard.hul.ois.jhove.module.pdf.Filter;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class PdfStream
extends PdfObject {
    private Stream _stream;
    private PdfDictionary _dict;
    private Filter[] _filters;

    public PdfStream(PdfDictionary pdfDictionary, Stream stream, int n, int n2) throws PdfException {
        super(n, n2);
        this._stream = stream;
        this._dict = pdfDictionary;
        this.extractFilters();
    }

    public PdfStream(PdfDictionary pdfDictionary, Stream stream) throws PdfException {
        this._stream = stream;
        this._dict = pdfDictionary;
        this.extractFilters();
    }

    public PdfDictionary getDict() {
        return this._dict;
    }

    public Stream getStream() {
        return this._stream;
    }

    public String getFileSpecification() {
        PdfObject pdfObject = this._dict.get("F");
        if (pdfObject == null) {
            return null;
        }
        try {
            FileSpecification fileSpecification = new FileSpecification(pdfObject);
            return fileSpecification.getSpecString();
        }
        catch (PdfException pdfException) {
            return null;
        }
    }

    public Filter[] getFilters() throws PdfException {
        return this._filters;
    }

    public String getFilterName() {
        PdfObject pdfObject;
        PdfObject pdfObject2 = this._dict.get("DecodeParams");
        if (pdfObject2 instanceof PdfDictionary && (pdfObject = ((PdfDictionary)pdfObject2).get("Name")) instanceof PdfSimpleObject) {
            return ((PdfSimpleObject)pdfObject).getStringValue();
        }
        return null;
    }

    private void extractFilters() throws PdfException {
        boolean bl = false;
        this._filters = new Filter[0];
        PdfObject pdfObject = this._dict.get("Filter");
        if (pdfObject == null) {
            pdfObject = this._dict.get("FFilter");
            if (pdfObject == null) {
                return;
            }
            bl = true;
        }
        PdfObject pdfObject2 = bl ? this._dict.get("FDecodeParms") : this._dict.get("DecodeParms");
        try {
            if (pdfObject instanceof PdfArray) {
                Vector vector = ((PdfArray)pdfObject).getContent();
                int n = vector.size();
                Filter[] filterArray = new Filter[n];
                Vector vector2 = null;
                if (pdfObject2 != null) {
                    vector2 = ((PdfArray)pdfObject2).getContent();
                }
                for (int i = 0; i < n; ++i) {
                    PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)vector.get(i);
                    filterArray[i] = new Filter(pdfSimpleObject.getStringValue());
                    if (vector2 == null) continue;
                    filterArray[i].setDecodeParms((PdfDictionary)vector2.get(i));
                }
                this._filters = filterArray;
            } else {
                Filter[] filterArray = new Filter[]{new Filter(((PdfSimpleObject)pdfObject).getStringValue())};
                if (pdfObject2 instanceof PdfDictionary) {
                    filterArray[0].setDecodeParms((PdfDictionary)pdfObject2);
                }
                this._filters = filterArray;
            }
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Malformed filter");
        }
    }

    protected List makeFilterList() throws PdfException {
        Filter[] filterArray = this.getFilters();
        if (filterArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(filterArray.length);
        for (int i = 0; i < filterArray.length; ++i) {
            arrayList.add(filterArray[i].getFilterName());
        }
        return arrayList;
    }

    public boolean isImage() {
        PdfObject pdfObject = this._dict.get("Subtype");
        if (pdfObject instanceof PdfSimpleObject) {
            String string = ((PdfSimpleObject)pdfObject).getStringValue();
            return "Image".equals(string);
        }
        return false;
    }
}

