/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.LEDataOutputStream;
import de.schlichtherle.truezip.util.JSE7;
import de.schlichtherle.truezip.zip.Jdk6Deflater;
import de.schlichtherle.truezip.zip.RawZipFile;
import de.schlichtherle.truezip.zip.ZipConstants;
import de.schlichtherle.truezip.zip.ZipDeflater;
import de.schlichtherle.truezip.zip.ZipEntry;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class RawZipOutputStream<E extends ZipEntry>
extends DecoratingOutputStream
implements Iterable<E> {
    public static final Charset DEFAULT_CHARSET = ZipConstants.DEFAULT_CHARSET;
    private final Charset charset;
    private final CRC32 crc = new CRC32();
    private final ZipDeflater def = JSE7.AVAILABLE ? new ZipDeflater() : new Jdk6Deflater();
    private final byte[] dbuf = new byte[65536];
    private final byte[] sbuf = new byte[1];
    private String comment = "";
    private short method = (short)8;
    private final Map<String, E> entries = new LinkedHashMap<String, E>();
    private long dataStart;
    private long cdOffset;
    private boolean finished;
    private boolean closed;
    @CheckForNull
    private E entry;
    private boolean deflate;

    protected RawZipOutputStream(OutputStream out, Charset charset) {
        super((OutputStream)RawZipOutputStream.toLEDataOutputStream(out));
        if (null == out || null == charset) {
            throw new NullPointerException();
        }
        this.charset = charset;
    }

    protected RawZipOutputStream(OutputStream out, RawZipFile<E> appendee) throws ZipException {
        super((OutputStream)((Object)new AppendingLEDataOutputStream(out, appendee)));
        if (null == out) {
            throw new NullPointerException();
        }
        if (appendee.getPostambleLength() > 0L) {
            throw new ZipException("Appending to a ZIP file with a postamble is not supported!");
        }
        for (ZipEntry entry : appendee) {
            this.entries.put(entry.getName(), entry);
        }
        this.charset = Charset.forName(appendee.getCharset());
    }

    private static LEDataOutputStream toLEDataOutputStream(OutputStream out) {
        return out instanceof LEDataOutputStream ? (LEDataOutputStream)out : new LEDataOutputStream(out);
    }

    public String getCharset() {
        return this.charset.name();
    }

    public int size() {
        return this.entries.size();
    }

    @Deprecated
    public Enumeration<? extends ZipEntry> entries() {
        return Collections.enumeration(this.entries.values());
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.values().iterator();
    }

    public E getEntry(String name) {
        return (E)((ZipEntry)this.entries.get(name));
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("Invalid compression method: " + method);
        }
        this.method = (short)method;
    }

    public int getLevel() {
        return this.def.getLevel();
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    public long length() {
        return ((LEDataOutputStream)this.delegate).size();
    }

    public boolean isBusy() {
        return null != this.entry;
    }

    public final void putNextEntry(E entry) throws IOException {
        this.putNextEntry(entry, true);
    }

    public void putNextEntry(E entry, boolean deflate) throws IOException {
        this.closeEntry();
        String name = ((ZipEntry)entry).getName();
        long size = ((ZipEntry)entry).getNameLength(this.charset) + ((ZipEntry)entry).getExtraLength() + ((ZipEntry)entry).getCommentLength(this.charset);
        if (size > 65535L) {
            throw new ZipException(((ZipEntry)entry).getName() + " (sum of name, extra fields and comment too long: " + size + ")");
        }
        int method = ((ZipEntry)entry).getMethod();
        if (method == -1) {
            method = this.getMethod();
        }
        switch (method) {
            case 0: {
                RawZipOutputStream.checkLocalFileHeaderData(entry);
                this.deflate = false;
                break;
            }
            case 8: {
                if (!deflate) {
                    RawZipOutputStream.checkLocalFileHeaderData(entry);
                }
                this.deflate = deflate;
                break;
            }
            default: {
                throw new ZipException(((ZipEntry)entry).getName() + " (unsupported compression method: " + method + ")");
            }
        }
        if (((ZipEntry)entry).getPlatform() == -1) {
            ((ZipEntry)entry).setPlatform((short)0);
        }
        if (((ZipEntry)entry).getMethod() == -1) {
            ((ZipEntry)entry).setMethod(method);
        }
        if (((ZipEntry)entry).getTime() == -1L) {
            ((ZipEntry)entry).setTime(System.currentTimeMillis());
        }
        this.entry = entry;
        this.writeLocalFileHeader();
        this.entries.put(name, entry);
    }

    private static void checkLocalFileHeaderData(ZipEntry entry) throws ZipException {
        if (entry.getCrc() == -1L) {
            throw new ZipException(entry.getName() + " (unknown CRC checksum)");
        }
        if (entry.getCompressedSize32() == -1L) {
            throw new ZipException(entry.getName() + " (unknown compressed size)");
        }
        if (entry.getSize32() == -1L) {
            throw new ZipException(entry.getName() + " (unknown uncompressed size)");
        }
    }

    private void writeLocalFileHeader() throws IOException {
        E entry = this.entry;
        assert (null != entry);
        LEDataOutputStream dos = (LEDataOutputStream)this.delegate;
        long crc = ((ZipEntry)entry).getCrc();
        long csize = ((ZipEntry)entry).getCompressedSize();
        long size = ((ZipEntry)entry).getSize();
        long csize32 = ((ZipEntry)entry).getCompressedSize32();
        long size32 = ((ZipEntry)entry).getSize32();
        long offset = dos.size();
        boolean dd = crc == -1L || csize == -1L || size == -1L;
        boolean zip64 = csize >= 0xFFFFFFFFL || size >= 0xFFFFFFFFL || offset >= 0xFFFFFFFFL || ZipConstants.FORCE_ZIP64_EXT;
        boolean utf8 = ZipConstants.UTF8.equals(this.charset);
        int general = (dd ? 8 : 0) | (utf8 ? 2048 : 0);
        this.finished = false;
        dos.writeInt(67324752);
        dos.writeShort(zip64 ? 45 : (dd ? 20 : 10));
        dos.writeShort(general);
        dos.writeShort(((ZipEntry)entry).getMethod());
        dos.writeInt((int)((ZipEntry)entry).getDosTime());
        if (dd) {
            dos.writeInt(0);
            dos.writeInt(0);
            dos.writeInt(0);
        } else {
            dos.writeInt((int)crc);
            dos.writeInt((int)csize32);
            dos.writeInt((int)size32);
        }
        byte[] name = ((ZipEntry)entry).getName().getBytes(this.charset);
        dos.writeShort(name.length);
        byte[] extra = ((ZipEntry)entry).getExtra(!dd);
        assert (extra != null);
        dos.writeShort(extra.length);
        dos.write(name);
        dos.write(extra);
        ((ZipEntry)entry).setGeneral(general);
        ((ZipEntry)entry).setOffset(offset);
        this.dataStart = dos.size();
    }

    public void write(int b) throws IOException {
        byte[] buf = this.sbuf;
        buf[0] = (byte)b;
        this.write(buf, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        E entry = this.entry;
        if (null != entry) {
            if (len == 0) {
                return;
            }
            if (this.deflate) {
                assert (!this.def.finished());
                this.def.setInput(b, off, len);
                while (!this.def.needsInput()) {
                    this.deflate();
                }
                this.crc.update(b, off, len);
            } else {
                this.delegate.write(b, off, len);
                if (((ZipEntry)entry).getMethod() != 8) {
                    this.crc.update(b, off, len);
                }
            }
        } else {
            this.delegate.write(b, off, len);
        }
    }

    private void deflate() throws IOException {
        int dlen = this.def.deflate(this.dbuf, 0, this.dbuf.length);
        if (dlen > 0) {
            this.delegate.write(this.dbuf, 0, dlen);
        }
    }

    public void closeEntry() throws IOException {
        E entry = this.entry;
        if (null == entry) {
            return;
        }
        switch (((ZipEntry)entry).getMethod()) {
            case 0: {
                long expectedCrc = this.crc.getValue();
                if (expectedCrc != ((ZipEntry)entry).getCrc()) {
                    throw new ZipException(((ZipEntry)entry).getName() + " (bad CRC-32: 0x" + Long.toHexString(((ZipEntry)entry).getCrc()) + " expected: 0x" + Long.toHexString(expectedCrc) + ")");
                }
                long written = ((LEDataOutputStream)this.delegate).size();
                long entrySize = written - this.dataStart;
                if (((ZipEntry)entry).getSize() == entrySize) break;
                throw new ZipException(((ZipEntry)entry).getName() + " (bad uncompressed Size: " + ((ZipEntry)entry).getSize() + " expected: " + entrySize + ")");
            }
            case 8: {
                if (!this.deflate) break;
                assert (!this.def.finished());
                this.def.finish();
                while (!this.def.finished()) {
                    this.deflate();
                }
                ((ZipEntry)entry).setCrc(this.crc.getValue());
                ((ZipEntry)entry).setCompressedSize(this.def.getBytesWritten());
                ((ZipEntry)entry).setSize(this.def.getBytesRead());
                this.def.reset();
                break;
            }
            default: {
                throw new ZipException(((ZipEntry)entry).getName() + " (unsupported Compression Method: " + ((ZipEntry)entry).getMethod() + ")");
            }
        }
        this.writeDataDescriptor();
        this.flush();
        this.crc.reset();
        this.entry = null;
    }

    private void writeDataDescriptor() throws IOException {
        E entry = this.entry;
        assert (null != entry);
        if (!((ZipEntry)entry).getGeneralBit(3)) {
            return;
        }
        LEDataOutputStream dos = (LEDataOutputStream)this.delegate;
        long crc = ((ZipEntry)entry).getCrc();
        long csize = ((ZipEntry)entry).getCompressedSize();
        long size = ((ZipEntry)entry).getSize();
        long offset = ((ZipEntry)entry).getOffset();
        boolean zip64 = csize >= 0xFFFFFFFFL || size >= 0xFFFFFFFFL || offset >= 0xFFFFFFFFL || ZipConstants.FORCE_ZIP64_EXT;
        dos.writeInt(134695760);
        dos.writeInt((int)crc);
        if (zip64) {
            dos.writeLong(csize);
            dos.writeLong(size);
        } else {
            dos.writeInt((int)csize);
            dos.writeInt((int)size);
        }
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.closeEntry();
        LEDataOutputStream dos = (LEDataOutputStream)this.delegate;
        this.cdOffset = dos.size();
        for (ZipEntry entry : this.entries.values()) {
            this.writeCentralFileHeader(entry);
        }
        this.writeEndOfCentralDirectory();
    }

    private void writeCentralFileHeader(ZipEntry entry) throws IOException {
        assert (null != entry);
        LEDataOutputStream dos = (LEDataOutputStream)this.delegate;
        long csize32 = entry.getCompressedSize32();
        long size32 = entry.getSize32();
        long offset32 = entry.getOffset32();
        boolean dd = entry.getGeneralBit(3);
        boolean zip64 = csize32 >= 0xFFFFFFFFL || size32 >= 0xFFFFFFFFL || offset32 >= 0xFFFFFFFFL || ZipConstants.FORCE_ZIP64_EXT;
        dos.writeInt(33639248);
        dos.writeShort(entry.getPlatform() << 8 | 0x3F);
        dos.writeShort(zip64 ? 45 : (dd ? 20 : 10));
        dos.writeShort(entry.getGeneral());
        dos.writeShort(entry.getMethod());
        dos.writeInt((int)entry.getDosTime());
        dos.writeInt((int)entry.getCrc());
        dos.writeInt((int)csize32);
        dos.writeInt((int)size32);
        byte[] name = entry.getName().getBytes(this.charset);
        dos.writeShort(name.length);
        byte[] extra = entry.getExtra();
        assert (extra != null);
        dos.writeShort(extra.length);
        String comment = entry.getComment();
        if (comment == null) {
            comment = "";
        }
        byte[] data = comment.getBytes(this.charset);
        dos.writeShort(data.length);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeInt(entry.isDirectory() ? 16 : 0);
        dos.writeInt((int)offset32);
        dos.write(name);
        dos.write(extra);
        dos.write(data);
    }

    private void writeEndOfCentralDirectory() throws IOException {
        boolean zip64;
        LEDataOutputStream dos = (LEDataOutputStream)this.delegate;
        long cdEntries = this.entries.size();
        long cdSize = dos.size() - this.cdOffset;
        long cdOffset = this.cdOffset;
        boolean cdEntriesZip64 = cdEntries > 65535L || ZipConstants.FORCE_ZIP64_EXT;
        boolean cdSizeZip64 = cdSize > 0xFFFFFFFFL || ZipConstants.FORCE_ZIP64_EXT;
        boolean cdOffsetZip64 = cdOffset > 0xFFFFFFFFL || ZipConstants.FORCE_ZIP64_EXT;
        int cdEntries16 = cdEntriesZip64 ? 65535 : (int)cdEntries;
        long cdSize32 = cdSizeZip64 ? 0xFFFFFFFFL : cdSize;
        long cdOffset32 = cdOffsetZip64 ? 0xFFFFFFFFL : cdOffset;
        boolean bl = zip64 = cdEntriesZip64 || cdSizeZip64 || cdOffsetZip64;
        if (zip64) {
            long zip64eocdOffset = dos.size();
            dos.writeInt(101075792);
            dos.writeLong(44L);
            dos.writeShort(63);
            dos.writeShort(45);
            dos.writeInt(0);
            dos.writeInt(0);
            dos.writeLong(cdEntries);
            dos.writeLong(cdEntries);
            dos.writeLong(cdSize);
            dos.writeLong(cdOffset);
            dos.writeInt(117853008);
            dos.writeInt(0);
            dos.writeLong(zip64eocdOffset);
            dos.writeInt(1);
        }
        dos.writeInt(101010256);
        dos.writeShort(0);
        dos.writeShort(0);
        dos.writeShort(cdEntries16);
        dos.writeShort(cdEntries16);
        dos.writeInt((int)cdSize32);
        dos.writeInt((int)cdOffset32);
        String comment = this.getComment();
        if (comment == null) {
            comment = "";
        }
        byte[] data = comment.getBytes(this.charset);
        dos.writeShort(data.length);
        dos.write(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.finish();
        }
        finally {
            this.entries.clear();
            this.delegate.close();
        }
    }

    private static class AppendingLEDataOutputStream
    extends LEDataOutputStream {
        AppendingLEDataOutputStream(OutputStream out, RawZipFile<?> appendee) {
            super(out);
            this.written = null == appendee ? 0L : appendee.getOffsetMapper().location(appendee.length());
        }
    }
}

