/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public final class ArchiveFileUtils {
    private static final String TEMP_FILENAME_PREFIX = "droid-archive~";
    private static final String SSP_DELIMITER = ":/";
    private static final String ARCHIVE_DELIMITER = "!/";
    private static final int WRITE_BUFFER_CAPACITY = 8192;

    private ArchiveFileUtils() {
    }

    public static URI toZipUri(URI parent, String zipEntry) {
        String parentScheme = parent.getScheme();
        String parentSsp = parent.getSchemeSpecificPart();
        try {
            return new URI("zip:" + parentScheme, parentSsp + ARCHIVE_DELIMITER + FilenameUtils.separatorsToUnix((String)zipEntry), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URI toTarUri(URI parent, String tarEntry) {
        String parentScheme = parent.getScheme();
        String parentSsp = parent.getSchemeSpecificPart();
        try {
            return new URI("tar:" + parentScheme, parentSsp + ARCHIVE_DELIMITER + FilenameUtils.separatorsToUnix((String)tarEntry), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static File writeEntryToTemp(File tempDir, ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        File tempFile = File.createTempFile(TEMP_FILENAME_PREFIX, null, tempDir);
        FileChannel out = new FileOutputStream(tempFile).getChannel();
        try {
            out.write(buffer);
            ByteBuffer buf = ByteBuffer.allocate(8192);
            buf.clear();
            while (channel.read(buf) >= 0 || buf.position() != 0) {
                buf.flip();
                out.write(buf);
                buf.compact();
            }
            File file = tempFile;
            return file;
        }
        catch (RuntimeException ex) {
            if (out != null) {
                out.close();
            }
            if (channel != null) {
                channel.close();
            }
            if (tempFile != null) {
                tempFile.delete();
            }
            throw ex;
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeEntryToTemp(File tempDir, byte[] buffer, InputStream in) throws IOException {
        File file;
        block10: {
            File tempFile = File.createTempFile(TEMP_FILENAME_PREFIX, null, tempDir);
            FileOutputStream out = null;
            out = new FileOutputStream(tempFile);
            byte[] buf = new byte[8192];
            try {
                out.write(buffer);
                int bytesRead = in.read(buf);
                while (bytesRead > 0) {
                    out.write(buf, 0, bytesRead);
                    bytesRead = in.read(buf);
                }
                file = tempFile;
                if (out == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                catch (RuntimeException ex) {
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                    throw ex;
                }
            }
            out.close();
        }
        return file;
    }

    public static URI toGZipUri(URI parent) {
        String parentScheme = parent.getScheme();
        String parentSsp = parent.getSchemeSpecificPart();
        try {
            return new URI("gz:" + parentScheme, parentSsp + ARCHIVE_DELIMITER + GzipUtils.getUncompressedFilename((String)FilenameUtils.getName((String)parent.getSchemeSpecificPart())), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URI toReplayUri(URI requestUri) {
        String originSsp = StringUtils.substringBetween((String)requestUri.toString(), (String)SSP_DELIMITER, (String)"!");
        String scheme = StringUtils.substringBefore((String)requestUri.toString(), (String)SSP_DELIMITER);
        if (originSsp != null) {
            return URI.create(StringUtils.substringAfterLast((String)scheme, (String)":") + SSP_DELIMITER + originSsp);
        }
        return requestUri;
    }

    public static List<String> getAncestorPaths(String path) {
        ArrayList<String> paths = new ArrayList<String>();
        if (path != null && !path.isEmpty()) {
            String processPath = path;
            int lastSeparator = processPath.length() - 1;
            while (lastSeparator >= 0) {
                String separator = path.substring(lastSeparator, lastSeparator + 1);
                processPath = processPath.substring(0, lastSeparator);
                paths.add(processPath + separator);
                lastSeparator = FilenameUtils.indexOfLastSeparator((String)processPath);
            }
        }
        return paths;
    }
}

