/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.filter.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uk.gov.nationalarchives.droid.core.interfaces.filter.expressions.Criterion;

public final class QueryBuilder
implements Criterion {
    private String alias;
    private List<Criterion> criteria = new ArrayList<Criterion>();
    private Set<String> aliases = new HashSet<String>();

    private QueryBuilder(String alias) {
        this.alias = alias;
    }

    public static QueryBuilder forAlias(String alias) {
        return new QueryBuilder(alias);
    }

    public QueryBuilder add(Criterion exp) {
        this.criteria.add(exp);
        return this;
    }

    public QueryBuilder createAlias(String newAlias) {
        this.aliases.add(newAlias);
        return this;
    }

    @Override
    public Object[] getValues() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Criterion criterion : this.criteria) {
            if (criterion == null) continue;
            params.addAll(Arrays.asList(criterion.getValues()));
        }
        return params.toArray();
    }

    @Override
    public String toEjbQl(QueryBuilder parent) {
        StringBuilder sb = new StringBuilder();
        Iterator<Criterion> it = this.criteria.iterator();
        while (it.hasNext()) {
            Criterion criterion = it.next();
            if (criterion == null) continue;
            sb.append(criterion.toEjbQl(this));
            if (!it.hasNext()) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    public String toEjbQl() {
        return this.toEjbQl(null);
    }

    String getAlias() {
        return this.alias;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }
}

