/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedBytes;

public final class CachedByteArray
implements CachedBytes {
    private File source;
    private final byte[] bytes;
    private int maxSize;

    public CachedByteArray(byte[] bytes, int maxSize) {
        this.bytes = bytes;
        this.maxSize = maxSize;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public File getSourceFile() {
        return this.source;
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        byte[] buffer = this.bytes.length > this.maxSize ? Arrays.copyOf(this.bytes, this.maxSize) : this.bytes;
        return new ByteArrayInputStream(buffer);
    }

    @Override
    public void setSourceFile(File sourceFile) throws FileNotFoundException {
        this.source = sourceFile;
    }

    public byte readByte(long position) {
        return this.bytes[(int)position];
    }
}

