/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.expression.parser;

import java.util.ArrayList;
import net.domesdaybook.expression.parser.ParseException;
import net.domesdaybook.expression.parser.regularExpressionLexer;
import net.domesdaybook.expression.parser.regularExpressionParser;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeAdaptor;

public class AstParser {
    public Tree parseToAST(String expression) throws ParseException {
        if (expression == null || expression.isEmpty()) {
            throw new IllegalArgumentException("Null or empty expression passed in to AstParser.parseToAST.");
        }
        try {
            return this.parseToAbstractSyntaxTree(expression);
        }
        catch (RecognitionException ex) {
            throw new ParseException(ex);
        }
    }

    public Tree optimiseAST(Tree treeNode) throws ParseException {
        if (treeNode == null) {
            throw new IllegalArgumentException("Null node passed in to AstParser.optimiseAST");
        }
        Tree result = treeNode;
        for (int childIndex = 0; childIndex < treeNode.getChildCount(); ++childIndex) {
            Tree resultNode;
            Tree childNode = treeNode.getChild(childIndex);
            if (this.equivalent(treeNode, childNode) && treeNode.getType() != 6) {
                treeNode.replaceChildren(childIndex, childIndex, (Object)this.getChildList(childNode));
                childNode = treeNode.getChild(childIndex);
            }
            if ((resultNode = this.optimiseAST(childNode)) == childNode) continue;
            treeNode.setChild(childIndex, resultNode);
        }
        if (treeNode.getType() == 13) {
            result = this.optimiseSingleByteAlternatives(treeNode);
        }
        return result;
    }

    private CommonTree parseToAbstractSyntaxTree(String expression) throws ParseException, RecognitionException {
        CommonTree tree;
        ANTLRStringStream input = new ANTLRStringStream(expression);
        regularExpressionLexer lexer = new regularExpressionLexer((CharStream)input);
        if (lexer.getNumberOfSyntaxErrors() == 0) {
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            regularExpressionParser parser = new regularExpressionParser((TokenStream)tokens){

                public void emitErrorMessage(String msg) {
                    throw new ParseErrorException(msg);
                }
            };
            try {
                CommonTreeAdaptor adaptor = new CommonTreeAdaptor();
                parser.setTreeAdaptor((TreeAdaptor)adaptor);
                regularExpressionParser.start_return ret = parser.start();
                tree = (CommonTree)ret.getTree();
            }
            catch (ParseErrorException e) {
                throw new ParseException(e.getMessage());
            }
        } else {
            throw new ParseException(String.format("Parse error: %d syntax errors in %s", lexer.getNumberOfSyntaxErrors(), expression));
        }
        return tree;
    }

    private Tree optimiseSingleByteAlternatives(Tree treeNode) {
        Tree result = treeNode;
        ArrayList<Integer> childrenToMerge = new ArrayList<Integer>();
        int childCount = treeNode.getChildCount();
        for (int childIndex = childCount - 1; childIndex >= 0; --childIndex) {
            if (!this.isSingleByteNode(treeNode.getChild(childIndex))) continue;
            childrenToMerge.add(childIndex);
        }
        if (childrenToMerge.size() > 1) {
            CommonTree mergeSet = this.createNode(7);
            for (int mergeIndex = 0; mergeIndex < childrenToMerge.size(); ++mergeIndex) {
                int childIndex = (Integer)childrenToMerge.get(mergeIndex);
                Tree mergeNode = treeNode.getChild(childIndex);
                if (mergeNode.getType() == 7) {
                    mergeNode = this.getChildList(mergeNode);
                }
                mergeSet.addChild(mergeNode);
                treeNode.deleteChild(childIndex);
            }
            if (childrenToMerge.size() == childCount) {
                result = mergeSet;
            } else {
                treeNode.addChild((Tree)mergeSet);
            }
        }
        return result;
    }

    private CommonTree createNode(int type) {
        String text = regularExpressionParser.tokenNames[type];
        return new CommonTree((Token)new CommonToken(type, text));
    }

    private boolean equivalent(Tree node1, Tree node2) {
        return node1.getType() == node2.getType() && node1.getText().equals(node2.getText());
    }

    private Tree getChildList(Tree parent) {
        CommonTree listNode = new CommonTree();
        for (int childIndex = 0; childIndex < parent.getChildCount(); ++childIndex) {
            listNode.addChild(parent.getChild(childIndex));
        }
        return listNode;
    }

    private boolean isSingleByteNode(Tree node) {
        int nodeType = node.getType();
        return nodeType == 14 || nodeType == 7 || nodeType == 10 || nodeType == 11 || (nodeType == 20 || nodeType == 53) && node.getText().length() == 1;
    }

    private class ParseErrorException
    extends RuntimeException {
        public ParseErrorException(String message) {
            super(message);
        }
    }
}

