/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.functions.postscript.Lexer;
import org.icepdf.core.util.Utils;

public class Function_4
extends Function {
    private static final Logger logger = Logger.getLogger(Function_4.class.toString());
    private String functionContent;
    private Hashtable<String, float[]> resultCache;

    public Function_4(Dictionary d) {
        super(d);
        if (d instanceof Stream) {
            Stream functionStream = (Stream)d;
            InputStream input = functionStream.getInputStreamForDecodedStreamBytes();
            if (input instanceof SeekableInput) {
                this.functionContent = Utils.getContentFromSeekableInput((SeekableInput)((Object)input), false);
            } else {
                InputStream[] inArray = new InputStream[]{input};
                this.functionContent = Utils.getContentAndReplaceInputStream(inArray, false);
            }
            logger.finest("Function 4: " + this.functionContent);
        } else {
            logger.warning("Type 4 function operands could not be found.");
        }
        this.resultCache = new Hashtable();
    }

    public float[] calculate(float[] x) {
        String colourKey = this.calculateColourKey(x);
        if (this.resultCache.containsKey(colourKey)) {
            return this.resultCache.get(colourKey);
        }
        ByteArrayInputStream content = new ByteArrayInputStream(this.functionContent.getBytes());
        Lexer lex = new Lexer();
        lex.setInputStream(content);
        try {
            lex.parse(x);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error Processing Type 4 definition", e);
        }
        Stack stack = lex.getStack();
        int n = this.range.length / 2;
        float[] y = new float[n];
        for (int i = 0; i < n; ++i) {
            y[i] = Math.min(Math.max(((Float)stack.elementAt(i)).floatValue(), this.range[2 * i]), this.range[2 * i + 1]);
        }
        this.resultCache.put(colourKey, y);
        return y;
    }

    private String calculateColourKey(float[] colours) {
        StringBuilder builder = new StringBuilder();
        for (float colour : colours) {
            builder.append(colour);
        }
        return builder.toString();
    }
}

