/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import uk.gov.nationalarchives.droid.command.ResultPrinter;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.interfaces.resource.TarEntryIdentificationRequest;

public class TarArchiveContentIdentifier {
    private BinarySignatureIdentifier binarySignatureIdentifier;
    private ContainerSignatureDefinitions containerSignatureDefinitions;
    private String path;
    private String slash;
    private String slash1;
    private File tmpDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TarArchiveContentIdentifier(BinarySignatureIdentifier binarySignatureIdentifier, ContainerSignatureDefinitions containerSignatureDefinitions, String path, String slash, String slash1) {
        TarArchiveContentIdentifier tarArchiveContentIdentifier = this;
        synchronized (tarArchiveContentIdentifier) {
            this.binarySignatureIdentifier = binarySignatureIdentifier;
            this.containerSignatureDefinitions = containerSignatureDefinitions;
            this.path = path;
            this.slash = slash;
            this.slash1 = slash1;
            if (this.tmpDir == null) {
                this.tmpDir = new File(System.getProperty("java.io.tmpdir"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void identify(URI uri, IdentificationRequest request) throws CommandExecutionException {
        String newPath = "tar:" + this.slash1 + this.path + request.getFileName() + "!" + this.slash;
        this.slash1 = "";
        InputStream tarIn = null;
        try {
            tarIn = request.getSourceInputStream();
            TarArchiveInputStream in = new TarArchiveInputStream(tarIn);
            try {
                TarArchiveEntry entry = null;
                while ((entry = in.getNextTarEntry()) != null) {
                    String name = entry.getName();
                    if (entry.isDirectory()) continue;
                    RequestMetaData metaData = new RequestMetaData(1L, 2L, name);
                    RequestIdentifier identifier = new RequestIdentifier(uri);
                    TarEntryIdentificationRequest tarRequest = new TarEntryIdentificationRequest(metaData, identifier, this.tmpDir);
                    tarRequest.open((InputStream)in);
                    IdentificationResultCollection tarResults = this.binarySignatureIdentifier.matchBinarySignatures(tarRequest);
                    ResultPrinter resultPrinter = new ResultPrinter(this.binarySignatureIdentifier, this.containerSignatureDefinitions, newPath, this.slash, this.slash1, true);
                    resultPrinter.print(tarResults, tarRequest);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe + " (" + newPath + ")");
        }
        finally {
            if (tarIn != null) {
                try {
                    tarIn.close();
                }
                catch (IOException ioe) {
                    throw new CommandExecutionException(ioe.getMessage(), ioe);
                }
            }
        }
    }
}

