/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.singlebyte;

import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public final class CaseInsensitiveByteMatcher
implements SingleByteMatcher {
    private static final String ILLEGAL_ARGUMENTS = "Non-ASCII char passed in to CaseInsensitiveByteMatcher: %s";
    private final Character value;
    private final byte[] caseValues;

    public CaseInsensitiveByteMatcher(Character asciiChar) {
        long val = asciiChar.charValue();
        if (val > 127L || val < 0L) {
            String message = String.format(ILLEGAL_ARGUMENTS, asciiChar);
            throw new IllegalArgumentException(message);
        }
        this.value = asciiChar;
        this.caseValues = new byte[2];
        this.caseValues[0] = (byte)Character.toLowerCase(asciiChar.charValue());
        this.caseValues[1] = (byte)Character.toUpperCase(asciiChar.charValue());
    }

    @Override
    public final boolean matches(ByteReader reader, long matchPosition) {
        return this.matches(reader.readByte(matchPosition));
    }

    @Override
    public final boolean matches(byte theByte) {
        return theByte == this.caseValues[0] || theByte == this.caseValues[1];
    }

    @Override
    public final byte[] getMatchingBytes() {
        byte firstByte = this.caseValues[0];
        byte secondByte = this.caseValues[1];
        if (firstByte == secondByte) {
            byte[] singleValue = new byte[]{firstByte};
            return singleValue;
        }
        return this.caseValues;
    }

    @Override
    public final String toRegularExpression(boolean prettyPrint) {
        return prettyPrint ? " `" + this.value.toString() + "` " : '`' + this.value.toString() + '`';
    }

    @Override
    public final int getNumberOfMatchingBytes() {
        return this.caseValues[0] == this.caseValues[1] ? 1 : 2;
    }
}

