/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.reader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.domesdaybook.reader.ByteReader;
import net.domesdaybook.reader.ReadByteException;

public final class RandomAccessFileReader
implements ByteReader {
    private static final String READ_ONLY = "r";
    private static final String ILLEGAL_ARGUMENTS = "Null file passed to RandomAccessFileReader";
    private final RandomAccessFile file;

    public RandomAccessFileReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENTS);
        }
        this.file = new RandomAccessFile(file, READ_ONLY);
    }

    @Override
    public byte readByte(long position) {
        try {
            this.file.seek(position);
            return this.file.readByte();
        }
        catch (IOException ex) {
            throw new ReadByteException(ex);
        }
    }
}

