/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.JpegModule;
import edu.harvard.hul.ois.jhove.module.jpeg.Spiff;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class SpiffDir {
    private JpegModule _module;
    private List _thumbnails;

    public SpiffDir(JpegModule jpegModule) {
        this._module = jpegModule;
        this._thumbnails = new LinkedList();
    }

    public void readDirEntry(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = (int)this._module.readUnsignedInt(dataInputStream);
        switch (n2) {
            case 4: {
                this.readThumbnail(dataInputStream, n);
                break;
            }
            default: {
                this._module.skipBytes(dataInputStream, n - 6, this._module);
            }
        }
    }

    public void appendThumbnailProps(List list) {
        list.addAll(this._thumbnails);
    }

    private void readThumbnail(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        NisoImageMetadata nisoImageMetadata = new NisoImageMetadata();
        this._module.skipBytes(dataInputStream, 4, this._module);
        int n3 = this._module.readUnsignedShort(dataInputStream);
        int n4 = this._module.readUnsignedShort(dataInputStream);
        int n5 = ModuleBase.readUnsignedByte((DataInputStream)dataInputStream, (ModuleBase)this._module);
        int n6 = ModuleBase.readUnsignedByte((DataInputStream)dataInputStream, (ModuleBase)this._module);
        int n7 = ModuleBase.readUnsignedByte((DataInputStream)dataInputStream, (ModuleBase)this._module);
        this._module.skipBytes(dataInputStream, n - 13, this._module);
        nisoImageMetadata.setMimeType("image/jpeg");
        nisoImageMetadata.setByteOrder("big-endian");
        nisoImageMetadata.setBitsPerSample(new int[]{n6});
        int n8 = Spiff.colorSpaceToNiso(n5);
        if (n8 >= 0) {
            nisoImageMetadata.setColorSpace(n8);
        }
        if ((n2 = Spiff.compressionTypeToNiso(n7)) >= 0) {
            nisoImageMetadata.setCompressionScheme(n2);
        }
        Property property = new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, (Object)nisoImageMetadata);
        LinkedList<Property> linkedList = new LinkedList<Property>();
        linkedList.add(property);
        Property property2 = new Property("ThumbImage", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
        this._thumbnails.add(property2);
    }
}

