/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.ListIterator;

public class FragmentInputStream
extends InputStream {
    private List _fragments;
    private RandomAccessFile _raf;
    private ListIterator fragIterator;
    private long[] curFragment;
    byte[] fragBuffer;
    private int bufOffset;
    private int fragOffset;
    private int _bufSize;
    private int bufBytes;

    public FragmentInputStream(List list, RandomAccessFile randomAccessFile) {
        this._fragments = list;
        this._raf = randomAccessFile;
        this.init(-1);
    }

    public FragmentInputStream(List list, RandomAccessFile randomAccessFile, int n) {
        this._fragments = list;
        this._raf = randomAccessFile;
        this.init(n);
    }

    private void init(int n) {
        this.fragIterator = this._fragments.listIterator();
        if (n <= 0) {
            n = 8192;
        }
        this._bufSize = n;
        this.fragBuffer = new byte[n];
        this.bufOffset = 0;
        this.bufBytes = 0;
    }

    public int read() throws IOException {
        if (this.bufOffset >= this.bufBytes) {
            if (this.curFragment == null || (long)this.fragOffset >= this.curFragment[1]) {
                if (this.fragIterator.hasNext()) {
                    this.curFragment = (long[])this.fragIterator.next();
                    this.fragOffset = 0;
                } else {
                    return -1;
                }
            }
            this._raf.seek(this.curFragment[0] + (long)this.fragOffset);
            this.bufBytes = this._raf.read(this.fragBuffer);
            this.fragOffset += this.bufBytes;
            this.bufOffset = 0;
        }
        return this.fragBuffer[this.bufOffset++];
    }
}

