/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.DataInputStream;
import java.io.IOException;

public class POCMarkerSegment
extends MarkerSegment {
    protected boolean process(int n) throws IOException {
        int n2;
        int n3 = this.nCompBytes();
        if (n3 == 0) {
            this._repInfo.setMessage((Message)new ErrorMessage("POC marker segment at wrong position in codestream"));
            return false;
        }
        int n4 = n3 < 257 ? 7 : 9;
        if (n4 * (n2 = n / n4) != n) {
            this._repInfo.setMessage((Message)new ErrorMessage("Invalid size for POC marker segment"));
            return false;
        }
        Property[] propertyArray = new Property[n2];
        for (int i = 0; i < n2; ++i) {
            int n5 = this._module.readUnsignedShort(this._dstream);
            int n6 = n3 < 257 ? ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module) : this._module.readUnsignedShort(this._dstream);
            int n7 = this._module.readUnsignedShort(this._dstream);
            int n8 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
            int n9 = n3 < 257 ? ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module) : this._module.readUnsignedShort(this._dstream);
            int n10 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
            Property[] propertyArray2 = new Property[]{new Property("StartResolutionLevelIndex", PropertyType.INTEGER, (Object)new Integer(n5)), new Property("ComponentIndex", PropertyType.INTEGER, (Object)new Integer(n6)), new Property("LayerIndex", PropertyType.INTEGER, (Object)new Integer(n7)), new Property("EndResolutionLevelIndex", PropertyType.INTEGER, (Object)new Integer(n9)), new Property("ProgressionOrder", PropertyType.INTEGER, (Object)new Integer(n10))};
            propertyArray[i] = new Property("Change", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray2);
        }
        MainOrTile mainOrTile = this.getMainOrTile();
        mainOrTile.setPOCProperty(new Property("ProgressionOrderChange", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray));
        return true;
    }
}

