/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileDLF;

public final class TiffProfileDLFColor
extends TiffProfileDLF {
    public TiffProfileDLFColor() {
        this._profileText = "DLF Benchmark for Faithful Digital Reproductions of Monographs and Serials: color";
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (!this.satisfiesCompression(tiffIFD, new int[]{1, 5, 32773})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, new int[]{2, 6})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, new int[]{3})) {
            return false;
        }
        int[] nArray = tiffIFD.getNisoImageMetadata().getBitsPerSample();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 8) continue;
            return false;
        }
        return this.hasMinimumResolution(tiffIFD, 300.0, 760.0);
    }
}

