/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffFXBase;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;

public class TiffProfileFXC
extends TiffFXBase {
    public TiffProfileFXC() {
        this._profileText = "TIFF-FX (Profile C)";
        this._mimeClass = 1;
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        int n;
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (!this.satisfiesClass(tiffIFD)) {
            return false;
        }
        if (!this.satisfiesImageWidth(tiffIFD, new int[]{864, 1024, 1216, 1728, 2048, 2432, 2592, 3072, 3456, 3648, 4096, 4864})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, new int[]{1, 3})) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, 7)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, 10)) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3, -1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, new int[]{1, 3})) {
            return false;
        }
        if (!this.satisfiesXResolution(tiffIFD, new int[]{100, 200, 300, 400})) {
            return false;
        }
        if (!this.satisfiesFillOrder(tiffIFD, new int[]{1, 2})) {
            return false;
        }
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        long l = nisoImageMetadata.getXSamplingFrequency().toLong();
        if (l != nisoImageMetadata.getYSamplingFrequency().toLong()) {
            return false;
        }
        if (nisoImageMetadata.getSamplingFrequencyUnit() == 3) {
            l = this.perCMtoPerInch((int)l);
        }
        if ((n = nisoImageMetadata.getBitsPerSample()[0]) != 8 && n != 12) {
            return false;
        }
        int n2 = (int)nisoImageMetadata.getImageWidth();
        switch ((int)l) {
            case 100: {
                if (n2 == 864 || !(n2 != 1024 & n2 != 1216)) break;
                return false;
            }
            case 200: {
                if (n2 == 1728 || !(n2 != 2048 & n2 != 2432)) break;
                return false;
            }
            case 300: {
                if (n2 == 2592 || !(n2 != 3072 & n2 != 3648)) break;
                return false;
            }
            case 400: {
                if (n2 == 3456 || !(n2 != 4096 & n2 != 4864)) break;
                return false;
            }
        }
        return tiffIFD.getIndexed() != 1 || nisoImageMetadata.getColormapRedValue() != null;
    }
}

