/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.bridges.java_remote;

import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XInstanceProvider;
import com.sun.star.connection.XConnection;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lib.uno.bridges.java_remote.ProxyFactory;
import com.sun.star.lib.uno.bridges.java_remote.RequestHandler;
import com.sun.star.lib.uno.bridges.java_remote.XConnectionInputStream_Adapter;
import com.sun.star.lib.uno.bridges.java_remote.XConnectionOutputStream_Adapter;
import com.sun.star.lib.uno.environments.java.java_environment;
import com.sun.star.lib.uno.environments.remote.IProtocol;
import com.sun.star.lib.uno.environments.remote.IReceiver;
import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.Message;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.environments.remote.ThreadPoolManager;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.lib.util.DisposeListener;
import com.sun.star.lib.util.DisposeNotifier;
import com.sun.star.uno.Any;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XCurrentContext;
import com.sun.star.uno.XInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class java_remote_bridge
implements IBridge,
IReceiver,
RequestHandler,
XBridge,
XComponent,
DisposeNotifier {
    private static final boolean DEBUG = false;
    protected XConnection _xConnection;
    protected XInstanceProvider _xInstanceProvider;
    protected String _name = "remote";
    private final String protocol;
    protected IProtocol _iProtocol;
    protected IEnvironment _java_environment;
    protected MessageDispatcher _messageDispatcher;
    protected int _life_count = 0;
    private final Vector _listeners = new Vector();
    protected IThreadPool _iThreadPool;
    private boolean disposed = false;
    private final HashMap refHolders = new HashMap();
    private final ProxyFactory proxyFactory;
    private final ArrayList disposeListeners = new ArrayList();

    int getLifeCount() {
        return this._life_count;
    }

    IProtocol getProtocol() {
        return this._iProtocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasRefHolder(String string, Type type) {
        HashMap hashMap = this.refHolders;
        synchronized (hashMap) {
            LinkedList linkedList = (LinkedList)this.refHolders.get(string);
            if (linkedList != null) {
                for (RefHolder refHolder : linkedList) {
                    if (!type.isSupertypeOf(refHolder.getType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addRefHolder(Object object, Type type, String string) {
        HashMap hashMap = this.refHolders;
        synchronized (hashMap) {
            LinkedList<RefHolder> linkedList = (LinkedList<RefHolder>)this.refHolders.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<RefHolder>();
                this.refHolders.put(string, linkedList);
            }
            boolean bl = false;
            Iterator iterator = linkedList.iterator();
            while (!bl && iterator.hasNext()) {
                RefHolder refHolder = (RefHolder)iterator.next();
                if (!refHolder.getType().equals((Object)type)) continue;
                bl = true;
                refHolder.acquire();
            }
            if (!bl) {
                linkedList.add(new RefHolder(type, object));
            }
        }
        this.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remRefHolder(Type type, String string) {
        HashMap hashMap = this.refHolders;
        synchronized (hashMap) {
            LinkedList linkedList = (LinkedList)this.refHolders.get(string);
            if (linkedList != null) {
                for (RefHolder refHolder : linkedList) {
                    if (!refHolder.getType().equals((Object)type)) continue;
                    try {
                        if (!refHolder.release()) break;
                        linkedList.remove(refHolder);
                        if (!linkedList.isEmpty()) break;
                        this.refHolders.remove(string);
                        break;
                    }
                    finally {
                        this.release();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void freeHolders() {
        HashMap hashMap = this.refHolders;
        synchronized (hashMap) {
            for (Map.Entry entry : this.refHolders.entrySet()) {
                String string = (String)entry.getKey();
                LinkedList linkedList = (LinkedList)entry.getValue();
                for (RefHolder refHolder : linkedList) {
                    boolean bl = false;
                    while (!bl) {
                        bl = refHolder.release();
                        this._java_environment.revokeInterface(string, refHolder.getType());
                        this.release();
                    }
                }
            }
            this.refHolders.clear();
        }
    }

    public java_remote_bridge(IEnvironment iEnvironment, IEnvironment iEnvironment2, Object[] objectArray) throws Exception {
        String string;
        int n;
        this._java_environment = iEnvironment;
        String string2 = (String)objectArray[0];
        this._xConnection = (XConnection)objectArray[1];
        this._xInstanceProvider = (XInstanceProvider)objectArray[2];
        if (objectArray.length > 3) {
            this._name = (String)objectArray[3];
        }
        if ((n = string2.indexOf(44)) >= 0) {
            this.protocol = string2.substring(0, n);
            string = string2.substring(n + 1);
        } else {
            this.protocol = string2;
            string = null;
        }
        this._iProtocol = (IProtocol)Class.forName("com.sun.star.lib.uno.protocols." + this.protocol + "." + this.protocol).getConstructor(IBridge.class, String.class, InputStream.class, OutputStream.class).newInstance(this, string, new XConnectionInputStream_Adapter(this._xConnection), new XConnectionOutputStream_Adapter(this._xConnection));
        this.proxyFactory = new ProxyFactory(this, this);
        this._iThreadPool = ThreadPoolManager.create();
        this._messageDispatcher = new MessageDispatcher();
        this._messageDispatcher.start();
        this._iProtocol.init();
    }

    private void notifyListeners() {
        EventObject eventObject = new EventObject((Object)this);
        Enumeration enumeration = this._listeners.elements();
        while (enumeration.hasMoreElements()) {
            XEventListener xEventListener = (XEventListener)enumeration.nextElement();
            try {
                xEventListener.disposing(eventObject);
            }
            catch (com.sun.star.uno.RuntimeException runtimeException) {}
        }
    }

    public java_remote_bridge(Object[] objectArray) throws Exception {
        this(UnoRuntime.getEnvironment((String)"java", null), UnoRuntime.getEnvironment((String)"remote", null), objectArray);
    }

    public Object mapInterfaceTo(Object object, Type type) {
        this.checkDisposed();
        if (object == null) {
            return null;
        }
        String[] stringArray = new String[1];
        if (!this.proxyFactory.isProxy(object = this._java_environment.registerInterface(object, stringArray, type))) {
            this.addRefHolder(object, type, stringArray[0]);
        }
        return stringArray[0];
    }

    public Object mapInterfaceFrom(Object object, Type type) {
        this.checkDisposed();
        this.acquire();
        String string = (String)object;
        Object object2 = this._java_environment.getRegisteredInterface(string, type);
        if (object2 == null) {
            object2 = this._java_environment.registerInterface(this.proxyFactory.create(string, type), new String[]{string}, type);
        } else if (!this.hasRefHolder(string, type)) {
            this.sendInternalRequest(string, type, "release", null);
        }
        return object2;
    }

    public IEnvironment getSourceEnvironment() {
        return this._java_environment;
    }

    public IEnvironment getTargetEnvironment() {
        return null;
    }

    public synchronized void acquire() {
        ++this._life_count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        boolean bl;
        java_remote_bridge java_remote_bridge2 = this;
        synchronized (java_remote_bridge2) {
            --this._life_count;
            bl = this._life_count <= 0;
        }
        if (bl) {
            this.dispose(new com.sun.star.uno.RuntimeException("end of life"));
        }
    }

    public void dispose() {
        this.dispose(new com.sun.star.uno.RuntimeException("user dispose"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(Throwable throwable) {
        Object object = this;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
        }
        this.notifyListeners();
        object = this.disposeListeners.iterator();
        while (object.hasNext()) {
            ((DisposeListener)object.next()).notifyDispose((DisposeNotifier)this);
        }
        try {
            this._messageDispatcher.terminate();
            this._xConnection.close();
            if (Thread.currentThread() != this._messageDispatcher && this._messageDispatcher.isAlive()) {
                if (System.getProperty("os.name", "").toLowerCase().equals("linux") && System.getProperty("java.version", "").startsWith("1.3.") && (System.getProperty("java.vendor", "").toLowerCase().indexOf("sun") != -1 || System.getProperty("java.vendor", "").toLowerCase().indexOf("blackdown") != -1)) {
                    this._messageDispatcher.suspend();
                    this._messageDispatcher.resume();
                }
                this._messageDispatcher.join(1000L);
                if (this._messageDispatcher.isAlive()) {
                    this._messageDispatcher.interrupt();
                    this._messageDispatcher.join();
                }
            }
            this._iThreadPool.dispose(throwable);
            this.freeHolders();
            ((java_environment)this._java_environment).revokeAllProxies();
            this._xConnection = null;
            this._java_environment = null;
            this._messageDispatcher = null;
        }
        catch (InterruptedException interruptedException) {
            System.err.println(this.getClass().getName() + ".dispose - InterruptedException:" + interruptedException);
        }
        catch (com.sun.star.io.IOException iOException) {
            System.err.println(this.getClass().getName() + ".dispose - IOException:" + (Object)((Object)iOException));
        }
    }

    public Object getInstance(String string) {
        Type type = new Type(XInterface.class);
        return this.sendInternalRequest(string, type, "queryInterface", new Object[]{type});
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this.protocol + "," + this._xConnection.getDescription();
    }

    public void sendReply(boolean bl, ThreadId threadId, Object object) {
        this.checkDisposed();
        try {
            this._iProtocol.writeReply(bl, threadId, object);
        }
        catch (IOException iOException) {
            this.dispose(iOException);
            throw new DisposedException("unexpected " + iOException);
        }
        catch (RuntimeException runtimeException) {
            this.dispose(runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            this.dispose(error);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendRequest(String string, Type type, String string2, Object[] objectArray) throws Throwable {
        Object object = null;
        this.checkDisposed();
        boolean bl = false;
        ThreadId threadId = this._iThreadPool.getThreadId();
        Object object2 = this._iThreadPool.attach(threadId);
        try {
            boolean bl2;
            try {
                bl2 = this._iProtocol.writeRequest(string, TypeDescription.getTypeDescription((Type)type), string2, threadId, objectArray);
            }
            catch (IOException iOException) {
                DisposedException disposedException = new DisposedException(iOException.toString());
                this.dispose((Throwable)disposedException);
                throw disposedException;
            }
            if (bl2 && Thread.currentThread() != this._messageDispatcher) {
                object = this._iThreadPool.enter(object2, threadId);
            }
        }
        finally {
            this._iThreadPool.detach(object2, threadId);
            if (string2.equals("release")) {
                this.release();
            }
        }
        if (string2.equals("queryInterface") && object instanceof Any) {
            Any any = (Any)object;
            object = any.getType().getTypeClass() == TypeClass.INTERFACE ? any.getObject() : null;
        }
        return object;
    }

    private Object sendInternalRequest(String string, Type type, String string2, Object[] objectArray) {
        try {
            return this.sendRequest(string, type, string2, objectArray);
        }
        catch (Error error) {
            throw error;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unexpected " + throwable);
        }
    }

    public void addEventListener(XEventListener xEventListener) {
        this._listeners.addElement(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) {
        this._listeners.removeElement(xEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisposeListener(DisposeListener disposeListener) {
        java_remote_bridge java_remote_bridge2 = this;
        synchronized (java_remote_bridge2) {
            if (!this.disposed) {
                this.disposeListeners.add(disposeListener);
                return;
            }
        }
        disposeListener.notifyDispose((DisposeNotifier)this);
    }

    private synchronized void checkDisposed() {
        if (this.disposed) {
            throw new DisposedException("java_remote_bridge " + this + " is disposed");
        }
    }

    private static final class RefHolder {
        private final Type type;
        private final Object object;
        private int count = 1;

        public RefHolder(Type type, Object object) {
            this.type = type;
            this.object = object;
        }

        public Type getType() {
            return this.type;
        }

        public void acquire() {
            ++this.count;
        }

        public boolean release() {
            return --this.count == 0;
        }
    }

    private final class MessageDispatcher
    extends Thread {
        private boolean terminate;

        public MessageDispatcher() {
            super("MessageDispatcher");
            this.terminate = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    Object object = this;
                    synchronized (object) {
                        if (this.terminate) {
                            break;
                        }
                    }
                    object = java_remote_bridge.this._iProtocol.readMessage();
                    Object object2 = null;
                    if (((Message)object).isRequest()) {
                        String string = ((Message)object).getObjectId();
                        Type type = new Type(((Message)object).getType());
                        int n = ((Message)object).getMethod().getIndex();
                        if (n == 2) {
                            java_remote_bridge.this._java_environment.revokeInterface(string, type);
                            java_remote_bridge.this.remRefHolder(type, string);
                            if (!((Message)object).isSynchronous()) continue;
                            java_remote_bridge.this.sendReply(false, ((Message)object).getThreadId(), null);
                            continue;
                        }
                        object2 = java_remote_bridge.this._java_environment.getRegisteredInterface(string, type);
                        if (object2 == null && n == 0) {
                            if (java_remote_bridge.this._xInstanceProvider == null) {
                                java_remote_bridge.this.sendReply(true, ((Message)object).getThreadId(), (Object)new com.sun.star.uno.RuntimeException("unknown OID " + string));
                                continue;
                            }
                            UnoRuntime.setCurrentContext((XCurrentContext)((Message)object).getCurrentContext());
                            try {
                                object2 = java_remote_bridge.this._xInstanceProvider.getInstance(string);
                            }
                            catch (com.sun.star.uno.RuntimeException runtimeException) {
                                java_remote_bridge.this.sendReply(true, ((Message)object).getThreadId(), (Object)runtimeException);
                                continue;
                            }
                            catch (Exception exception) {
                                java_remote_bridge.this.sendReply(true, ((Message)object).getThreadId(), (Object)new com.sun.star.uno.RuntimeException(exception.toString()));
                                continue;
                            }
                            finally {
                                UnoRuntime.setCurrentContext(null);
                                continue;
                            }
                        }
                    }
                    java_remote_bridge.this._iThreadPool.putJob(new Job(object2, java_remote_bridge.this, (Message)object));
                }
            }
            catch (Throwable throwable) {
                java_remote_bridge.this.dispose((Throwable)new DisposedException(throwable.toString()));
            }
        }

        public synchronized void terminate() {
            this.terminate = true;
        }
    }
}

