/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TBIO;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFilteringManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import net.jcip.annotations.Immutable;

@DefaultAnnotation(value={NonNull.class})
@Immutable
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class TFile
extends File {
    private static final long serialVersionUID = 3617072259051821745L;
    private static final String UNC_PREFIX = separator + separator;
    private static final Set<File> ROOTS = Collections.unmodifiableSet(new TreeSet<File>(Arrays.asList(TFile.listRoots())));
    static final FsManager manager = FsManagerLocator.SINGLETON.get();
    private transient File delegate;
    private transient TArchiveDetector detector;
    @Nullable
    private transient TFile innerArchive;
    @Nullable
    private transient TFile enclArchive;
    @Nullable
    private transient FsEntryName enclEntryName;
    @Nullable
    private volatile transient FsController<?> controller;

    public TFile(File file) {
        this(file, (TArchiveDetector)null);
    }

    public TFile(File file, @CheckForNull TArchiveDetector detector) {
        super(file.getPath());
        if (file instanceof TFile) {
            TFile tfile = (TFile)file;
            this.delegate = tfile.delegate;
            this.detector = tfile.detector;
            this.enclArchive = tfile.enclArchive;
            this.enclEntryName = tfile.enclEntryName;
            this.innerArchive = tfile.isArchive() ? this : tfile.innerArchive;
            this.controller = tfile.controller;
        } else {
            this.delegate = file;
            this.detector = null != detector ? detector : TConfig.get().getArchiveDetector();
            this.scan(null);
        }
        assert (this.invariants());
    }

    public TFile(String path) {
        this(path, (TArchiveDetector)null);
    }

    public TFile(String path, @CheckForNull TArchiveDetector detector) {
        super(path);
        this.delegate = new File(path);
        this.detector = null != detector ? detector : TConfig.get().getArchiveDetector();
        this.scan(null);
        assert (this.invariants());
    }

    public TFile(@CheckForNull String parent, String member) {
        this(parent, member, null);
    }

    public TFile(@CheckForNull String parent, String member, @CheckForNull TArchiveDetector detector) {
        super(parent, member);
        this.delegate = new File(parent, member);
        this.detector = null != detector ? detector : TConfig.get().getArchiveDetector();
        this.scan(null);
        assert (this.invariants());
    }

    public TFile(@CheckForNull File parent, String member) {
        this(parent, member, null);
    }

    public TFile(@CheckForNull File parent, String member, @CheckForNull TArchiveDetector detector) {
        super(parent, member);
        this.delegate = new File(parent, member);
        if (parent instanceof TFile) {
            TFile p = (TFile)parent;
            this.detector = null != detector ? detector : p.detector;
            this.scan(p);
        } else {
            this.detector = null != detector ? detector : TConfig.get().getArchiveDetector();
            this.scan(null);
        }
        assert (this.invariants());
    }

    public TFile(URI uri) {
        this(FsPath.create((URI)uri, (FsUriModifier)FsUriModifier.CANONICALIZE), TConfig.get().getArchiveDetector());
    }

    public TFile(FsPath path) {
        this(path, TConfig.get().getArchiveDetector());
    }

    private TFile(FsPath path, TArchiveDetector detector) {
        super(path.toHierarchicalUri());
        this.parse(path, detector);
    }

    private void parse(FsPath path, TArchiveDetector detector) {
        this.delegate = new File(super.getPath());
        this.detector = detector;
        FsMountPoint mp = path.getMountPoint();
        FsPath mpp = mp.getPath();
        if (null == mpp) {
            assert (!path.toUri().isOpaque());
            this.enclArchive = null;
            this.enclEntryName = null;
            this.innerArchive = null;
        } else {
            FsEntryName en = path.getEntryName();
            if (en.isRoot()) {
                assert (path.toUri().isOpaque());
                if (mpp.toUri().isOpaque()) {
                    this.enclArchive = new TFile(mpp.getMountPoint(), detector);
                    this.enclEntryName = mpp.getEntryName();
                } else {
                    this.enclArchive = null;
                    this.enclEntryName = null;
                }
                this.innerArchive = this;
            } else {
                assert (path.toUri().isOpaque());
                this.enclArchive = new TFile(mp, detector);
                this.enclEntryName = en;
                this.innerArchive = this.enclArchive;
            }
        }
        assert (this.invariants());
    }

    private TFile(FsMountPoint mountPoint, TArchiveDetector detector) {
        super(mountPoint.toHierarchicalUri());
        this.delegate = new File(super.getPath());
        this.detector = detector;
        FsPath mountPointPath = mountPoint.getPath();
        if (null == mountPointPath) {
            assert (!mountPoint.toUri().isOpaque());
            this.enclArchive = null;
            this.enclEntryName = null;
            this.innerArchive = null;
        } else {
            assert (mountPoint.toUri().isOpaque());
            if (mountPointPath.toUri().isOpaque()) {
                this.enclArchive = new TFile(mountPointPath.getMountPoint(), detector);
                this.enclEntryName = mountPointPath.getEntryName();
            } else {
                this.enclArchive = null;
                this.enclEntryName = null;
            }
            this.innerArchive = this;
        }
        assert (this.invariants());
    }

    private TFile(File delegate, @CheckForNull TFile innerArchive, TArchiveDetector detector) {
        super(delegate.getPath());
        this.delegate = delegate;
        String path = delegate.getPath();
        if (null != innerArchive) {
            int iapl = innerArchive.getPath().length();
            if (path.length() == iapl) {
                this.detector = innerArchive.detector;
                this.innerArchive = this;
                this.enclArchive = innerArchive.enclArchive;
                this.enclEntryName = innerArchive.enclEntryName;
            } else {
                this.detector = detector;
                this.innerArchive = this.enclArchive = innerArchive;
                try {
                    this.enclEntryName = new FsEntryName(new UriBuilder().path(path.substring(iapl + 1).replace(separatorChar, '/')).getUri(), FsUriModifier.CANONICALIZE);
                }
                catch (URISyntaxException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
        } else {
            this.detector = detector;
        }
        assert (this.invariants());
    }

    private void scan(@CheckForNull TFile ancestor) {
        String path = super.getPath();
        assert (ancestor == null || path.startsWith(ancestor.getPath()));
        assert (this.delegate.getPath().equals(path));
        assert (null != this.detector);
        StringBuilder enclEntryNameBuf = new StringBuilder(path.length());
        this.scan(ancestor, this.detector, 0, path, enclEntryNameBuf, new Paths.Splitter(separatorChar, false));
        try {
            this.enclEntryName = 0 >= enclEntryNameBuf.length() ? null : new FsEntryName(new UriBuilder().path(enclEntryNameBuf.toString()).getUri(), FsUriModifier.CANONICALIZE);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private void scan(@CheckForNull TFile ancestor, TArchiveDetector detector, int skip, String path, StringBuilder enclEntryNameBuf, Paths.Splitter splitter) {
        if (path == null) {
            assert (this.enclArchive == null);
            enclEntryNameBuf.setLength(0);
            return;
        }
        splitter.split(path);
        String parent = splitter.getParentPath();
        String member = splitter.getMemberName();
        if (member.length() != 0 && !".".equals(member)) {
            if ("..".equals(member)) {
                ++skip;
            } else if (skip > 0) {
                --skip;
            } else {
                boolean isArchive;
                if (ancestor != null) {
                    int ancestorPathLen;
                    int pathLen = path.length();
                    if (pathLen == (ancestorPathLen = ancestor.getPath().length())) {
                        this.enclArchive = ancestor.innerArchive;
                        if (!ancestor.isArchive()) {
                            if (ancestor.isEntry()) {
                                if (enclEntryNameBuf.length() > 0) {
                                    enclEntryNameBuf.insert(0, '/');
                                    enclEntryNameBuf.insert(0, ancestor.enclEntryName.getPath());
                                } else {
                                    assert (this.enclArchive == ancestor.enclArchive);
                                    enclEntryNameBuf.append(ancestor.enclEntryName.getPath());
                                }
                            } else {
                                assert (this.enclArchive == null);
                                enclEntryNameBuf.setLength(0);
                            }
                        } else if (enclEntryNameBuf.length() <= 0) {
                            assert (this.enclArchive == ancestor);
                            this.innerArchive = this;
                            this.enclArchive = ancestor.enclArchive;
                            if (ancestor.enclEntryName != null) {
                                enclEntryNameBuf.append(ancestor.enclEntryName.getPath());
                            }
                        }
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    if (pathLen < ancestorPathLen) {
                        detector = ancestor.detector;
                        ancestor = ancestor.enclArchive;
                    }
                }
                boolean bl = isArchive = detector.getScheme(path) != null;
                if (enclEntryNameBuf.length() > 0) {
                    if (isArchive) {
                        this.enclArchive = new TFile(path, detector);
                        if (this.innerArchive != this) {
                            this.innerArchive = this.enclArchive;
                        }
                        return;
                    }
                    enclEntryNameBuf.insert(0, '/');
                    enclEntryNameBuf.insert(0, member);
                } else {
                    if (isArchive) {
                        this.innerArchive = this;
                    }
                    enclEntryNameBuf.append(member);
                }
            }
        }
        this.scan(ancestor, detector, skip, parent, enclEntryNameBuf, splitter);
    }

    private Object writeReplace() throws ObjectStreamException {
        return this.getAbsoluteFile();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.toURI());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.parse(FsPath.create((URI)((URI)in.readObject()), (FsUriModifier)FsUriModifier.CANONICALIZE), TConfig.get().getArchiveDetector());
    }

    private boolean invariants() {
        assert (null != this.delegate);
        assert (!(this.delegate instanceof TFile));
        assert (this.delegate.getPath().equals(super.getPath()));
        assert (null != this.detector);
        assert (null != this.innerArchive == (this.getInnerEntryName() != null));
        assert (null != this.enclArchive == (this.enclEntryName != null));
        assert (this != this.enclArchive);
        assert (this == this.innerArchive ^ (this.innerArchive == this.enclArchive && null == this.controller));
        assert (null == this.enclArchive || Paths.contains((String)this.enclArchive.getPath(), (String)this.delegate.getParentFile().getPath(), (char)separatorChar) && !this.enclEntryName.toString().isEmpty());
        return true;
    }

    public static void sync(BitField<FsSyncOption> options) throws FsSyncException {
        manager.sync(options);
    }

    public static void sync(TFile archive, BitField<FsSyncOption> options) throws FsSyncException {
        if (!archive.isArchive()) {
            throw new IllegalArgumentException(archive + " (not an archive file)");
        }
        if (null != archive.getEnclArchive()) {
            throw new IllegalArgumentException(archive + " (not a top level archive file)");
        }
        new FsFilteringManager(manager, archive.getController().getModel().getMountPoint()).sync(options);
    }

    public static void umount() throws FsSyncException {
        TFile.sync((BitField<FsSyncOption>)FsSyncOptions.UMOUNT);
    }

    public static void umount(boolean closeStreams) throws FsSyncException {
        TFile.sync((BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, closeStreams).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, closeStreams));
    }

    public static void umount(boolean waitForInputStreams, boolean closeInputStreams, boolean waitForOutputStreams, boolean closeOutputStreams) throws FsSyncException {
        TFile.sync((BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.WAIT_CLOSE_INPUT, waitForInputStreams).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, closeInputStreams).set((Enum)FsSyncOption.WAIT_CLOSE_OUTPUT, waitForOutputStreams).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, closeOutputStreams));
    }

    public static void umount(TFile archive) throws FsSyncException {
        TFile.sync(archive, (BitField<FsSyncOption>)FsSyncOptions.UMOUNT);
    }

    public static void umount(TFile archive, boolean closeStreams) throws FsSyncException {
        TFile.sync(archive, (BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, closeStreams).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, closeStreams));
    }

    public static void umount(TFile archive, boolean waitForInputStreams, boolean closeInputStreams, boolean waitForOutputStreams, boolean closeOutputStreams) throws FsSyncException {
        TFile.sync(archive, (BitField<FsSyncOption>)BitField.of((Enum)FsSyncOption.CLEAR_CACHE).set((Enum)FsSyncOption.WAIT_CLOSE_INPUT, waitForInputStreams).set((Enum)FsSyncOption.FORCE_CLOSE_INPUT, closeInputStreams).set((Enum)FsSyncOption.WAIT_CLOSE_OUTPUT, waitForOutputStreams).set((Enum)FsSyncOption.FORCE_CLOSE_OUTPUT, closeOutputStreams));
    }

    public static boolean isLenient() {
        return TConfig.get().isLenient();
    }

    public static void setLenient(boolean lenient) {
        TConfig.get().setLenient(lenient);
    }

    public static TArchiveDetector getDefaultArchiveDetector() {
        return TConfig.get().getArchiveDetector();
    }

    public static void setDefaultArchiveDetector(TArchiveDetector detector) {
        TConfig.get().setArchiveDetector(detector);
    }

    @Nullable
    public TFile getNonArchivedParentFile() {
        TFile enclArchive = this.enclArchive;
        return null != enclArchive ? enclArchive.getNonArchivedParentFile() : this.getParentFile();
    }

    @Override
    @Nullable
    public String getParent() {
        return this.delegate.getParent();
    }

    @Override
    @Nullable
    public TFile getParentFile() {
        File parent = this.delegate.getParentFile();
        if (parent == null) {
            return null;
        }
        if (null != this.enclArchive && this.enclArchive.getPath().length() == parent.getPath().length()) {
            assert (this.enclArchive.getPath().equals(parent.getPath()));
            return this.enclArchive;
        }
        return new TFile(parent, this.enclArchive, this.detector);
    }

    @Override
    public TFile getAbsoluteFile() {
        String p = this.getAbsolutePath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    @Override
    public String getAbsolutePath() {
        return this.delegate.getAbsolutePath();
    }

    public TFile getNormalizedAbsoluteFile() {
        String p = this.getNormalizedAbsolutePath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    public String getNormalizedAbsolutePath() {
        return Paths.normalize((String)this.getAbsolutePath(), (char)separatorChar);
    }

    public TFile getNormalizedFile() {
        String p = this.getNormalizedPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    public String getNormalizedPath() {
        return Paths.normalize((String)this.getPath(), (char)separatorChar);
    }

    @Override
    public TFile getCanonicalFile() throws IOException {
        String p = this.getCanonicalPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.delegate.getCanonicalPath();
    }

    public TFile getCanOrAbsFile() {
        String p = this.getCanOrAbsPath();
        return p.equals(this.getPath()) ? this : new TFile(p, this.detector);
    }

    public String getCanOrAbsPath() {
        try {
            return this.getCanonicalPath();
        }
        catch (IOException ex) {
            return Paths.normalize((String)this.getAbsolutePath(), (char)separatorChar);
        }
    }

    public boolean isArchive() {
        return this == this.innerArchive;
    }

    public boolean isEntry() {
        return this.enclEntryName != null;
    }

    @CheckForNull
    public TFile getInnerArchive() {
        return this.innerArchive;
    }

    @Nullable
    public String getInnerEntryName() {
        return this == this.innerArchive ? FsEntryName.ROOT.getPath() : (null == this.enclEntryName ? null : this.enclEntryName.getPath());
    }

    @Nullable
    FsEntryName getInnerFsEntryName() {
        return this == this.innerArchive ? FsEntryName.ROOT : this.enclEntryName;
    }

    @CheckForNull
    public TFile getEnclArchive() {
        return this.enclArchive;
    }

    @Nullable
    public String getEnclEntryName() {
        return null == this.enclEntryName ? null : this.enclEntryName.getPath();
    }

    @Nullable
    FsEntryName getEnclFsEntryName() {
        return this.enclEntryName;
    }

    public TArchiveDetector getArchiveDetector() {
        return this.detector;
    }

    public File getFile() {
        return this.delegate;
    }

    @Nullable
    FsController<?> getController() {
        FsMountPoint mountPoint;
        if (this != this.innerArchive || null != this.controller) {
            return this.controller;
        }
        assert (this == this.innerArchive);
        String path = Paths.normalize((String)this.delegate.getPath(), (char)separatorChar);
        FsScheme scheme = this.detector.getScheme(path);
        if (null == scheme) {
            throw new ServiceConfigurationError("unknown file system scheme for path \"" + path + "\"! Check run-time class path configuration.");
        }
        try {
            mountPoint = new FsMountPoint(scheme, null == this.enclArchive ? new FsPath(this.delegate) : new FsPath(this.enclArchive.getController().getModel().getMountPoint(), this.enclEntryName));
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
        this.controller = manager.getController(mountPoint, (FsCompositeDriver)this.detector);
        return this.controller;
    }

    public boolean isParentOf(File file) {
        String a = this.getAbsolutePath();
        String b = file.getAbsoluteFile().getParent();
        return b != null ? Paths.contains((String)a, (String)b, (char)separatorChar) : false;
    }

    public boolean contains(File file) {
        return TFile.contains(this, file);
    }

    public static boolean contains(File a, File b) {
        return Paths.contains((String)a.getAbsolutePath(), (String)b.getAbsolutePath(), (char)separatorChar);
    }

    public boolean isFileSystemRoot() {
        TFile canOrAbsFile = this.getCanOrAbsFile();
        return ROOTS.contains(canOrAbsFile) || TFile.isUNC(canOrAbsFile.getPath());
    }

    public boolean isUNC() {
        return TFile.isUNC(this.getCanOrAbsPath());
    }

    private static boolean isUNC(String path) {
        return path.startsWith(UNC_PREFIX) && path.indexOf(separatorChar, 2) > 2;
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        return this.delegate.equals(that);
    }

    @Override
    public int compareTo(File other) {
        return this.delegate.compareTo(other);
    }

    public TFile getTopLevelArchive() {
        TFile enclArchive = this.enclArchive;
        return null != enclArchive ? enclArchive.getTopLevelArchive() : this.innerArchive;
    }

    @Override
    public String getPath() {
        return this.delegate.getPath();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean isAbsolute() {
        return this.delegate.isAbsolute();
    }

    @Override
    public boolean isHidden() {
        return this.delegate.isHidden();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    @Deprecated
    public URL toURL() throws MalformedURLException {
        return null != this.innerArchive ? this.toURI().toURL() : this.delegate.toURL();
    }

    @Override
    public URI toURI() {
        try {
            if (this == this.innerArchive) {
                FsScheme scheme = this.detector.getScheme(this.delegate.getPath());
                assert (null != scheme);
                if (null != this.enclArchive) {
                    return new FsMountPoint(scheme, new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName)).toUri();
                }
                return new FsMountPoint(scheme, new FsPath(this.delegate)).toUri();
            }
            if (null != this.enclArchive) {
                return new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName).toUri();
            }
            return this.delegate.toURI();
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public FsPath toFsPath() {
        try {
            if (this == this.innerArchive) {
                FsScheme scheme = this.detector.getScheme(this.delegate.getPath());
                assert (null != scheme);
                if (null != this.enclArchive) {
                    return new FsPath(new FsMountPoint(scheme, new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName)), FsEntryName.ROOT);
                }
                return new FsPath(new FsMountPoint(scheme, new FsPath(this.delegate)), FsEntryName.ROOT);
            }
            if (null != this.enclArchive) {
                return new FsPath(new FsMountPoint(this.enclArchive.toURI(), FsUriModifier.CANONICALIZE), this.enclEntryName);
            }
            return new FsPath(this.delegate);
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    @Deprecated
    public Path toPath() {
        throw new UnsupportedOperationException("Use a Path constructor or method instead!");
    }

    @Override
    public boolean exists() {
        if (null != this.enclArchive) {
            try {
                return null != this.enclArchive.getController().getEntry(this.getEnclFsEntryName());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.exists();
    }

    @Override
    public boolean isFile() {
        if (null != this.innerArchive) {
            try {
                FsEntry entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
                return null != entry && entry.isType(Entry.Type.FILE);
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.isFile();
    }

    @Override
    public boolean isDirectory() {
        if (null != this.innerArchive) {
            try {
                FsEntry entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
                return null != entry && entry.isType(Entry.Type.DIRECTORY);
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.isDirectory();
    }

    @CheckForNull
    public Icon getOpenIcon() {
        if (this == this.innerArchive) {
            try {
                return this.getController().getOpenIcon();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @CheckForNull
    public Icon getClosedIcon() {
        if (this == this.innerArchive) {
            try {
                return this.getController().getClosedIcon();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean canRead() {
        if (null != this.innerArchive) {
            try {
                return this.innerArchive.getController().isReadable(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.canRead();
    }

    @Override
    public boolean canWrite() {
        if (null != this.innerArchive) {
            try {
                return this.innerArchive.getController().isWritable(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.canWrite();
    }

    @Override
    public boolean canExecute() {
        if (null != this.innerArchive) {
            try {
                return this.innerArchive.getController().isExecutable(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.canExecute();
    }

    @Override
    public boolean setReadOnly() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().setReadOnly(this.getInnerFsEntryName());
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.setReadOnly();
    }

    @Override
    public long length() {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return 0L;
            }
            if (null == entry) {
                return 0L;
            }
            long size = entry.getSize(Entry.Size.DATA);
            return -1L == size ? 0L : size;
        }
        return this.delegate.length();
    }

    @Override
    public long lastModified() {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return 0L;
            }
            if (null == entry) {
                return 0L;
            }
            long time = entry.getTime(Entry.Access.WRITE);
            return 0L <= time ? time : 0L;
        }
        return this.delegate.lastModified();
    }

    @Override
    public boolean setLastModified(long time) {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().setTime(this.getInnerFsEntryName(), BitField.of((Enum)Entry.Access.WRITE), time);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.setLastModified(time);
    }

    @Override
    @Nullable
    public String[] list() {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return null;
            }
            if (null == entry) {
                return null;
            }
            Set members = entry.getMembers();
            return null == members ? null : members.toArray(new String[members.size()]);
        }
        return this.delegate.list();
    }

    @Override
    @Nullable
    public String[] list(@CheckForNull FilenameFilter filter) {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return null;
            }
            if (null == entry) {
                return null;
            }
            Set members = entry.getMembers();
            if (null == members) {
                return null;
            }
            if (null == filter) {
                return members.toArray(new String[members.size()]);
            }
            ArrayList<String> accepted = new ArrayList<String>(members.size());
            for (String member : members) {
                if (!filter.accept(this, member)) continue;
                accepted.add(member);
            }
            return accepted.toArray(new String[accepted.size()]);
        }
        return this.delegate.list(filter);
    }

    @Nullable
    public TFile[] listFiles() {
        return this.listFiles((FilenameFilter)null, this.detector);
    }

    @Nullable
    public TFile[] listFiles(TArchiveDetector detector) {
        return this.listFiles((FilenameFilter)null, detector);
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FilenameFilter filter) {
        return this.listFiles(filter, this.detector);
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FilenameFilter filter, TArchiveDetector detector) {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return null;
            }
            if (null == entry) {
                return null;
            }
            return this.filter((Collection<String>)entry.getMembers(), filter, detector);
        }
        return this.filter(Arrays.asList(this.delegate.list(filter)), (FilenameFilter)null, detector);
    }

    @Nullable
    private TFile[] filter(@CheckForNull Collection<String> members, @CheckForNull FilenameFilter filter, TArchiveDetector detector) {
        if (null == members) {
            return null;
        }
        ArrayList<TFile> accepted = new ArrayList<TFile>(members.size());
        for (String member : members) {
            if (null != filter && !filter.accept(this, member)) continue;
            accepted.add(new TFile((File)this, member, detector));
        }
        return accepted.toArray(new TFile[accepted.size()]);
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FileFilter filter) {
        return this.listFiles(filter, this.detector);
    }

    @Nullable
    public TFile[] listFiles(@CheckForNull FileFilter filter, TArchiveDetector detector) {
        if (null != this.innerArchive) {
            FsEntry entry;
            try {
                entry = this.innerArchive.getController().getEntry(this.getInnerFsEntryName());
            }
            catch (IOException ex) {
                return null;
            }
            if (null == entry) {
                return null;
            }
            return this.filter((Collection<String>)entry.getMembers(), filter, detector);
        }
        return this.filter(Arrays.asList(this.delegate.list()), filter, detector);
    }

    @Nullable
    private TFile[] filter(@CheckForNull Collection<String> members, @CheckForNull FileFilter filter, TArchiveDetector detector) {
        if (null == members) {
            return null;
        }
        ArrayList<TFile> accepted = new ArrayList<TFile>(members.size());
        for (String member : members) {
            TFile file = new TFile((File)this, member, detector);
            if (null != filter && !filter.accept(file)) continue;
            accepted.add(file);
        }
        return accepted.toArray(new TFile[accepted.size()]);
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (null != this.innerArchive) {
            FsEntryName entryName;
            FsController<?> controller = this.innerArchive.getController();
            if (null != controller.getEntry(entryName = this.getInnerFsEntryName())) {
                return false;
            }
            controller.mknod(entryName, Entry.Type.FILE, BitField.of((Enum)FsOutputOption.EXCLUSIVE).set((Enum)FsOutputOption.CREATE_PARENTS, TConfig.get().isLenient()), null);
            return true;
        }
        return this.delegate.createNewFile();
    }

    @Override
    public boolean mkdirs() {
        if (null == this.innerArchive) {
            return this.delegate.mkdirs();
        }
        TFile parent = this.getParentFile();
        if (null != parent && !parent.exists()) {
            parent.mkdirs();
        }
        return this.mkdir();
    }

    @Override
    public boolean mkdir() {
        if (null != this.innerArchive) {
            try {
                this.innerArchive.getController().mknod(this.getInnerFsEntryName(), Entry.Type.DIRECTORY, FsOutputOptions.NO_OUTPUT_OPTIONS.set((Enum)FsOutputOption.CREATE_PARENTS, TConfig.get().isLenient()), null);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return this.delegate.mkdir();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TFile mkdir(boolean recursive) throws IOException {
        if (null != this.innerArchive) {
            TFile parent;
            if (recursive && null != (parent = this.getParentFile()) && !parent.exists()) {
                parent.mkdir(recursive);
            }
            FsController<?> controller = this.innerArchive.getController();
            FsEntryName innerEntryName = this.getInnerFsEntryName();
            try {
                controller.mknod(innerEntryName, Entry.Type.DIRECTORY, FsOutputOptions.NO_OUTPUT_OPTIONS.set((Enum)FsOutputOption.CREATE_PARENTS, TConfig.get().isLenient()), null);
                return this;
            }
            catch (IOException ex) {
                FsEntry entry = controller.getEntry(innerEntryName);
                if (null != entry && entry.isType(Entry.Type.DIRECTORY)) return this;
                throw ex;
            }
        } else {
            File dir = this.delegate;
            if ((!recursive ? dir.mkdir() : dir.mkdirs()) || dir.isDirectory()) return this;
            throw new IOException(dir + " (cannot create directory)");
        }
    }

    @Override
    @Deprecated
    public boolean delete() {
        try {
            TFile.rm(this);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public TFile rm() throws IOException {
        TFile.rm(this);
        return this;
    }

    public static void rm(File node) throws IOException {
        if (node instanceof TFile) {
            TFile file = (TFile)node;
            if (null != file.innerArchive) {
                file.innerArchive.getController().unlink(file.getInnerFsEntryName());
                return;
            }
            node = file.delegate;
        }
        if (!node.delete()) {
            throw new IOException(node + " (cannot delete)");
        }
    }

    public TFile rm_r() throws IOException {
        TBIO.rm_r(this, this.detector);
        return this;
    }

    public static void rm_r(File node) throws IOException {
        TBIO.rm_r(node, node instanceof TFile ? ((TFile)node).detector : TArchiveDetector.NULL);
    }

    @Override
    public void deleteOnExit() {
        if (this.innerArchive != null) {
            throw new UnsupportedOperationException();
        }
        this.delegate.deleteOnExit();
    }

    @Override
    @Deprecated
    public boolean renameTo(File dst) {
        try {
            TFile.mv(this, dst, this.detector);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public TFile mv(File dst) throws IOException {
        TFile.mv(this, dst, this.detector);
        return this;
    }

    public static void mv(File src, File dst, TArchiveDetector detector) throws IOException {
        if (detector.toString().isEmpty()) {
            File dstDelegate;
            boolean dstArchived;
            File srcDelegate;
            boolean srcArchived;
            if (src instanceof TFile) {
                TFile srcFile = (TFile)src;
                srcArchived = null != srcFile.innerArchive;
                srcDelegate = srcFile.delegate;
            } else {
                srcArchived = false;
                srcDelegate = src;
            }
            if (dst instanceof TFile) {
                TFile dstFile = (TFile)dst;
                dstArchived = null != dstFile.innerArchive;
                dstDelegate = dstFile.delegate;
            } else {
                dstArchived = false;
                dstDelegate = src;
            }
            if (!srcArchived && !dstArchived) {
                if (srcDelegate.renameTo(dstDelegate)) {
                    return;
                }
                throw new IOException(src + " (cannot move to " + dst + ")");
            }
        }
        TBIO.mv(src, dst, detector);
    }

    public static void cp(InputStream in, OutputStream out) throws IOException {
        Streams.copy((InputStream)in, (OutputStream)out);
    }

    public static void cp(InputStream in, File dst) throws IOException {
        block2: {
            TFileOutputStream out = new TFileOutputStream(dst);
            try {
                TFile.cp(in, (OutputStream)((Object)out));
            }
            catch (IOException ex) {
                if (dst.delete()) break block2;
                throw new IOException(dst + " (cannot delete)", ex);
            }
        }
    }

    public static void cp(File src, OutputStream out) throws IOException {
        TFile.cp((InputStream)((Object)new TFileInputStream(src)), out);
    }

    public TFile cp(File dst) throws IOException {
        TBIO.cp(false, this, dst);
        return this;
    }

    public static void cp(File src, File dst) throws IOException {
        TBIO.cp(false, src, dst);
    }

    public TFile cp_p(File dst) throws IOException {
        TBIO.cp(true, this, dst);
        return this;
    }

    public static void cp_p(File src, File dst) throws IOException {
        TBIO.cp(true, src, dst);
    }

    public TFile cp_r(File dst) throws IOException {
        TBIO.cp_r(false, this, dst, this.detector, this.detector);
        return this;
    }

    public static void cp_r(File src, File dst, TArchiveDetector detector) throws IOException {
        TBIO.cp_r(false, src, dst, detector, detector);
    }

    public static void cp_r(File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        TBIO.cp_r(false, src, dst, srcDetector, dstDetector);
    }

    public TFile cp_rp(File dst) throws IOException {
        TBIO.cp_r(true, this, dst, this.detector, this.detector);
        return this;
    }

    public static void cp_rp(File src, File dst, TArchiveDetector detector) throws IOException {
        TBIO.cp_r(true, src, dst, detector, detector);
    }

    public static void cp_rp(File src, File dst, TArchiveDetector srcDetector, TArchiveDetector dstDetector) throws IOException {
        TBIO.cp_r(true, src, dst, srcDetector, dstDetector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void input(InputStream in) throws IOException {
        try {
            TFileOutputStream out = new TFileOutputStream(this, false);
            try {
                Streams.cat((InputStream)in, (OutputStream)((Object)out));
            }
            finally {
                ((OutputStream)((Object)out)).close();
            }
        }
        catch (IOException ex) {
            try {
                this.rm();
            }
            catch (IOException ex2) {
                throw (IOException)ex2.initCause(ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(OutputStream out) throws IOException {
        TFileInputStream in = new TFileInputStream(this);
        try {
            Streams.cat((InputStream)((Object)in), (OutputStream)out);
        }
        finally {
            ((InputStream)((Object)in)).close();
        }
    }

    public static void cat(InputStream in, OutputStream out) throws IOException {
        Streams.cat((InputStream)in, (OutputStream)out);
    }
}

