/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.automata.nfa;

import java.util.HashSet;
import net.domesdaybook.automata.nfa.NfaState;
import net.domesdaybook.matcher.Matcher;
import net.domesdaybook.reader.ByteReader;

public class NfaMatcher
implements Matcher {
    private NfaState firstState;

    public NfaMatcher(NfaState firstState) {
        this.firstState = firstState;
    }

    @Override
    public final boolean matches(ByteReader reader, long fromPosition) {
        long currentPosition = fromPosition;
        HashSet<NfaState> activeStates = new HashSet<NfaState>();
        activeStates.add(this.firstState);
        boolean matched = this.firstState.isFinal();
        while (!matched && activeStates.size() > 0) {
            byte currentByte = reader.readByte(currentPosition++);
            HashSet<NfaState> nextStates = new HashSet<NfaState>();
            for (NfaState state : activeStates) {
                matched |= state.isFinal();
                nextStates.addAll(state.nextStates(currentByte));
            }
            activeStates = nextStates;
        }
        return matched;
    }
}

