/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.automata.transition;

import java.util.Set;
import net.domesdaybook.automata.State;
import net.domesdaybook.automata.Transition;
import net.domesdaybook.automata.nfa.NfaState;
import net.domesdaybook.automata.transition.TransitionFactory;
import net.domesdaybook.automata.transition.TransitionSingleByteMatcher;
import net.domesdaybook.matcher.singlebyte.AllBitMaskMatcher;
import net.domesdaybook.matcher.singlebyte.AnyBitMaskMatcher;
import net.domesdaybook.matcher.singlebyte.AnyByteMatcher;
import net.domesdaybook.matcher.singlebyte.ByteMatcher;
import net.domesdaybook.matcher.singlebyte.ByteSetMatcher;
import net.domesdaybook.matcher.singlebyte.CaseInsensitiveByteMatcher;

public class TransitionSingleByteMatcherFactory
implements TransitionFactory {
    @Override
    public final Transition createByteTransition(byte theByte, State toState) {
        return new TransitionSingleByteMatcher(new ByteMatcher(theByte), toState);
    }

    @Override
    public final Transition createAllBitmaskTransition(byte bitMask, State toState) {
        return new TransitionSingleByteMatcher(new AllBitMaskMatcher(bitMask), toState);
    }

    @Override
    public final Transition createAnyBitmaskTransition(byte bitMask, State toState) {
        return new TransitionSingleByteMatcher(new AnyBitMaskMatcher(bitMask), toState);
    }

    @Override
    public final Transition createSetTransition(Set<Byte> byteSet, boolean negated, State toState) {
        return new TransitionSingleByteMatcher(ByteSetMatcher.buildOptimalMatcher(byteSet, negated), toState);
    }

    @Override
    public final Transition createAnyByteTransition(NfaState toState) {
        return new TransitionSingleByteMatcher(new AnyByteMatcher(), toState);
    }

    @Override
    public final Transition createCaseInsensitiveByteTransition(char Char, NfaState toState) {
        return new TransitionSingleByteMatcher(new CaseInsensitiveByteMatcher(Character.valueOf(Char)), toState);
    }
}

