/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.expression.compiler.nfa;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.domesdaybook.automata.Transition;
import net.domesdaybook.automata.nfa.NfaState;
import net.domesdaybook.automata.transition.TransitionFactory;
import net.domesdaybook.expression.compiler.nfa.StateBuilder;
import net.domesdaybook.expression.compiler.nfa.StateWrapper;
import net.domesdaybook.expression.compiler.nfa.StateWrapperBuilder;

public class ChamparnaudGlushkovBuilder
implements StateWrapperBuilder {
    private TransitionFactory transitionFactory;
    private StateBuilder stateBuilder;

    public ChamparnaudGlushkovBuilder(TransitionFactory transitionFactory, StateBuilder builder) {
        this.transitionFactory = transitionFactory;
        this.stateBuilder = builder;
    }

    @Override
    public void setTransitionFactory(TransitionFactory transitionFactory) {
        this.transitionFactory = transitionFactory;
    }

    @Override
    public void setStateBuilder(StateBuilder stateBuilder) {
        this.stateBuilder = stateBuilder;
    }

    @Override
    public final StateWrapper buildSingleByteStates(byte transitionByte) {
        StateWrapper states = this.createInitialFinalStates();
        NfaState finalState = states.finalStates.get(0);
        Transition transition = this.transitionFactory.createByteTransition(transitionByte, finalState);
        states.initialState.addTransition(transition);
        return states;
    }

    @Override
    public final StateWrapper buildSetStates(Set<Byte> byteSet, boolean negated) {
        StateWrapper states = this.createInitialFinalStates();
        NfaState finalState = states.finalStates.get(0);
        Transition transition = this.transitionFactory.createSetTransition(byteSet, negated, finalState);
        states.initialState.addTransition(transition);
        return states;
    }

    @Override
    public final StateWrapper buildAnyByteStates() {
        StateWrapper states = this.createInitialFinalStates();
        NfaState finalState = states.finalStates.get(0);
        Transition transition = this.transitionFactory.createAnyByteTransition(finalState);
        states.initialState.addTransition(transition);
        return states;
    }

    @Override
    public final StateWrapper buildAllBitmaskStates(byte bitMask) {
        StateWrapper states = this.createInitialFinalStates();
        NfaState finalState = states.finalStates.get(0);
        Transition transition = this.transitionFactory.createAllBitmaskTransition(bitMask, finalState);
        states.initialState.addTransition(transition);
        return states;
    }

    @Override
    public final StateWrapper buildAnyBitmaskStates(byte bitMask) {
        StateWrapper states = this.createInitialFinalStates();
        NfaState finalState = states.finalStates.get(0);
        Transition transition = this.transitionFactory.createAnyBitmaskTransition(bitMask, finalState);
        states.initialState.addTransition(transition);
        return states;
    }

    @Override
    public final StateWrapper buildSequenceStates(List<StateWrapper> sequenceStates) {
        ArrayList<NfaState> finalSequenceStates = new ArrayList<NfaState>();
        int stop = sequenceStates.size();
        for (int itemIndex = 1; itemIndex < stop; ++itemIndex) {
            StateWrapper leftState = sequenceStates.get(itemIndex - 1);
            StateWrapper rightState = sequenceStates.get(itemIndex);
            NfaState initialStateToReplace = rightState.initialState;
            List<Transition> transitionList = initialStateToReplace.getTransitions();
            boolean initialStateIsFinal = initialStateToReplace.isFinal();
            finalSequenceStates.addAll(leftState.finalStates);
            for (NfaState state : finalSequenceStates) {
                state.addAllTransitions(transitionList);
                state.setIsFinal(initialStateIsFinal);
            }
            if (initialStateIsFinal) continue;
            finalSequenceStates = new ArrayList();
        }
        StateWrapper lastState = sequenceStates.get(sequenceStates.size() - 1);
        finalSequenceStates.addAll(lastState.finalStates);
        StateWrapper states = new StateWrapper();
        StateWrapper firstState = sequenceStates.get(0);
        states.initialState = firstState.initialState;
        states.finalStates = finalSequenceStates;
        return states;
    }

    @Override
    public final StateWrapper buildAlternativeStates(List<StateWrapper> alternateStates) {
        ArrayList<NfaState> finalStates = new ArrayList<NfaState>();
        NfaState initialState = this.stateBuilder.build(false);
        boolean anyInitialStateIsFinal = false;
        int stop = alternateStates.size();
        for (int alternateIndex = 0; alternateIndex < stop; ++alternateIndex) {
            StateWrapper altStates = alternateStates.get(alternateIndex);
            NfaState alternateInitialState = altStates.initialState;
            anyInitialStateIsFinal |= alternateInitialState.isFinal();
            initialState.addAllTransitions(alternateInitialState.getTransitions());
            finalStates.addAll(altStates.finalStates);
        }
        StateWrapper states = new StateWrapper();
        states.initialState = initialState;
        states.finalStates = finalStates;
        states.setIsFinal(initialState, anyInitialStateIsFinal);
        return states;
    }

    @Override
    public final StateWrapper buildZeroToManyStates(StateWrapper zeroToManyStates) {
        NfaState initialState = zeroToManyStates.initialState;
        List<Transition> intialTransitions = initialState.getTransitions();
        List<NfaState> finalStates = zeroToManyStates.finalStates;
        for (NfaState state : finalStates) {
            state.addAllTransitions(intialTransitions);
        }
        zeroToManyStates.setIsFinal(initialState, true);
        return zeroToManyStates;
    }

    @Override
    public final StateWrapper buildOneToManyStates(StateWrapper oneToManyStates) {
        NfaState initialState = oneToManyStates.initialState;
        List<Transition> intialTransitions = initialState.getTransitions();
        List<NfaState> finalStates = oneToManyStates.finalStates;
        for (NfaState state : finalStates) {
            state.addAllTransitions(intialTransitions);
        }
        return oneToManyStates;
    }

    @Override
    public final StateWrapper buildOptionalStates(StateWrapper optionalStates) {
        optionalStates.setIsFinal(optionalStates.initialState, true);
        return optionalStates;
    }

    @Override
    public final StateWrapper buildMinToManyStates(int minRepeat, StateWrapper repeatedAutomata) {
        StateWrapper states = null;
        if (minRepeat == 0) {
            states = this.buildZeroToManyStates(repeatedAutomata);
        } else if (minRepeat > 0) {
            StateWrapper repeatStates = this.buildRepeatedStates(minRepeat, repeatedAutomata);
            StateWrapper zeroToManyStates = this.buildZeroToManyStates(repeatedAutomata.deepCopy());
            states = this.joinStates(repeatStates, zeroToManyStates);
        }
        return states;
    }

    @Override
    public final StateWrapper buildMinToMaxStates(int minRepeat, int maxRepeat, StateWrapper repeatedAutomata) {
        StateWrapper states = null;
        if (minRepeat == 0) {
            states = this.buildRepeatedOptionalStates(maxRepeat, repeatedAutomata);
        } else {
            states = this.buildRepeatedStates(minRepeat, repeatedAutomata);
            if (maxRepeat > minRepeat) {
                StateWrapper optionalStates = this.buildRepeatedOptionalStates(maxRepeat - minRepeat, repeatedAutomata);
                states = this.joinStates(states, optionalStates);
            }
        }
        return states;
    }

    @Override
    public final StateWrapper buildRepeatedOptionalStates(int numberOptional, StateWrapper optionalState) {
        ArrayList<StateWrapper> optionalStates = new ArrayList<StateWrapper>();
        for (int count = 0; count < numberOptional; ++count) {
            StateWrapper optStates = this.buildOptionalStates(optionalState.deepCopy());
            optionalStates.add(optStates);
        }
        return this.buildSequenceStates(optionalStates);
    }

    @Override
    public final StateWrapper buildRepeatedStates(int repeatNumber, StateWrapper repeatedAutomata) {
        ArrayList<StateWrapper> repeatStates = new ArrayList<StateWrapper>();
        for (int count = 0; count < repeatNumber; ++count) {
            StateWrapper newState = repeatedAutomata.deepCopy();
            repeatStates.add(newState);
        }
        return this.buildSequenceStates(repeatStates);
    }

    @Override
    public final StateWrapper buildCaseSensitiveStringStates(String str) {
        NfaState firstState;
        StateWrapper states = new StateWrapper();
        NfaState lastState = firstState = this.stateBuilder.build(false);
        int stop = str.length();
        for (int index = 0; index < stop; ++index) {
            byte transitionByte = (byte)str.charAt(index);
            NfaState transitionToState = this.stateBuilder.build(false);
            Transition transition = this.transitionFactory.createByteTransition(transitionByte, transitionToState);
            lastState.addTransition(transition);
            lastState = transitionToState;
        }
        states.initialState = firstState;
        states.setIsFinal(lastState, true);
        return states;
    }

    @Override
    public final StateWrapper buildCaseInsensitiveStringStates(String str) {
        NfaState firstState;
        StateWrapper states = new StateWrapper();
        NfaState lastState = firstState = this.stateBuilder.build(false);
        int stop = str.length();
        for (int index = 0; index < stop; ++index) {
            Transition transition;
            char transitionChar = str.charAt(index);
            NfaState transitionToState = this.stateBuilder.build(false);
            if (transitionChar >= 'A' && transitionChar <= 'Z' || transitionChar >= 'a' && transitionChar <= 'z') {
                transition = this.transitionFactory.createCaseInsensitiveByteTransition(transitionChar, transitionToState);
            } else {
                byte transitionByte = (byte)transitionChar;
                transition = this.transitionFactory.createByteTransition(transitionByte, transitionToState);
            }
            lastState.addTransition(transition);
            lastState = transitionToState;
        }
        states.initialState = firstState;
        states.setIsFinal(lastState, true);
        return states;
    }

    private StateWrapper createInitialFinalStates() {
        StateWrapper states = new StateWrapper();
        states.initialState = this.stateBuilder.build(false);
        states.finalStates = new ArrayList<NfaState>();
        states.finalStates.add(this.stateBuilder.build(true));
        return states;
    }

    private StateWrapper joinStates(StateWrapper leftState, StateWrapper rightState) {
        ArrayList<StateWrapper> joinedAutomata = new ArrayList<StateWrapper>();
        joinedAutomata.add(leftState);
        joinedAutomata.add(rightState);
        return this.buildSequenceStates(joinedAutomata);
    }
}

