/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.expression.compiler.nfa;

import java.util.ArrayList;
import java.util.Set;
import net.domesdaybook.automata.nfa.NfaState;
import net.domesdaybook.automata.transition.TransitionSingleByteMatcherFactory;
import net.domesdaybook.expression.compiler.AstCompiler;
import net.domesdaybook.expression.compiler.nfa.ChamparnaudGlushkovBuilder;
import net.domesdaybook.expression.compiler.nfa.SimpleStateBuilder;
import net.domesdaybook.expression.compiler.nfa.StateWrapper;
import net.domesdaybook.expression.compiler.nfa.StateWrapperBuilder;
import net.domesdaybook.expression.parser.ParseException;
import net.domesdaybook.expression.parser.ParseUtils;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class NfaCompiler
extends AstCompiler<NfaState> {
    private StateWrapperBuilder stateWrapperBuilder;

    public NfaCompiler() {
        TransitionSingleByteMatcherFactory transitionFactory = new TransitionSingleByteMatcherFactory();
        SimpleStateBuilder stateBuilder = new SimpleStateBuilder();
        this.stateWrapperBuilder = new ChamparnaudGlushkovBuilder(transitionFactory, stateBuilder);
    }

    public NfaCompiler(StateWrapperBuilder stateWrapperBuilder) {
        this.stateWrapperBuilder = stateWrapperBuilder;
    }

    public void setStateWrapperBuilder(StateWrapperBuilder stateWrapperBuilder) {
        this.stateWrapperBuilder = stateWrapperBuilder;
    }

    @Override
    public NfaState compile(CommonTree ast) throws ParseException {
        if (ast == null) {
            throw new ParseException("Null abstract syntax tree passed in to NfaCompiler.");
        }
        try {
            return this.buildAutomata((CommonTree)ast).initialState;
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e);
        }
    }

    private StateWrapper buildAutomata(CommonTree ast) throws ParseException {
        StateWrapper states = null;
        switch (ast.getToken().getType()) {
            case 4: {
                ArrayList<StateWrapper> sequenceStates = new ArrayList<StateWrapper>();
                int stop = ast.getChildCount();
                for (int childIndex = 0; childIndex < stop; ++childIndex) {
                    CommonTree child = (CommonTree)ast.getChild(childIndex);
                    StateWrapper childAutomata = this.buildAutomata(child);
                    sequenceStates.add(childAutomata);
                }
                states = this.stateWrapperBuilder.buildSequenceStates(sequenceStates);
                break;
            }
            case 13: {
                ArrayList<StateWrapper> alternateStates = new ArrayList<StateWrapper>();
                int stop = ast.getChildCount();
                for (int childIndex = 0; childIndex < stop; ++childIndex) {
                    CommonTree child = (CommonTree)ast.getChild(childIndex);
                    StateWrapper childAutomata = this.buildAutomata(child);
                    alternateStates.add(childAutomata);
                }
                states = this.stateWrapperBuilder.buildAlternativeStates(alternateStates);
                break;
            }
            case 6: {
                CommonTree nodeToRepeat = (CommonTree)ast.getChild(2);
                StateWrapper repeatedAutomata = this.buildAutomata(nodeToRepeat);
                int minRepeat = ParseUtils.getChildIntValue((Tree)ast, 0);
                if ("*".equals(ParseUtils.getChildStringValue((Tree)ast, 1))) {
                    states = this.stateWrapperBuilder.buildMinToManyStates(minRepeat, repeatedAutomata);
                    break;
                }
                int maxRepeat = ParseUtils.getChildIntValue((Tree)ast, 1);
                states = this.stateWrapperBuilder.buildMinToMaxStates(minRepeat, maxRepeat, repeatedAutomata);
                break;
            }
            case 59: {
                CommonTree zeroToManyNode = (CommonTree)ast.getChild(0);
                StateWrapper zeroToManyStates = this.buildAutomata(zeroToManyNode);
                states = this.stateWrapperBuilder.buildZeroToManyStates(zeroToManyStates);
                break;
            }
            case 62: {
                CommonTree oneToManyNode = (CommonTree)ast.getChild(0);
                StateWrapper oneToManyStates = this.buildAutomata(oneToManyNode);
                states = this.stateWrapperBuilder.buildOneToManyStates(oneToManyStates);
                break;
            }
            case 61: {
                CommonTree optionalNode = (CommonTree)ast.getChild(0);
                StateWrapper optionalStates = this.buildAutomata(optionalNode);
                states = this.stateWrapperBuilder.buildOptionalStates(optionalStates);
                break;
            }
            case 14: {
                byte transitionByte = ParseUtils.getHexByteValue((Tree)ast);
                states = this.stateWrapperBuilder.buildSingleByteStates(transitionByte);
                break;
            }
            case 10: {
                byte transitionByte = ParseUtils.getBitMaskValue((Tree)ast);
                states = this.stateWrapperBuilder.buildAllBitmaskStates(transitionByte);
                break;
            }
            case 11: {
                byte transitionByte = ParseUtils.getBitMaskValue((Tree)ast);
                states = this.stateWrapperBuilder.buildAnyBitmaskStates(transitionByte);
                break;
            }
            case 7: {
                Set<Byte> byteSet = ParseUtils.calculateSetValue(ast);
                states = this.stateWrapperBuilder.buildSetStates(byteSet, false);
                break;
            }
            case 8: {
                Set<Byte> byteSet = ParseUtils.calculateSetValue(ast);
                states = this.stateWrapperBuilder.buildSetStates(byteSet, true);
                break;
            }
            case 12: {
                states = this.stateWrapperBuilder.buildAnyByteStates();
                break;
            }
            case 20: {
                String str = ParseUtils.trimString(ast.getText());
                states = this.stateWrapperBuilder.buildCaseSensitiveStringStates(str);
                break;
            }
            case 53: {
                String str = ParseUtils.trimString(ast.getText());
                states = this.stateWrapperBuilder.buildCaseInsensitiveStringStates(str);
                break;
            }
            default: {
                throw new ParseException(ParseUtils.getTypeErrorMessage(ast));
            }
        }
        return states;
    }
}

