/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.sequence;

import java.util.List;
import net.domesdaybook.matcher.sequence.SequenceMatcher;
import net.domesdaybook.matcher.singlebyte.ByteMatcher;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public class ByteSequenceMatcher
implements SequenceMatcher {
    public static final int QUOTE_CHARACTER_VALUE = 39;
    public static final int START_PRINTABLE_ASCII = 32;
    public static final int END_PRINTABLE_ASCII = 126;
    private final byte[] byteArray;
    private final int length;

    public ByteSequenceMatcher(byte[] byteArray) {
        if (byteArray == null) {
            throw new IllegalArgumentException("Null byte array passed in to ByteSequenceMatcher");
        }
        this.byteArray = (byte[])byteArray.clone();
        this.length = byteArray.length;
    }

    public ByteSequenceMatcher(List<Byte> byteList) {
        if (byteList == null || byteList.isEmpty()) {
            throw new IllegalArgumentException("Null or empty byte list passed in to ByteSequenceMatcher.");
        }
        this.byteArray = new byte[byteList.size()];
        int index = 0;
        for (Byte b : byteList) {
            this.byteArray[index++] = b;
        }
        this.length = this.byteArray.length;
    }

    public ByteSequenceMatcher(byte byteValue) {
        this.byteArray = new byte[1];
        this.byteArray[0] = byteValue;
        this.length = 1;
    }

    @Override
    public final boolean matches(ByteReader reader, long matchFrom) {
        boolean result = true;
        byte[] localArray = this.byteArray;
        int localStop = this.length;
        for (int byteIndex = 0; result && byteIndex < localStop; ++byteIndex) {
            result = localArray[byteIndex] == reader.readByte(matchFrom + (long)byteIndex);
        }
        return result;
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final String toRegularExpression(boolean prettyPrint) {
        return this.bytesToString(prettyPrint, this.byteArray);
    }

    @Override
    public final SingleByteMatcher getByteMatcherForPosition(int position) {
        return new ByteMatcher(this.byteArray[position]);
    }

    private String bytesToString(boolean prettyPrint, byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        boolean inString = false;
        int byteLength = bytes.length;
        for (int byteIndex = 0; byteIndex < byteLength; ++byteIndex) {
            String formatString;
            int byteValue = 0xFF & bytes[byteIndex];
            if (prettyPrint && byteValue >= 32 && byteValue <= 126 && byteValue != 39) {
                formatString = inString ? "%c" : " '%c";
                hexString.append(String.format(formatString, Character.valueOf((char)byteValue)));
                inString = true;
                continue;
            }
            formatString = prettyPrint ? (inString ? "' %02x" : "%02x") : "%02x";
            hexString.append(String.format(formatString, byteValue));
            inString = false;
        }
        if (prettyPrint && inString) {
            hexString.append("' ");
        }
        return hexString.toString();
    }
}

