/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.sequence;

import java.util.ArrayList;
import java.util.List;
import net.domesdaybook.matcher.sequence.SequenceMatcher;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public class CombinedSequenceMatcher
implements SequenceMatcher {
    private final List<SequenceMatcher> matchers = new ArrayList<SequenceMatcher>();
    private final List<ByteMatcherIndex> byteMatcherForPosition = new ArrayList<ByteMatcherIndex>();
    private final int length;

    public CombinedSequenceMatcher(List<SequenceMatcher> matchList) {
        if (matchList == null || matchList.isEmpty()) {
            throw new IllegalArgumentException("Null or empty match list passed in to CombinedSequenceMatcher.");
        }
        this.matchers.addAll(matchList);
        this.length = this.calculatePositions();
    }

    @Override
    public final boolean matches(ByteReader reader, long matchFrom) {
        boolean result = true;
        long matchAt = matchFrom;
        List<SequenceMatcher> localList = this.matchers;
        int stop = localList.size();
        for (int matchIndex = 0; matchIndex < stop; ++matchIndex) {
            SequenceMatcher matcher = localList.get(matchIndex);
            if (matcher.matches(reader, matchAt)) {
                matchAt += (long)matcher.length();
                continue;
            }
            result = false;
            break;
        }
        return result;
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final String toRegularExpression(boolean prettyPrint) {
        StringBuilder regularExpression = new StringBuilder();
        int lastMatcher = this.matchers.size();
        for (int matcherIndex = 0; matcherIndex < lastMatcher; ++matcherIndex) {
            SequenceMatcher matcher = this.matchers.get(matcherIndex);
            regularExpression.append(matcher.toRegularExpression(prettyPrint));
        }
        return regularExpression.toString();
    }

    @Override
    public final SingleByteMatcher getByteMatcherForPosition(int position) {
        ByteMatcherIndex index = this.byteMatcherForPosition.get(position);
        SequenceMatcher matcher = index.matcher;
        return matcher.getByteMatcherForPosition(index.offset);
    }

    List<SequenceMatcher> getMatchers() {
        return this.matchers;
    }

    private int calculatePositions() {
        int len = 0;
        int stop = this.matchers.size();
        for (int seqIndex = 0; seqIndex < stop; ++seqIndex) {
            SequenceMatcher matcher = this.matchers.get(seqIndex);
            int numberOfBytes = matcher.length();
            for (int matcherPos = 0; matcherPos < numberOfBytes; ++matcherPos) {
                ByteMatcherIndex index = new ByteMatcherIndex(matcher, matcherPos);
                this.byteMatcherForPosition.add(index);
            }
            len += numberOfBytes;
        }
        return len;
    }

    private final class ByteMatcherIndex {
        public final SequenceMatcher matcher;
        public final int offset;

        ByteMatcherIndex(SequenceMatcher matcher, int offset) {
            this.matcher = matcher;
            this.offset = offset;
        }
    }
}

