/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.singlebyte;

import java.util.Arrays;
import java.util.Set;
import net.domesdaybook.matcher.singlebyte.ByteUtilities;
import net.domesdaybook.matcher.singlebyte.InvertibleMatcher;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public final class ByteSetBinarySearchMatcher
extends InvertibleMatcher
implements SingleByteMatcher {
    private static final String ILLEGAL_ARGUMENTS = "Null or empty set of bytes passed in to ByteSetBinarySearchMatcher.";
    private byte[] bytes;

    public ByteSetBinarySearchMatcher(Set<Byte> bytes, boolean inverted) {
        super(inverted);
        if (bytes == null || bytes.isEmpty()) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENTS);
        }
        this.bytes = new byte[bytes.size()];
        int byteIndex = 0;
        for (Byte b : bytes) {
            this.bytes[byteIndex++] = b;
        }
        Arrays.sort(this.bytes);
    }

    @Override
    public final boolean matches(byte theByte) {
        return Arrays.binarySearch(this.bytes, theByte) >= 0 ^ this.inverted;
    }

    @Override
    public final byte[] getMatchingBytes() {
        if (this.inverted) {
            byte[] invertedValues = new byte[this.getNumberOfMatchingBytes()];
            int byteIndex = 0;
            for (int value = 0; value < 256; ++value) {
                if (!this.matches((byte)value)) continue;
                invertedValues[byteIndex++] = (byte)value;
            }
            return invertedValues;
        }
        return this.bytes;
    }

    @Override
    public final int getNumberOfMatchingBytes() {
        return this.inverted ? 256 - this.bytes.length : this.bytes.length;
    }

    @Override
    public final String toRegularExpression(boolean prettyPrint) {
        StringBuilder regularExpression = new StringBuilder();
        if (prettyPrint) {
            regularExpression.append(' ');
        }
        regularExpression.append("[");
        if (this.inverted) {
            regularExpression.append("^");
        }
        int byteIndex = 0;
        while (byteIndex < this.bytes.length) {
            byte nextValue;
            int searchIndex;
            byte byteValue;
            byte lastValue = byteValue = this.bytes[byteIndex];
            for (searchIndex = byteIndex + 1; searchIndex < this.bytes.length && (nextValue = this.bytes[byteIndex]) == lastValue + 1; ++searchIndex) {
                lastValue = nextValue;
            }
            if (lastValue - byteValue > 2) {
                String minValue = ByteUtilities.byteToString(prettyPrint, byteValue);
                String maxValue = ByteUtilities.byteToString(prettyPrint, lastValue);
                regularExpression.append(String.format("%s-%s", minValue, maxValue));
                byteIndex = searchIndex + 1;
                continue;
            }
            String byteVal = ByteUtilities.byteToString(prettyPrint, byteValue);
            regularExpression.append(byteVal);
            ++byteIndex;
        }
        regularExpression.append("]");
        if (prettyPrint) {
            regularExpression.append(' ');
        }
        return regularExpression.toString();
    }

    @Override
    public final boolean matches(ByteReader reader, long matchFrom) {
        return this.matches(reader.readByte(matchFrom));
    }
}

