/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.singlebyte;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Set;
import net.domesdaybook.matcher.singlebyte.ByteMatcher;
import net.domesdaybook.matcher.singlebyte.ByteSetBinarySearchMatcher;
import net.domesdaybook.matcher.singlebyte.ByteSetRangeMatcher;
import net.domesdaybook.matcher.singlebyte.ByteUtilities;
import net.domesdaybook.matcher.singlebyte.InvertibleMatcher;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public final class ByteSetMatcher
extends InvertibleMatcher
implements SingleByteMatcher {
    private static final String ILLEGAL_ARGUMENTS = "Null or empty Byte set passed in to ByteSetMatcher.";
    private static final int BINARY_SEARCH_THRESHOLD = 16;
    private final BitSet byteValues = new BitSet(256);

    public static SingleByteMatcher buildOptimalMatcher(Set<Byte> setValues, boolean inverted) {
        if (setValues == null || setValues.isEmpty()) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENTS);
        }
        SingleByteMatcher result = null;
        int numberOfValues = setValues.size();
        if (numberOfValues == 1 && !inverted) {
            for (Byte byteToMatch : setValues) {
                result = new ByteMatcher(byteToMatch);
            }
        } else if (numberOfValues == 255 && inverted) {
            for (byte byteValue = -128; byteValue < 127; byteValue = (byte)(byteValue + 1)) {
                if (setValues.contains(byteValue)) continue;
                result = new ByteMatcher(byteValue);
                break;
            }
        } else if (numberOfValues > 0) {
            ArrayList<Integer> byteValues = new ArrayList<Integer>();
            for (Byte b : setValues) {
                byteValues.add(b & 0xFF);
            }
            Collections.sort(byteValues);
            int lastValuePosition = numberOfValues - 1;
            int firstValue = (Integer)byteValues.get(0);
            int lastValue = (Integer)byteValues.get(lastValuePosition);
            result = lastValue - firstValue == lastValuePosition ? new ByteSetRangeMatcher(firstValue, lastValue, inverted) : (byteValues.size() < 16 ? new ByteSetBinarySearchMatcher(setValues, inverted) : new ByteSetMatcher(setValues, inverted));
        }
        return result;
    }

    public ByteSetMatcher(Set<Byte> values, boolean inverted) {
        super(inverted);
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENTS);
        }
        for (Byte b : values) {
            this.byteValues.set((int)(b & 0xFF));
        }
    }

    @Override
    public final boolean matches(ByteReader reader, long matchFrom) {
        return this.matches(reader.readByte(matchFrom));
    }

    @Override
    public final boolean matches(byte theByte) {
        return this.byteValues.get(theByte & 0xFF) ^ this.inverted;
    }

    @Override
    public final String toRegularExpression(boolean prettyPrint) {
        StringBuilder regularExpression = new StringBuilder();
        if (prettyPrint) {
            regularExpression.append(' ');
        }
        regularExpression.append("[");
        if (this.inverted) {
            regularExpression.append("^");
        }
        int firstBitSetPosition = this.byteValues.nextSetBit(0);
        while (firstBitSetPosition >= 0 && firstBitSetPosition < 256) {
            int lastBitSetPosition = this.byteValues.nextClearBit(firstBitSetPosition) - 1;
            if (lastBitSetPosition < 0) {
                lastBitSetPosition = 255;
            }
            if (lastBitSetPosition - firstBitSetPosition > 2) {
                String minValue = ByteUtilities.byteToString(prettyPrint, firstBitSetPosition);
                String maxValue = ByteUtilities.byteToString(prettyPrint, lastBitSetPosition);
                regularExpression.append(String.format("%s-%s", minValue, maxValue));
            } else {
                String byteVal = ByteUtilities.byteToString(prettyPrint, firstBitSetPosition);
                regularExpression.append(byteVal);
                lastBitSetPosition = firstBitSetPosition;
            }
            firstBitSetPosition = this.byteValues.nextSetBit(lastBitSetPosition + 1);
        }
        regularExpression.append("]");
        if (prettyPrint) {
            regularExpression.append(' ');
        }
        return regularExpression.toString();
    }

    @Override
    public final byte[] getMatchingBytes() {
        byte[] values = new byte[this.getNumberOfMatchingBytes()];
        int byteIndex = 0;
        for (int value = 0; value < 256; ++value) {
            if (!(this.byteValues.get(value) ^ this.inverted)) continue;
            values[byteIndex++] = (byte)value;
        }
        return values;
    }

    @Override
    public final int getNumberOfMatchingBytes() {
        return this.inverted ? 256 - this.byteValues.cardinality() : this.byteValues.cardinality();
    }
}

