/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.Collection;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationParams;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaValidator
implements Destination {
    private Configuration config;
    private boolean lax;
    private ErrorListener errorListener;
    private Destination destination;
    private QName documentElementName;
    private SchemaType documentElementType;
    private boolean expandAttributeDefaults = true;
    private boolean useXsiSchemaLocation;
    private GlobalParameterSet suppliedParams = new GlobalParameterSet();

    protected SchemaValidator(Configuration config) {
        this.config = config;
        this.useXsiSchemaLocation = (Boolean)config.getConfigurationProperty("http://saxon.sf.net/feature/useXsiSchemaLocation");
    }

    public void setLax(boolean lax) {
        this.lax = lax;
    }

    public boolean isLax() {
        return this.lax;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setUseXsiSchemaLocation(boolean recognize) {
        this.useXsiSchemaLocation = recognize;
    }

    public boolean isUseXsiSchemaLocation() {
        return this.useXsiSchemaLocation;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDocumentElementName(QName name) {
        this.documentElementName = name;
    }

    public QName getDocumentElementName() {
        return this.documentElementName;
    }

    public void setDocumentElementTypeName(QName name) throws SaxonApiException {
        int fp = this.config.getNamePool().allocate("", name.getNamespaceURI(), name.getLocalName());
        this.documentElementType = this.config.getSchemaType(fp);
        if (this.documentElementType == null) {
            throw new SaxonApiException("Unknown type " + name.getClarkName());
        }
    }

    public QName getDocumentElementTypeName() {
        if (this.documentElementType == null) {
            return null;
        }
        int fp = this.documentElementType.getFingerprint();
        return new QName(this.config.getNamePool().getStructuredQName(fp));
    }

    protected SchemaType getDocumentElementType() {
        return this.documentElementType;
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.expandAttributeDefaults = expand;
    }

    public boolean isExpandAttributeDefaults() {
        return this.expandAttributeDefaults;
    }

    public void setParameter(QName name, XdmValue value) {
        this.suppliedParams.put(name.getStructuredQName(), value == null ? null : value.getUnderlyingValue());
    }

    public XdmValue getParameter(QName name) {
        return XdmValue.wrap((Sequence)this.suppliedParams.get(name.getStructuredQName()));
    }

    public void validate(Source source) throws SaxonApiException {
        Receiver receiver = this.getReceiver(this.config, source.getSystemId());
        try {
            ParseOptions options = new ParseOptions();
            options.setValidationParams(this.convertParams(this.suppliedParams, this.config.getDeclaredSchemaParameters()));
            Sender.send(source, receiver, options);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        finally {
            if (this.destination != null) {
                this.destination.close();
            }
        }
    }

    protected ValidationParams convertParams(GlobalParameterSet suppliedParams, Collection<GlobalParam> declaredParams) throws XPathException {
        ValidationParams vp = new ValidationParams();
        XPathContextMajor context = new Controller(this.config).newXPathContext();
        for (GlobalParam cp : declaredParams) {
            SequenceExtent<? extends Item> value = suppliedParams.convertParameterValue(cp.getVariableQName(), cp.getRequiredType(), true, context);
            if (value == null) continue;
            if (!(value instanceof GroundedValue)) {
                value = new SequenceExtent<Item>(value.iterate());
            }
            vp.put(cp.getVariableQName(), value);
        }
        return vp;
    }

    @Override
    public Receiver getReceiver(Configuration config) throws SaxonApiException {
        return this.getReceiver(config, null);
    }

    private Receiver getReceiver(Configuration config, String systemId) throws SaxonApiException {
        Controller controller = new Controller(config);
        controller.getExecutable().setSchemaAware(true);
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        pipe.setExpandAttributeDefaults(this.expandAttributeDefaults);
        pipe.setUseXsiSchemaLocation(this.useXsiSchemaLocation);
        pipe.setController(controller);
        ParseOptions options = pipe.getParseOptions();
        options.setCheckEntityReferences(true);
        options.setSchemaValidationMode(this.lax ? 2 : 1);
        options.setStripSpace(0);
        options.setTopLevelType(this.documentElementType);
        if (this.documentElementName != null) {
            options.setTopLevelElement(new FingerprintedQName(this.documentElementName.getPrefix(), this.documentElementName.getNamespaceURI(), this.documentElementName.getLocalName()));
        }
        try {
            options.setValidationParams(this.convertParams(this.suppliedParams, config.getDeclaredSchemaParameters()));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        Receiver output = this.destination == null ? new Sink(pipe) : this.destination.getReceiver(config);
        output.setPipelineConfiguration(pipe);
        Receiver receiver = config.getDocumentValidator(output, systemId, options);
        if (this.errorListener != null) {
            pipe.setErrorListener(this.errorListener);
        }
        return receiver;
    }

    @Override
    public void close() throws SaxonApiException {
        if (this.destination != null) {
            this.destination.close();
            this.destination = null;
        }
    }
}

