/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

final class LittleEndian {
    private LittleEndian() {
    }

    public static short readShort(byte[] buf, int off) {
        return (short)(buf[off + 1] << 8 | buf[off] & 0xFF);
    }

    public static int readUShort(byte[] buf, int off) {
        return (buf[off + 1] & 0xFF) << 8 | buf[off] & 0xFF;
    }

    public static int readInt(byte[] buf, int off) {
        off += 3;
        int i = buf[off--];
        i <<= 8;
        i |= buf[off--] & 0xFF;
        i <<= 8;
        i |= buf[off--] & 0xFF;
        i <<= 8;
        return i |= buf[off] & 0xFF;
    }

    public static long readUInt(byte[] buf, int off) {
        return (long)LittleEndian.readInt(buf, off) & 0xFFFFFFFFL;
    }

    public static long readLong(byte[] buf, int off) {
        off += 7;
        long l = buf[off--];
        l <<= 8;
        l |= (long)buf[off--] & 0xFFL;
        l <<= 8;
        l |= (long)buf[off--] & 0xFFL;
        l <<= 8;
        l |= (long)buf[off--] & 0xFFL;
        l <<= 8;
        l |= (long)buf[off--] & 0xFFL;
        l <<= 8;
        l |= (long)buf[off--] & 0xFFL;
        l <<= 8;
        l |= (long)buf[off--] & 0xFFL;
        l <<= 8;
        return l |= (long)buf[off] & 0xFFL;
    }

    public static void writeShort(int s, byte[] buf, int off) {
        buf[off] = (byte)s;
        buf[off + 1] = (byte)(s >>= 8);
    }

    public static void writeInt(int i, byte[] buf, int off) {
        buf[off] = (byte)i;
        buf[off + 1] = (byte)(i >>= 8);
        buf[off + 2] = (byte)(i >>= 8);
        buf[off + 3] = (byte)(i >>= 8);
    }

    public static void writeLong(long l, byte[] buf, int off) {
        buf[off] = (byte)l;
        buf[off + 1] = (byte)(l >>= 8);
        buf[off + 2] = (byte)(l >>= 8);
        buf[off + 3] = (byte)(l >>= 8);
        buf[off + 4] = (byte)(l >>= 8);
        buf[off + 5] = (byte)(l >>= 8);
        buf[off + 6] = (byte)(l >>= 8);
        buf[off + 7] = (byte)(l >>= 8);
    }
}

