/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AESAudioMetadata {
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    public static final String[] A_D = new String[]{"ANALOG", "PHYS_DIGITAL", "FILE_DIGITAL"};
    public static final String FILE_NAME = "FILE_NAME";
    public static final String OTHER = "OTHER";
    public static final int NULL = -1;
    public static final double NILL = -1.0;
    public static final String SCHEMA_VERSION = "1.02b";
    private static final String DEFAULT_DISPOSITION = "validation";
    private String _analogDigitalFlag = null;
    private String _appSpecificData;
    private String _audioDataEncoding = null;
    private int _byteOrder;
    private String _disposition = "validation";
    private List _faceList;
    private long _firstSampleOffset;
    private String _format = null;
    private List _formatList = new LinkedList();
    private int _numChannels;
    private String _primaryIdentifier = null;
    private String _primaryIdentifierType = null;
    private String _primaryIdentifierOtherType;
    private String _schemaVersion = "1.02b";
    private String _specificationVersion = null;
    private String[] _use = null;
    private FormatRegion _curFormatRegion;
    private Face _curFace;

    public AESAudioMetadata() {
        this._faceList = new LinkedList();
        this.addFormatRegion();
        this.addFace();
        this._numChannels = -1;
        this._byteOrder = -1;
        this._firstSampleOffset = -1L;
    }

    public String getAnalogDigitalFlag() {
        return this._analogDigitalFlag;
    }

    public String getAppSpecificData() {
        return this._appSpecificData;
    }

    public String getAudioDataEncoding() {
        return this._audioDataEncoding;
    }

    public String[] getBitrateReduction() {
        return this._curFormatRegion.getBitrateReduction();
    }

    public double getSampleRate() {
        return this._curFormatRegion.getSampleRate();
    }

    public int getByteOrder() {
        return this._byteOrder;
    }

    public String getDisposition() {
        return this._disposition;
    }

    public List getFaceList() {
        return this._faceList;
    }

    public long getFirstSampleOffset() {
        return this._firstSampleOffset;
    }

    public String getFormat() {
        return this._format;
    }

    public List getFormatList() {
        return this._formatList;
    }

    public String[] getMapLocations() {
        return this._curFace.getFaceRegion(0).getMapLocations();
    }

    public int getNumChannels() {
        return this._numChannels;
    }

    public String getPrimaryIdentifier() {
        return this._primaryIdentifier;
    }

    public String getPrimaryIdentifierType() {
        return this._primaryIdentifierType;
    }

    public String getSchemaVersion() {
        return this._schemaVersion;
    }

    public String getSpecificationVersion() {
        return this._specificationVersion;
    }

    public String[] getUse() {
        return this._use;
    }

    public void setAnalogDigitalFlag(String string) {
        this._analogDigitalFlag = string;
    }

    public void setBitrateReduction(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this._curFormatRegion.setBitrateReduction(string, string2, string3, string4, string5, string6, string7);
    }

    public void clearBitrateReduction() {
        this._curFormatRegion.clearBitrateReduction();
    }

    public void setByteOrder(int n) {
        this._byteOrder = n;
    }

    public void setByteOrder(String string) {
        if (string.substring(0, 3).toLowerCase().equals("big")) {
            this._byteOrder = 0;
        } else if (string.substring(0, 6).toLowerCase().equals("little")) {
            this._byteOrder = 1;
        }
    }

    public void setAudioDataEncoding(String string) {
        this._audioDataEncoding = string;
    }

    public void setAppSpecificData(String string) {
        this._appSpecificData = string;
    }

    public void setBitDepth(int n) {
        this._curFormatRegion.setBitDepth(n);
    }

    public void setDisposition(String string) {
        this._disposition = string;
    }

    public void setDirection(String string) {
        this._curFace.setDirection(string);
    }

    public void setDuration(long l) {
        this._curFace.setDuration(l);
        this._curFace.getFaceRegion(0).setDuration(l);
    }

    public void setFirstSampleOffset(long l) {
        this._firstSampleOffset = l;
    }

    public void setFormat(String string) {
        this._format = string;
    }

    public void setMapLocations(String[] stringArray) {
        this._curFace.getFaceRegion(0).setMapLocations(stringArray);
    }

    public void setNumChannels(int n) {
        this._numChannels = n;
    }

    public void setPrimaryIdentifier(String string) {
        this._primaryIdentifier = string;
    }

    public void setPrimaryIdentifierType(String string) {
        this._primaryIdentifierType = string;
    }

    public void setOtherPrimaryIdentifierType(String string) {
        this._primaryIdentifierType = OTHER;
        this._primaryIdentifierOtherType = string;
    }

    public void setSampleRate(double d) {
        this._curFormatRegion.setSampleRate(d);
    }

    public void setSpecificationVersion(String string) {
        this._specificationVersion = string;
    }

    public void setStartTime(long l) {
        this._curFace.setStartTime(l);
        this._curFace.getFaceRegion(0).setStartTime(l);
    }

    public void setUse(String string, String string2) {
        this._use = new String[]{string, string2};
    }

    public void setWordSize(int n) {
        this._curFormatRegion.setWordSize(n);
    }

    public void addFormatRegion() {
        this._curFormatRegion = new FormatRegionImpl();
        this._formatList.add(this._curFormatRegion);
    }

    public void addFace() {
        this._curFace = new FaceImpl();
        this._faceList.add(this._curFace);
        this._curFace.addFaceRegion();
    }

    class FaceRegionImpl
    implements FaceRegion {
        private TimeDesc _startTime;
        private TimeDesc _duration;
        private String[] _mapLocations;

        public FaceRegionImpl() {
            this._startTime = new TimeDescImpl(0L);
            this._duration = null;
        }

        public TimeDesc getStartTime() {
            return this._startTime;
        }

        public TimeDesc getDuration() {
            return this._duration;
        }

        public String[] getMapLocations() {
            return this._mapLocations;
        }

        public void setStartTime(long l) {
            this._startTime = new TimeDescImpl(l);
        }

        public void setDuration(long l) {
            this._duration = new TimeDescImpl(l);
        }

        public void setMapLocations(String[] stringArray) {
            this._mapLocations = stringArray;
        }
    }

    class FaceImpl
    implements Face {
        List _regionList = new ArrayList();
        TimeDesc _startTime;
        TimeDesc _duration;
        String _direction;

        public FaceImpl() {
            this._startTime = new TimeDescImpl(0L);
            this._duration = null;
        }

        public FaceRegion getFaceRegion(int n) {
            return (FaceRegion)this._regionList.get(n);
        }

        public void addFaceRegion() {
            this._regionList.add(new FaceRegionImpl());
        }

        public TimeDesc getStartTime() {
            return this._startTime;
        }

        public TimeDesc getDuration() {
            return this._duration;
        }

        public String getDirection() {
            return this._direction;
        }

        public void setStartTime(long l) {
            this._startTime = new TimeDescImpl(l);
        }

        public void setDuration(long l) {
            this._duration = new TimeDescImpl(l);
        }

        public void setDirection(String string) {
            this._direction = string;
        }
    }

    class TimeDescImpl
    implements TimeDesc {
        private int _hours;
        private int _minutes;
        private int _seconds;
        private int _frames;
        private int _samples;
        private double _sampleRate;
        private int _frameCount;

        public TimeDescImpl(long l) {
            long l2 = l;
            this._frameCount = 30;
            this._sampleRate = AESAudioMetadata.this._curFormatRegion.getSampleRate();
            if (this._sampleRate < 0.0) {
                this._sampleRate = 44100.0;
            }
            long l3 = (long)(this._sampleRate / (double)this._frameCount);
            long l4 = l3 * (long)this._frameCount;
            long l5 = l3 * (long)this._frameCount * 60L;
            long l6 = l3 * (long)this._frameCount * 60L * 60L;
            long l7 = l3 * (long)this._frameCount * 60L * 60L * 24L;
            if (l2 < 0L) {
                l2 += l7;
                l2 %= l7;
            }
            this._hours = (int)(l2 / l6);
            this._minutes = (int)((l2 -= (long)this._hours * l6) / l5);
            this._seconds = (int)((l2 -= (long)this._minutes * l5) / l4);
            this._frames = (int)((l2 -= (long)this._seconds * l4) / l3);
            this._samples = (int)(l2 -= (long)this._frames * l3);
            this._hours %= 24;
        }

        public int getHours() {
            return this._hours;
        }

        public int getMinutes() {
            return this._minutes;
        }

        public int getSeconds() {
            return this._seconds;
        }

        public int getFrames() {
            return this._frames;
        }

        public int getSamples() {
            return this._samples;
        }

        public double getSampleRate() {
            return this._sampleRate;
        }
    }

    class FormatRegionImpl
    implements FormatRegion {
        private int _bitDepth = -1;
        private double _sampleRate = -1.0;
        private int _wordSize = -1;
        private String[] _bitrateReduction = null;

        public int getBitDepth() {
            return this._bitDepth;
        }

        public String[] getBitrateReduction() {
            return this._bitrateReduction;
        }

        public double getSampleRate() {
            return this._sampleRate;
        }

        public int getWordSize() {
            return this._wordSize;
        }

        public boolean isEmpty() {
            return this._bitDepth == -1 && this._sampleRate == -1.0 && this._wordSize == -1;
        }

        public void setBitDepth(int n) {
            this._bitDepth = n;
        }

        public void clearBitrateReduction() {
            this._bitrateReduction = null;
        }

        public void setBitrateReduction(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            this._bitrateReduction = new String[7];
            this._bitrateReduction[0] = string;
            this._bitrateReduction[1] = string2;
            this._bitrateReduction[2] = string3;
            this._bitrateReduction[3] = string4;
            this._bitrateReduction[4] = string5;
            this._bitrateReduction[5] = string6;
            this._bitrateReduction[6] = string7;
        }

        public void setSampleRate(double d) {
            this._sampleRate = d;
        }

        public void setWordSize(int n) {
            this._wordSize = n;
        }
    }

    public static interface FaceRegion {
        public TimeDesc getStartTime();

        public TimeDesc getDuration();

        public String[] getMapLocations();

        public void setStartTime(long var1);

        public void setDuration(long var1);

        public void setMapLocations(String[] var1);
    }

    public static interface Face {
        public FaceRegion getFaceRegion(int var1);

        public void addFaceRegion();

        public TimeDesc getStartTime();

        public TimeDesc getDuration();

        public String getDirection();

        public void setStartTime(long var1);

        public void setDuration(long var1);

        public void setDirection(String var1);
    }

    public static interface TimeDesc {
        public int getHours();

        public int getMinutes();

        public int getSeconds();

        public int getFrames();

        public int getSamples();

        public double getSampleRate();
    }

    public static interface FormatRegion {
        public int getBitDepth();

        public String[] getBitrateReduction();

        public double getSampleRate();

        public int getWordSize();

        public boolean isEmpty();

        public void setBitDepth(int var1);

        public void clearBitrateReduction();

        public void setBitrateReduction(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

        public void setSampleRate(double var1);

        public void setWordSize(int var1);
    }
}

