/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountedInputStream
extends FilterInputStream {
    private int bytesLeft;

    public CountedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.bytesLeft = n;
    }

    public int read() throws IOException {
        if (this.bytesLeft <= 0) {
            return -1;
        }
        int n = super.read();
        if (n != -1) {
            --this.bytesLeft;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = byArray.length;
        int n2 = n <= this.bytesLeft ? super.read(byArray) : super.read(byArray, 0, this.bytesLeft);
        this.bytesLeft -= n2;
        return n2;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2 <= this.bytesLeft ? super.read(byArray, n, n2) : super.read(byArray, n, this.bytesLeft);
        this.bytesLeft -= n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.bytesLeft = (long)this.bytesLeft < l2 ? 0 : (int)((long)this.bytesLeft - l2);
        return l2;
    }
}

